/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ValidateException;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasOptionsUtils {
    private static final Logger log = LoggerFactory.getLogger(JaasOptionsUtils.class);
    private final Map<String, Object> options;

    public JaasOptionsUtils(Map<String, Object> options) {
        this.options = options;
    }

    public static Map<String, Object> getOptions(String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException(String.format("Unexpected SASL mechanism: %s", saslMechanism));
        }
        if (Objects.requireNonNull(jaasConfigEntries).size() != 1 || jaasConfigEntries.get(0) == null) {
            throw new IllegalArgumentException(String.format("Must supply exactly 1 non-null JAAS mechanism configuration (size was %d)", jaasConfigEntries.size()));
        }
        return Collections.unmodifiableMap(jaasConfigEntries.get(0).getOptions());
    }

    public boolean shouldCreateSSLSocketFactory(URL url) {
        return url.getProtocol().equalsIgnoreCase("https");
    }

    public Map<String, ?> getSslClientConfig() {
        ConfigDef sslConfigDef = new ConfigDef();
        sslConfigDef.withClientSslSupport();
        AbstractConfig sslClientConfig = new AbstractConfig(sslConfigDef, this.options);
        return sslClientConfig.values();
    }

    public SSLSocketFactory createSSLSocketFactory() {
        Map<String, ?> sslClientConfig = this.getSslClientConfig();
        SslFactory sslFactory = new SslFactory(ConnectionMode.CLIENT);
        sslFactory.configure(sslClientConfig);
        SSLSocketFactory socketFactory = ((DefaultSslEngineFactory)sslFactory.sslEngineFactory()).sslContext().getSocketFactory();
        log.debug("Created SSLSocketFactory: {}", (Object)sslClientConfig);
        return socketFactory;
    }

    public String validateString(String name) throws ValidateException {
        return this.validateString(name, true);
    }

    public String validateString(String name, boolean isRequired) throws ValidateException {
        String value = (String)this.options.get(name);
        if (value == null) {
            if (isRequired) {
                throw new ConfigException(String.format("The OAuth configuration option %s value must be non-null", name));
            }
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            if (isRequired) {
                throw new ConfigException(String.format("The OAuth configuration option %s value must not contain only whitespace", name));
            }
            return null;
        }
        return value;
    }
}

