/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.common.ui;

import java.io.IOException;
import java.net.URL;
import java.util.PropertyResourceBundle;
import org.apache.directory.studio.common.ui.Messages;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CommonUIPlugin
extends AbstractUIPlugin {
    private static CommonUIPlugin plugin;
    private PropertyResourceBundle properties;
    private ColorRegistry colorRegistry;

    public CommonUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (this.colorRegistry == null) {
            this.colorRegistry = new ColorRegistry(PlatformUI.getWorkbench().getDisplay());
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.colorRegistry != null) {
            this.colorRegistry = null;
        }
        super.stop(context);
    }

    public static CommonUIPlugin getDefault() {
        return plugin;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        if (key != null) {
            URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path(key), null);
            if (url != null) {
                return ImageDescriptor.createFromURL((URL)url);
            }
            return null;
        }
        return null;
    }

    public Image getImage(String key) {
        ImageDescriptor id;
        Image image = this.getImageRegistry().get(key);
        if (image == null && (id = this.getImageDescriptor(key)) != null) {
            image = id.createImage();
            this.getImageRegistry().put(key, image);
        }
        return image;
    }

    public PropertyResourceBundle getPluginProperties() {
        if (this.properties == null) {
            try {
                this.properties = new PropertyResourceBundle(FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path("plugin.properties"), (boolean)false));
            }
            catch (IOException e) {
                this.getLog().log((IStatus)new Status(4, "org.apache.directory.studio.common.ui", 0, Messages.getString("CommonUIPlugin.UnableGetPluginProperties"), (Throwable)e));
            }
        }
        return this.properties;
    }

    public Color getColor(RGB rgb) {
        if (!this.colorRegistry.hasValueFor(rgb.toString())) {
            this.colorRegistry.put(rgb.toString(), rgb);
        }
        return this.colorRegistry.get(rgb.toString());
    }

    public Color getColor(String name) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.isDefault(name)) {
            return null;
        }
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)name);
        Color color = this.getColor(rgb);
        return color;
    }
}

