/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.common.ui;

import java.util.function.Function;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;

public class ClipboardUtils {
    public static Object getFromClipboard(Transfer transfer) {
        return ClipboardUtils.getFromClipboard(transfer, Object.class);
    }

    public static <T> T getFromClipboard(Transfer transfer, Class<T> type) {
        return (T)ClipboardUtils.withClipboard(clipboard -> {
            Object contents;
            if (ClipboardUtils.isAvailable(transfer, clipboard).booleanValue() && (contents = clipboard.getContents(transfer)) != null && type.isAssignableFrom(contents.getClass())) {
                return type.cast(contents);
            }
            return null;
        });
    }

    public static boolean isAvailable(Transfer transfer) {
        return ClipboardUtils.withClipboard(clipboard -> ClipboardUtils.isAvailable(transfer, clipboard));
    }

    private static Boolean isAvailable(Transfer transfer, Clipboard clipboard) {
        TransferData[] transferDataArray = clipboard.getAvailableTypes();
        int n = transferDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData transferData = transferDataArray[n2];
            if (transfer.isSupportedType(transferData)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static <T> T withClipboard(Function<Clipboard, T> fn) {
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(Display.getCurrent());
            T t = fn.apply(clipboard);
            return t;
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }
}

