/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.logger;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.GetRootDseOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerInterceptor
extends BaseInterceptor {
    private static final Logger OPERATION_STATS = LoggerFactory.getLogger((String)Loggers.OPERATION_STAT.getName());
    private static final Logger OPERATION_TIME = LoggerFactory.getLogger((String)Loggers.OPERATION_TIME.getName());
    private static final boolean IS_DEBUG_STATS = OPERATION_STATS.isDebugEnabled();
    private static final boolean IS_DEBUG_TIME = OPERATION_TIME.isDebugEnabled();
    private static AtomicLong totalAdd = new AtomicLong(0L);
    private static AtomicInteger nbAddCalls = new AtomicInteger(0);
    private static AtomicLong totalBind = new AtomicLong(0L);
    private static AtomicInteger nbBindCalls = new AtomicInteger(0);
    private static AtomicLong totalCompare = new AtomicLong(0L);
    private static AtomicInteger nbCompareCalls = new AtomicInteger(0);
    private static AtomicLong totalDelete = new AtomicLong(0L);
    private static AtomicInteger nbDeleteCalls = new AtomicInteger(0);
    private static AtomicLong totalGetRootDse = new AtomicLong(0L);
    private static AtomicInteger nbGetRootDseCalls = new AtomicInteger(0);
    private static AtomicLong totalHasEntry = new AtomicLong(0L);
    private static AtomicInteger nbHasEntryCalls = new AtomicInteger(0);
    private static AtomicLong totalLookup = new AtomicLong(0L);
    private static AtomicInteger nbLookupCalls = new AtomicInteger(0);
    private static AtomicLong totalModify = new AtomicLong(0L);
    private static AtomicInteger nbModifyCalls = new AtomicInteger(0);
    private static AtomicLong totalMove = new AtomicLong(0L);
    private static AtomicInteger nbMoveCalls = new AtomicInteger(0);
    private static AtomicLong totalMoveAndRename = new AtomicLong(0L);
    private static AtomicInteger nbMoveAndRenameCalls = new AtomicInteger(0);
    private static AtomicLong totalRename = new AtomicLong(0L);
    private static AtomicInteger nbRenameCalls = new AtomicInteger(0);
    private static AtomicLong totalSearch = new AtomicLong(0L);
    private static AtomicInteger nbSearchCalls = new AtomicInteger(0);
    private static AtomicLong totalUnbind = new AtomicLong(0L);
    private static AtomicInteger nbUnbindCalls = new AtomicInteger(0);

    public TimerInterceptor(String name) {
        super(name);
    }

    public void init(DirectoryService directoryService) throws LdapException {
    }

    public void add(AddOperationContext addContext) throws LdapException {
        long t0 = System.nanoTime();
        this.next(addContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbAddCalls.incrementAndGet();
            totalAdd.getAndAdd(delta);
            if (nbAddCalls.get() % 1000 == 0) {
                long average = totalAdd.get() / (long)(nbAddCalls.get() * 1000);
                OPERATION_STATS.debug("{} : Average add = {} microseconds, nb adds = {}", new Object[]{this.getName(), average, nbAddCalls.get()});
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta add = {}", (Object)this.getName(), (Object)delta);
        }
    }

    public void bind(BindOperationContext bindContext) throws LdapException {
        long t0 = System.nanoTime();
        this.next(bindContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbBindCalls.incrementAndGet();
            totalBind.getAndAdd(delta);
            if (nbBindCalls.get() % 1000 == 0) {
                long average = totalBind.get() / (long)(nbBindCalls.get() * 1000);
                OPERATION_STATS.debug("{} : Average bind = {} microseconds, nb binds = {}", new Object[]{this.getName(), average, nbBindCalls.get()});
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta bind = {}", (Object)this.getName(), (Object)delta);
        }
    }

    public boolean compare(CompareOperationContext compareContext) throws LdapException {
        long t0 = System.nanoTime();
        boolean compare = this.next(compareContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbCompareCalls.incrementAndGet();
            totalCompare.getAndAdd(delta);
            if (nbCompareCalls.get() % 1000 == 0) {
                long average = totalCompare.get() / (long)(nbCompareCalls.get() * 1000);
                OPERATION_STATS.debug("{} : Average compare = {} microseconds, nb compares = {}", new Object[]{this.getName(), average, nbCompareCalls.get()});
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta compare = {}", (Object)this.getName(), (Object)delta);
        }
        return compare;
    }

    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        long t0 = System.nanoTime();
        this.next(deleteContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbDeleteCalls.incrementAndGet();
            totalDelete.getAndAdd(delta);
            if (nbDeleteCalls.get() % 1000 == 0) {
                long average = totalDelete.get() / (long)(nbDeleteCalls.get() * 1000);
                OPERATION_STATS.debug("{} : Average delete = {} microseconds, nb deletes = {}", new Object[]{this.getName(), average, nbDeleteCalls.get()});
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta delete = {}", (Object)this.getName(), (Object)delta);
        }
    }

    public Entry getRootDse(GetRootDseOperationContext getRootDseContext) throws LdapException {
        long t0 = System.nanoTime();
        Entry rootDse = this.next(getRootDseContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbGetRootDseCalls.incrementAndGet();
            totalGetRootDse.getAndAdd(delta);
            if (nbGetRootDseCalls.get() % 1000 == 0) {
                long average = totalGetRootDse.get() / (long)(nbGetRootDseCalls.get() * 1000);
                OPERATION_STATS.debug("{} : Average getRootDSE = {} microseconds, nb getRootDSEs = {}", new Object[]{this.getName(), average, nbGetRootDseCalls.get()});
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta getRootDSE = {}", (Object)this.getName(), (Object)delta);
        }
        return rootDse;
    }

    public boolean hasEntry(HasEntryOperationContext hasEntryContext) throws LdapException {
        long t0 = System.nanoTime();
        boolean hasEntry = this.next(hasEntryContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbHasEntryCalls.incrementAndGet();
            totalHasEntry.getAndAdd(delta);
            if (nbHasEntryCalls.get() % 1000 == 0) {
                long average = totalHasEntry.get() / (long)(nbHasEntryCalls.get() * 1000);
                OPERATION_STATS.debug("{} : Average hasEntry = {} microseconds, nb hasEntrys = {}", new Object[]{this.getName(), average, nbHasEntryCalls.get()});
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta hasEntry = {}", (Object)this.getName(), (Object)delta);
        }
        return hasEntry;
    }

    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        long t0 = System.nanoTime();
        Entry entry = this.next(lookupContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbLookupCalls.incrementAndGet();
            totalLookup.getAndAdd(delta);
            if (nbLookupCalls.get() % 1000 == 0) {
                long average = totalLookup.get() / (long)(nbLookupCalls.get() * 1000);
                OPERATION_STATS.debug("{} : Average lookup = {} microseconds, nb lookups = {}", new Object[]{this.getName(), average, nbLookupCalls.get()});
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta lookup = {}", (Object)this.getName(), (Object)delta);
        }
        return entry;
    }

    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        long t0 = System.nanoTime();
        this.next(modifyContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbModifyCalls.incrementAndGet();
            totalModify.getAndAdd(delta);
            if (nbModifyCalls.get() % 1000 == 0) {
                long average = totalModify.get() / (long)(nbModifyCalls.get() * 1000);
                OPERATION_STATS.debug("{} : Average modify = {} microseconds, nb modifys = {}", new Object[]{this.getName(), average, nbModifyCalls.get()});
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta modify = {}", (Object)this.getName(), (Object)delta);
        }
    }

    public void move(MoveOperationContext moveContext) throws LdapException {
        long t0 = System.nanoTime();
        this.next(moveContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbMoveCalls.incrementAndGet();
            totalMove.getAndAdd(delta);
            if (nbMoveCalls.get() % 1000 == 0) {
                long average = totalMove.get() / (long)(nbMoveCalls.get() * 1000);
                OPERATION_STATS.debug("{} : Average move = {} microseconds, nb moves = {}", new Object[]{this.getName(), average, nbMoveCalls.get()});
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta move = {}", (Object)this.getName(), (Object)delta);
        }
    }

    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        long t0 = System.nanoTime();
        this.next(moveAndRenameContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbMoveAndRenameCalls.incrementAndGet();
            totalMoveAndRename.getAndAdd(delta);
            if (nbMoveAndRenameCalls.get() % 1000 == 0) {
                long average = totalMoveAndRename.get() / (long)(nbMoveAndRenameCalls.get() * 1000);
                OPERATION_STATS.debug("{} : Average moveAndRename = {} microseconds, nb moveAndRenames = {}", new Object[]{this.getName(), average, nbMoveAndRenameCalls.get()});
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta moveAndRename = {}", (Object)this.getName(), (Object)delta);
        }
    }

    public void rename(RenameOperationContext renameContext) throws LdapException {
        long t0 = System.nanoTime();
        this.next(renameContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbRenameCalls.incrementAndGet();
            totalRename.getAndAdd(delta);
            if (nbRenameCalls.get() % 1000 == 0) {
                long average = totalRename.get() / (long)(nbRenameCalls.get() * 1000);
                OPERATION_STATS.debug("{} : Average rename = {} microseconds, nb renames = {}", new Object[]{this.getName(), average, nbRenameCalls.get()});
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta rename = {}", (Object)this.getName(), (Object)delta);
        }
    }

    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        long t0 = System.nanoTime();
        EntryFilteringCursor cursor = this.next(searchContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbSearchCalls.incrementAndGet();
            totalSearch.getAndAdd(delta);
            if (nbSearchCalls.get() % 1000 == 0) {
                long average = totalSearch.get() / (long)(nbSearchCalls.get() * 1000);
                OPERATION_STATS.debug("{} : Average search = {} microseconds, nb searches = {}", new Object[]{this.getName(), average, nbSearchCalls.get()});
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta search = {}", (Object)this.getName(), (Object)delta);
        }
        return cursor;
    }

    public void unbind(UnbindOperationContext unbindContext) throws LdapException {
        long t0 = System.nanoTime();
        this.next(unbindContext);
        long delta = System.nanoTime() - t0;
        if (IS_DEBUG_STATS) {
            nbUnbindCalls.incrementAndGet();
            totalUnbind.getAndAdd(delta);
            if (nbUnbindCalls.get() % 1000 == 0) {
                long average = totalUnbind.get() / (long)(nbUnbindCalls.get() * 1000);
                OPERATION_STATS.debug("{} : Average unbind = {} microseconds, nb unbinds = {}", new Object[]{this.getName(), average, nbUnbindCalls.get()});
            }
        }
        if (IS_DEBUG_TIME) {
            OPERATION_TIME.debug("{} : Delta unbind = {}", (Object)this.getName(), (Object)delta);
        }
    }
}

