/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.AuditMgr;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.Mod;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserAudit;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.web.model.SerializableList;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditModListModel
extends Model<SerializableList<Mod>> {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private AuditMgr auditMgr;
    @SpringBean
    private ReviewMgr reviewMgr;
    private static final Logger LOG = LoggerFactory.getLogger((String)AuditModListModel.class.getName());
    private UserAudit userAudit;
    private SerializableList<Mod> mods = null;

    public AuditModListModel(Session session) {
        Injector.get().inject((Object)this);
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.auditMgr.setAdmin(session);
        }
    }

    public AuditModListModel(UserAudit userAudit, Session session) {
        Injector.get().inject((Object)this);
        this.userAudit = userAudit;
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.auditMgr.setAdmin(session);
        }
    }

    public SerializableList<Mod> getObject() {
        if (this.mods != null) {
            LOG.debug(".getObject count: " + this.mods.size());
            return this.mods;
        }
        if (this.userAudit == null || !StringUtils.isNotEmpty((CharSequence)this.userAudit.getUserId()) && !StringUtils.isNotEmpty((CharSequence)this.userAudit.getObjName()) && !StringUtils.isNotEmpty((CharSequence)this.userAudit.getOpName()) && this.userAudit.getBeginDate() == null && this.userAudit.getEndDate() == null) {
            LOG.debug(".getObject null");
            this.mods = new SerializableList(new ArrayList());
        } else {
            if (StringUtils.isNotEmpty((CharSequence)this.userAudit.getUserId()) && !StringUtils.isNotEmpty((CharSequence)this.userAudit.getInternalUserId())) {
                User user = this.getUser(this.userAudit);
                if (user == null) {
                    String warning = "Matching user not found for userId: " + this.userAudit.getUserId();
                    LOG.warn(warning);
                } else {
                    this.userAudit.setInternalUserId(user.getInternalId());
                }
            }
            this.mods = new SerializableList(this.getList(this.userAudit));
        }
        return this.mods;
    }

    public void setObject(SerializableList<Mod> object) {
        LOG.debug(".setObject count: " + object.size());
        this.mods = object;
    }

    public void detach() {
        this.mods = null;
        this.userAudit = null;
    }

    private List<Mod> getList(UserAudit userAudit) {
        List modList = null;
        try {
            userAudit.setDn("");
            if (StringUtils.isNotEmpty((CharSequence)userAudit.getObjName())) {
                userAudit.setObjName(this.getTruncatedObjName(userAudit.getObjName()));
            }
            modList = this.auditMgr.searchAdminMods(userAudit);
        }
        catch (SecurityException se) {
            String error = ".getList caught SecurityException=" + se;
            LOG.warn(error);
            modList = new SerializableList(new ArrayList());
        }
        return modList;
    }

    private String getTruncatedObjName(String szObj) {
        int indx = szObj.lastIndexOf(46);
        if (indx == -1) {
            return szObj;
        }
        return szObj.substring(indx + 1);
    }

    private User getUser(UserAudit userAudit) {
        User user = null;
        try {
            user = this.reviewMgr.readUser(new User(userAudit.getUserId()));
        }
        catch (SecurityException se) {
            String error = ".getUser caught SecurityException=" + se;
            throw new RuntimeException(error, se);
        }
        return user;
    }
}

