/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.strings;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.tuple.CompactTupleSketch;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleAnotB;
import org.apache.datasketches.tuple.TupleIntersection;
import org.apache.datasketches.tuple.TupleSketch;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.TupleUnion;
import org.apache.datasketches.tuple.strings.ArrayOfStringsSummary;
import org.apache.datasketches.tuple.strings.ArrayOfStringsSummarySetOperations;
import org.apache.datasketches.tuple.strings.ArrayOfStringsTupleSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfStringsSketchTest {
    private static final String LS = System.getProperty("line.separator");

    @Test
    public void checkSketch() {
        ArrayOfStringsTupleSketch sketch1 = new ArrayOfStringsTupleSketch();
        String[][] strArrArr = new String[][]{{"a", "b"}, {"c", "d"}, {"e", "f"}};
        int len = strArrArr.length;
        for (int i = 0; i < len; ++i) {
            sketch1.update(strArrArr[i], strArrArr[i]);
        }
        sketch1.update(strArrArr[0], strArrArr[0]);
        ArrayOfStringsSketchTest.printSummaries((TupleSketchIterator<ArrayOfStringsSummary>)sketch1.iterator());
        byte[] array = sketch1.toByteArray();
        MemorySegment wseg = MemorySegment.ofArray(array);
        ArrayOfStringsTupleSketch sketch2 = new ArrayOfStringsTupleSketch(wseg);
        ArrayOfStringsSketchTest.printSummaries((TupleSketchIterator<ArrayOfStringsSummary>)sketch2.iterator());
        ArrayOfStringsSketchTest.checkSummaries(sketch2, sketch2);
        String[] strArr3 = new String[]{"g", "h"};
        sketch2.update(strArr3, strArr3);
        TupleUnion union = new TupleUnion((SummarySetOperations)new ArrayOfStringsSummarySetOperations());
        union.union((TupleSketch)sketch1);
        union.union((TupleSketch)sketch2);
        CompactTupleSketch csk = union.getResult();
        Assert.assertEquals((int)csk.getRetainedEntries(), (int)4);
        TupleIntersection inter = new TupleIntersection((SummarySetOperations)new ArrayOfStringsSummarySetOperations());
        inter.intersect((TupleSketch)sketch1);
        inter.intersect((TupleSketch)sketch2);
        csk = inter.getResult();
        Assert.assertEquals((int)csk.getRetainedEntries(), (int)3);
        TupleAnotB aNotB = new TupleAnotB();
        aNotB.setA((TupleSketch)sketch2);
        aNotB.notB((TupleSketch)sketch1);
        csk = aNotB.getResult(true);
        Assert.assertEquals((int)csk.getRetainedEntries(), (int)1);
    }

    private static void checkSummaries(ArrayOfStringsTupleSketch sk1, ArrayOfStringsTupleSketch sk2) {
        TupleSketchIterator it1 = sk1.iterator();
        TupleSketchIterator it2 = sk2.iterator();
        while (it1.next() && it2.next()) {
            ArrayOfStringsSummary sum1 = (ArrayOfStringsSummary)it1.getSummary();
            ArrayOfStringsSummary sum2 = (ArrayOfStringsSummary)it2.getSummary();
            Assert.assertTrue((boolean)sum1.equals((Object)sum2));
        }
    }

    static void printSummaries(TupleSketchIterator<ArrayOfStringsSummary> it) {
        while (it.next()) {
            String[] strArr;
            for (String s : strArr = ((ArrayOfStringsSummary)it.getSummary()).getValue()) {
                ArrayOfStringsSketchTest.print(s + ", ");
            }
            ArrayOfStringsSketchTest.println("");
        }
    }

    @Test
    public void checkCopyCtor() {
        ArrayOfStringsTupleSketch sk1 = new ArrayOfStringsTupleSketch();
        String[][] strArrArr = new String[][]{{"a", "b"}, {"c", "d"}, {"e", "f"}};
        int len = strArrArr.length;
        for (int i = 0; i < len; ++i) {
            sk1.update(strArrArr[i], strArrArr[i]);
        }
        Assert.assertEquals((int)sk1.getRetainedEntries(), (int)3);
        ArrayOfStringsTupleSketch sk2 = sk1.copy();
        Assert.assertEquals((int)sk2.getRetainedEntries(), (int)3);
    }

    @Test
    public void printlnTest() {
        ArrayOfStringsSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
        ArrayOfStringsSketchTest.print(s + LS);
    }

    static void print(String s) {
    }
}

