/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.documentation.velocity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.config.parameters.Description;
import org.apache.rat.documentation.velocity.Matcher;

public class MatcherTree {
    private final IHeaderMatcher root;

    public MatcherTree(IHeaderMatcher root) {
        this.root = root;
    }

    public Description getRoot() {
        return this.root.getDescription();
    }

    public List<Node> traverse() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(new Node(0, this.root));
        this.processNode(result, (Node)result.get(0));
        return result;
    }

    private void processNode(List<Node> result, Node node) {
        Collection<Matcher> children = node.getChildren();
        if (children.isEmpty()) {
            return;
        }
        for (Matcher child : children) {
            Node childNode = new Node(node.level + 1, child);
            result.add(childNode);
            this.processNode(result, childNode);
        }
    }

    public static class Node
    extends Matcher {
        private final int level;

        Node(int level, Matcher matcher) {
            super(matcher);
            this.level = level;
        }

        Node(int level, IHeaderMatcher root) {
            super(root);
            this.level = level;
        }

        public int level() {
            return this.level;
        }

        @Override
        public Matcher.Enclosed getEnclosed() {
            Matcher.Enclosed result = super.getEnclosed();
            return result != null && IHeaderMatcher.class.equals(result.getChildType()) ? null : result;
        }

        @Override
        public Collection<Matcher.Attribute> getAttributes() {
            return super.getAttributes().stream().filter(attr -> attr.getValue() != null).collect(Collectors.toList());
        }
    }
}

