/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.bytesource;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.imaging.bytesource.AbstractByteSourceTest;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class ByteSourceDataTest
extends AbstractByteSourceTest {
    public static Stream<byte[]> data() {
        return Arrays.asList(ByteSourceDataTest.getTestByteArrays()).stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testByteSourceFileFactory(byte[] testByteArray) throws Exception {
        this.writeAndReadBytes(new ByteSourceFileFactory(), testByteArray);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testByteSourceInputStreamFileFactory(byte[] testByteArray) throws Exception {
        this.writeAndReadBytes(new ByteSourceInputStreamFileFactory(), testByteArray);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testByteSourceInputStreamRawFactory(byte[] testByteArray) throws Exception {
        this.writeAndReadBytes(new ByteSourceInputStreamRawFactory(), testByteArray);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testByteSourcePathFactory(byte[] testByteArray) throws Exception {
        this.writeAndReadBytes(new ByteSourcePathFactory(), testByteArray);
    }

    protected void writeAndReadBytes(ByteSourceFactory byteSourceFactory, byte[] src) throws IOException {
        InputStream is;
        int i;
        ByteSource byteSource = byteSourceFactory.getByteSource(src);
        try (InputStream is2 = byteSource.getInputStream();){
            byte[] prefix = new byte[256];
            int read = is2.read(prefix);
            Assertions.assertTrue((read <= src.length ? 1 : 0) != 0);
            for (i = 0; i < read; ++i) {
                Assertions.assertEquals((byte)src[i], (byte)prefix[i]);
            }
        }
        for (int j = 0; j < 5; ++j) {
            is = byteSource.getInputStream();
            try {
                byte[] dst = IOUtils.toByteArray((InputStream)is);
                Assertions.assertArrayEquals((byte[])src, (byte[])dst);
                continue;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        if (src.length > 2) {
            int start = src.length / 2;
            is = ByteSource.getInputStream((ByteSource)byteSource, (long)start);
            try {
                byte[] dst = IOUtils.toByteArray((InputStream)is);
                Assertions.assertEquals((int)src.length, (int)(dst.length + start));
                for (i = 0; i < dst.length; ++i) {
                    Assertions.assertEquals((byte)dst[i], (byte)src[i + start]);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    private final class ByteSourceFileFactory
    implements ByteSourceFactory {
        private ByteSourceFileFactory() {
        }

        @Override
        public ByteSource getByteSource(byte[] src) throws IOException {
            File file = ByteSourceDataTest.this.createTempFile(src);
            Assertions.assertEquals((long)src.length, (long)file.length());
            return ByteSource.file((File)file);
        }
    }

    private static interface ByteSourceFactory {
        public ByteSource getByteSource(byte[] var1) throws IOException;
    }

    private final class ByteSourceInputStreamFileFactory
    implements ByteSourceFactory {
        private ByteSourceInputStreamFileFactory() {
        }

        @Override
        public ByteSource getByteSource(byte[] src) throws IOException {
            File file = ByteSourceDataTest.this.createTempFile(src);
            FileInputStream is = new FileInputStream(file);
            return ByteSource.inputStream((InputStream)is, null);
        }
    }

    private static final class ByteSourceInputStreamRawFactory
    implements ByteSourceFactory {
        private ByteSourceInputStreamRawFactory() {
        }

        @Override
        public ByteSource getByteSource(byte[] src) throws IOException {
            ByteArrayInputStream is = new ByteArrayInputStream(src);
            return ByteSource.inputStream((InputStream)is, null);
        }
    }

    private final class ByteSourcePathFactory
    implements ByteSourceFactory {
        private ByteSourcePathFactory() {
        }

        @Override
        public ByteSource getByteSource(byte[] src) throws IOException {
            Path file = ByteSourceDataTest.this.createTempFile(src).toPath();
            Assertions.assertEquals((long)src.length, (long)Files.size(file));
            return ByteSource.path((Path)file);
        }
    }
}

