/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class ProviderUtil {
    public static final Pattern PROVIDER_PATTERN = Pattern.compile("^([^@:]*)@(.*)$");

    private ProviderUtil() {
    }

    public static ProviderObjectNamePair extractProvider(String pName) throws MalformedObjectNameException {
        if (pName == null) {
            throw new IllegalArgumentException("Object name can not be null");
        }
        Matcher matcher = PROVIDER_PATTERN.matcher(pName);
        if (matcher.matches()) {
            return new ProviderObjectNamePair(matcher.group(1), matcher.group(2));
        }
        return new ProviderObjectNamePair(null, pName);
    }

    public static ProviderObjectNamePair extractProvider(ObjectName pName) throws MalformedObjectNameException {
        return ProviderUtil.extractProvider(pName.toString());
    }

    public static boolean matchesProvider(String pProvider, ObjectName pName) {
        String domain = pName.getDomain();
        Matcher matcher = PROVIDER_PATTERN.matcher(domain);
        if (matcher.matches()) {
            String providerFromName = matcher.group(1);
            return providerFromName.equals(pProvider);
        }
        return pProvider == null;
    }

    public static final class ProviderObjectNamePair {
        private final String provider;
        private final ObjectName objectName;

        private ProviderObjectNamePair(String pProvider, String pObjectName) throws MalformedObjectNameException {
            this.provider = pProvider;
            this.objectName = new ObjectName(pObjectName);
        }

        public String getProvider() {
            return this.provider;
        }

        public ObjectName getObjectName() {
            return this.objectName;
        }
    }
}

