/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.runtime.io.ComponentsIO;
import io.smallrye.openapi.runtime.io.ExternalDocumentationIO;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.OperationIO;
import io.smallrye.openapi.runtime.io.PathsIO;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import io.smallrye.openapi.runtime.io.info.InfoIO;
import io.smallrye.openapi.runtime.io.media.ContentIO;
import io.smallrye.openapi.runtime.io.media.SchemaIO;
import io.smallrye.openapi.runtime.io.parameters.ParameterIO;
import io.smallrye.openapi.runtime.io.parameters.RequestBodyIO;
import io.smallrye.openapi.runtime.io.responses.APIResponsesIO;
import io.smallrye.openapi.runtime.io.security.SecurityIO;
import io.smallrye.openapi.runtime.io.servers.ServerIO;
import io.smallrye.openapi.runtime.io.tags.TagIO;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.jboss.jandex.AnnotationInstance;

public class OpenAPIDefinitionIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<OpenAPI, V, A, O, AB, OB> {
    public static final String PROP_COMPONENTS = "components";
    public static final String PROP_EXTERNAL_DOCS = "externalDocs";
    public static final String PROP_INFO = "info";
    public static final String PROP_OPENAPI = "openapi";
    public static final String PROP_PATHS = "paths";
    public static final String PROP_SECURITY = "security";
    public static final String PROP_SECURITY_SETS = "securitySets";
    public static final String PROP_SERVERS = "servers";
    public static final String PROP_TAGS = "tags";
    private final InfoIO<V, A, O, AB, OB> infoIO;
    private final TagIO<V, A, O, AB, OB> tagIO;
    private final ServerIO<V, A, O, AB, OB> serverIO;
    private final SecurityIO<V, A, O, AB, OB> securityIO;
    private final PathsIO<V, A, O, AB, OB> pathsIO;
    private final OperationIO<V, A, O, AB, OB> operationIO;
    private final ComponentsIO<V, A, O, AB, OB> componentIO;
    private final APIResponsesIO<V, A, O, AB, OB> responsesIO;
    private final ExternalDocumentationIO<V, A, O, AB, OB> externalDocIO;
    private final ParameterIO<V, A, O, AB, OB> parameterIO;
    private final RequestBodyIO<V, A, O, AB, OB> requestBodyIO;
    private final SchemaIO<V, A, O, AB, OB> schemaIO;
    private final ExtensionIO<V, A, O, AB, OB> extensionIO;

    public OpenAPIDefinitionIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.OPENAPI_DEFINITION, Names.create(OpenAPI.class));
        this.extensionIO = new ExtensionIO<V, A, O, AB, OB>(context);
        ContentIO<V, A, O, AB, OB> contentIO = new ContentIO<V, A, O, AB, OB>(context, this.extensionIO);
        this.infoIO = new InfoIO<V, A, O, AB, OB>(context, this.extensionIO);
        this.tagIO = new TagIO<V, A, O, AB, OB>(context, this.extensionIO);
        this.serverIO = new ServerIO<V, A, O, AB, OB>(context, this.extensionIO);
        this.securityIO = new SecurityIO<V, A, O, AB, OB>(context, this.extensionIO);
        this.operationIO = new OperationIO<V, A, O, AB, OB>(context, contentIO, this.extensionIO);
        this.pathsIO = new PathsIO<V, A, O, AB, OB>(context, this.operationIO, contentIO, this.extensionIO);
        this.componentIO = new ComponentsIO<V, A, O, AB, OB>(context, contentIO, this.extensionIO);
        this.responsesIO = new APIResponsesIO<V, A, O, AB, OB>(context, contentIO, this.extensionIO);
        this.externalDocIO = new ExternalDocumentationIO<V, A, O, AB, OB>(context, this.extensionIO);
        this.parameterIO = new ParameterIO<V, A, O, AB, OB>(context, contentIO, this.extensionIO);
        this.requestBodyIO = new RequestBodyIO<V, A, O, AB, OB>(context, contentIO, this.extensionIO);
        this.schemaIO = new SchemaIO<V, A, O, AB, OB>(context, this.extensionIO);
    }

    public TagIO<V, A, O, AB, OB> tags() {
        return this.tagIO;
    }

    public ServerIO<V, A, O, AB, OB> servers() {
        return this.serverIO;
    }

    public SecurityIO<V, A, O, AB, OB> security() {
        return this.securityIO;
    }

    public OperationIO<V, A, O, AB, OB> operations() {
        return this.operationIO;
    }

    public ComponentsIO<V, A, O, AB, OB> components() {
        return this.componentIO;
    }

    public APIResponsesIO<V, A, O, AB, OB> responses() {
        return this.responsesIO;
    }

    public ExternalDocumentationIO<V, A, O, AB, OB> externalDocumentation() {
        return this.externalDocIO;
    }

    public ParameterIO<V, A, O, AB, OB> parameters() {
        return this.parameterIO;
    }

    public RequestBodyIO<V, A, O, AB, OB> requestBodies() {
        return this.requestBodyIO;
    }

    public SchemaIO<V, A, O, AB, OB> schemas() {
        return this.schemaIO;
    }

    public ExtensionIO<V, A, O, AB, OB> extensions() {
        return this.extensionIO;
    }

    @Override
    public OpenAPI read(AnnotationInstance annotation) {
        IoLogging.logger.annotation("@OpenAPIDefinition");
        OpenAPIImpl openApi = new OpenAPIImpl();
        openApi.setOpenapi("3.0.3");
        openApi.setInfo((Info)this.infoIO.read(annotation.value(PROP_INFO)));
        openApi.setTags(this.tagIO.readList(annotation.value(PROP_TAGS)));
        openApi.setServers(this.serverIO.readList(annotation.value(PROP_SERVERS)));
        openApi.setSecurity(this.securityIO.readRequirements(annotation.value(PROP_SECURITY), annotation.value(PROP_SECURITY_SETS)));
        openApi.setExternalDocs((ExternalDocumentation)this.externalDocIO.read(annotation.value(PROP_EXTERNAL_DOCS)));
        openApi.setComponents((Components)this.componentIO.read(annotation.value(PROP_COMPONENTS)));
        openApi.setExtensions(this.extensionIO.readExtensible(annotation));
        return openApi;
    }

    @Override
    public OpenAPI readObject(O node) {
        IoLogging.logger.jsonNode("OpenAPIDefinition");
        OpenAPIImpl openApi = new OpenAPIImpl();
        openApi.setOpenapi(this.jsonIO().getString(node, PROP_OPENAPI));
        openApi.setInfo((Info)this.infoIO.readValue(this.jsonIO().getValue(node, PROP_INFO)));
        openApi.setTags(this.tagIO.readList(this.jsonIO().getValue(node, PROP_TAGS)));
        openApi.setServers(this.serverIO.readList(this.jsonIO().getValue(node, PROP_SERVERS)));
        openApi.setSecurity(this.securityIO.readRequirements(this.jsonIO().getValue(node, PROP_SECURITY)));
        openApi.setExternalDocs((ExternalDocumentation)this.externalDocIO.readValue(this.jsonIO().getValue(node, PROP_EXTERNAL_DOCS)));
        openApi.setComponents((Components)this.componentIO.readValue(this.jsonIO().getValue(node, PROP_COMPONENTS)));
        openApi.setPaths((Paths)this.pathsIO.readValue(this.jsonIO().getValue(node, PROP_PATHS)));
        openApi.setExtensions(this.extensionIO.readMap(node));
        return openApi;
    }

    @Override
    public Optional<O> write(OpenAPI model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_OPENAPI, this.jsonIO().toJson(model.getOpenapi()));
            this.setIfPresent(node, PROP_INFO, this.infoIO.write(model.getInfo()));
            this.setIfPresent(node, PROP_EXTERNAL_DOCS, this.externalDocIO.write(model.getExternalDocs()));
            this.setIfPresent(node, PROP_SERVERS, this.serverIO.write(model.getServers()));
            this.setIfPresent(node, PROP_SECURITY, this.securityIO.write(model.getSecurity()));
            this.setIfPresent(node, PROP_TAGS, this.tagIO.write(model.getTags()));
            this.setIfPresent(node, PROP_PATHS, this.pathsIO.write(model.getPaths()));
            this.setIfPresent(node, PROP_COMPONENTS, this.componentIO.write(model.getComponents()));
            this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

