/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.listener.InMemoryPasswordEncoder;
import com.unboundid.ldap.matchingrules.OctetStringMatchingRule;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class InMemoryDirectoryServerPassword {
    @NotNull
    private final ASN1OctetString storedPassword;
    @Nullable
    private final InMemoryPasswordEncoder passwordEncoder;
    @NotNull
    private final ReadOnlyEntry userEntry;
    @NotNull
    private final String attributeName;

    InMemoryDirectoryServerPassword(@NotNull ASN1OctetString storedPassword, @NotNull ReadOnlyEntry userEntry, @NotNull String attributeName, @NotNull List<InMemoryPasswordEncoder> passwordEncoders) {
        this.storedPassword = storedPassword;
        this.userEntry = userEntry;
        this.attributeName = attributeName;
        InMemoryPasswordEncoder encoder = null;
        for (InMemoryPasswordEncoder e : passwordEncoders) {
            if (!e.passwordStartsWithPrefix(storedPassword)) continue;
            encoder = e;
            break;
        }
        this.passwordEncoder = encoder;
    }

    @NotNull
    public ASN1OctetString getStoredPassword() {
        return this.storedPassword;
    }

    @NotNull
    public String getAttributeName() {
        return this.attributeName;
    }

    public boolean isEncoded() {
        return this.passwordEncoder != null;
    }

    @Nullable
    public InMemoryPasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    @NotNull
    public ASN1OctetString getClearPassword() throws LDAPException {
        if (this.passwordEncoder == null) {
            return this.storedPassword;
        }
        return this.passwordEncoder.extractClearPasswordFromEncodedPassword(this.storedPassword, this.userEntry);
    }

    public boolean matchesClearPassword(@NotNull ASN1OctetString clearPassword) throws LDAPException {
        if (this.passwordEncoder == null) {
            return OctetStringMatchingRule.getInstance().valuesMatch(clearPassword, this.storedPassword);
        }
        return this.passwordEncoder.clearPasswordMatchesEncodedPassword(clearPassword, this.storedPassword, this.userEntry);
    }
}

