/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap.schema;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;

public abstract class GuardedPasswordAttribute {
    public static GuardedPasswordAttribute create(String attrName, GuardedString password) {
        return new Simple(attrName, password);
    }

    public static GuardedPasswordAttribute create(String attrName) {
        return new Empty(attrName);
    }

    public abstract void access(Accessor var1);

    public static class Empty
    extends GuardedPasswordAttribute {
        protected final String attrName;

        protected Empty(String attrName) {
            this.attrName = attrName;
        }

        @Override
        public void access(Accessor accessor) {
            accessor.access(new BasicAttribute(this.attrName));
        }
    }

    public static class Simple
    extends GuardedPasswordAttribute {
        protected final String attrName;
        protected final GuardedString password;

        protected Simple(String attrName, GuardedString password) {
            this.attrName = attrName;
            this.password = password;
        }

        @Override
        public void access(final Accessor accessor) {
            this.password.access(new GuardedString.Accessor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void access(char[] clearChars) {
                    CharBuffer charBuf = CharBuffer.wrap(clearChars);
                    ByteBuffer byteBuf = Charset.forName("UTF-8").encode(charBuf);
                    try {
                        byteBuf.rewind();
                        byte[] bytes = new byte[byteBuf.limit()];
                        byteBuf.get(bytes);
                        try {
                            BasicAttribute attr = new BasicAttribute(attrName, bytes);
                            accessor.access(attr);
                        }
                        finally {
                            SecurityUtil.clear((byte[])bytes);
                        }
                    }
                    finally {
                        byteBuf.rewind();
                        while (byteBuf.remaining() > 0) {
                            byteBuf.put((byte)0);
                        }
                    }
                }
            });
        }
    }

    public static interface Accessor {
        public void access(Attribute var1);
    }
}

