/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import org.apache.kafka.clients.producer.internals.KafkaProducerMetrics;
import org.apache.kafka.common.metrics.Metrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KafkaProducerMetricsTest {
    private static final long METRIC_VALUE = 123L;
    private static final String FLUSH_TIME_TOTAL = "flush-time-ns-total";
    private static final String TXN_INIT_TIME_TOTAL = "txn-init-time-ns-total";
    private static final String TXN_BEGIN_TIME_TOTAL = "txn-begin-time-ns-total";
    private static final String TXN_COMMIT_TIME_TOTAL = "txn-commit-time-ns-total";
    private static final String TXN_ABORT_TIME_TOTAL = "txn-abort-time-ns-total";
    private static final String TXN_SEND_OFFSETS_TIME_TOTAL = "txn-send-offsets-time-ns-total";
    private static final String METADATA_WAIT_TIME_TOTAL = "metadata-wait-time-ns-total";
    private final Metrics metrics = new Metrics();
    private final KafkaProducerMetrics producerMetrics = new KafkaProducerMetrics(this.metrics);

    KafkaProducerMetricsTest() {
    }

    @Test
    public void shouldRecordFlushTime() {
        this.producerMetrics.recordFlush(123L);
        this.assertMetricValue(FLUSH_TIME_TOTAL);
    }

    @Test
    public void shouldRecordInitTime() {
        this.producerMetrics.recordInit(123L);
        this.assertMetricValue(TXN_INIT_TIME_TOTAL);
    }

    @Test
    public void shouldRecordTxBeginTime() {
        this.producerMetrics.recordBeginTxn(123L);
        this.assertMetricValue(TXN_BEGIN_TIME_TOTAL);
    }

    @Test
    public void shouldRecordTxCommitTime() {
        this.producerMetrics.recordCommitTxn(123L);
        this.assertMetricValue(TXN_COMMIT_TIME_TOTAL);
    }

    @Test
    public void shouldRecordTxAbortTime() {
        this.producerMetrics.recordAbortTxn(123L);
        this.assertMetricValue(TXN_ABORT_TIME_TOTAL);
    }

    @Test
    public void shouldRecordSendOffsetsTime() {
        this.producerMetrics.recordSendOffsets(123L);
        this.assertMetricValue(TXN_SEND_OFFSETS_TIME_TOTAL);
    }

    @Test
    public void shouldRecordMetadataWaitTime() {
        this.producerMetrics.recordMetadataWait(123L);
        this.assertMetricValue(METADATA_WAIT_TIME_TOTAL);
    }

    @Test
    public void shouldRemoveMetricsOnClose() {
        this.producerMetrics.close();
        this.assertMetricRemoved(FLUSH_TIME_TOTAL);
        this.assertMetricRemoved(TXN_INIT_TIME_TOTAL);
        this.assertMetricRemoved(TXN_BEGIN_TIME_TOTAL);
        this.assertMetricRemoved(TXN_COMMIT_TIME_TOTAL);
        this.assertMetricRemoved(TXN_ABORT_TIME_TOTAL);
        this.assertMetricRemoved(TXN_SEND_OFFSETS_TIME_TOTAL);
        this.assertMetricRemoved(METADATA_WAIT_TIME_TOTAL);
    }

    private void assertMetricRemoved(String name) {
        Assertions.assertNull((Object)this.metrics.metric(this.metrics.metricName(name, "producer-metrics")));
    }

    private void assertMetricValue(String name) {
        Assertions.assertEquals((Object)this.metrics.metric(this.metrics.metricName(name, "producer-metrics")).metricValue(), (Object)123.0);
    }
}

