/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ibatis.type.TypeAliasRegistry;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.flowable.common.engine.api.Engine;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.engine.EngineLifecycleListener;
import org.flowable.common.engine.impl.AbstractBuildableEngineConfiguration;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.EngineConfigurator;
import org.flowable.common.engine.impl.EngineDeployer;
import org.flowable.common.engine.impl.HasVariableTypes;
import org.flowable.common.engine.impl.db.MybatisTypeAliasConfigurator;
import org.flowable.common.engine.impl.db.MybatisTypeHandlerConfigurator;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractEngineConfigurator<E extends Engine>
implements EngineConfigurator {
    protected boolean enableMybatisXmlMappingValidation;
    protected E buildEngine;

    @Override
    public void beforeInit(AbstractEngineConfiguration engineConfiguration) {
        List<MybatisTypeHandlerConfigurator> typeHandlerConfigs;
        this.registerCustomDeployers(engineConfiguration);
        this.registerCustomMybatisMappings(engineConfiguration);
        List<MybatisTypeAliasConfigurator> typeAliasConfigs = this.getMybatisTypeAliases();
        if (typeAliasConfigs != null) {
            for (MybatisTypeAliasConfigurator customMybatisTypeAliasConfig : typeAliasConfigs) {
                if (engineConfiguration.getDependentEngineMybatisTypeAliasConfigs() == null) {
                    engineConfiguration.setDependentEngineMybatisTypeAliasConfigs(new ArrayList<MybatisTypeAliasConfigurator>());
                }
                engineConfiguration.getDependentEngineMybatisTypeAliasConfigs().add(customMybatisTypeAliasConfig);
            }
        }
        if ((typeHandlerConfigs = this.getMybatisTypeHandlers()) != null) {
            for (MybatisTypeHandlerConfigurator typeHandler : typeHandlerConfigs) {
                if (engineConfiguration.getDependentEngineMybatisTypeHandlerConfigs() == null) {
                    engineConfiguration.setDependentEngineMybatisTypeHandlerConfigs(new ArrayList<MybatisTypeHandlerConfigurator>());
                }
                engineConfiguration.getDependentEngineMybatisTypeHandlerConfigs().add(typeHandler);
            }
        }
    }

    protected void registerCustomDeployers(AbstractEngineConfiguration engineConfiguration) {
        List<EngineDeployer> deployers = this.getCustomDeployers();
        if (deployers != null) {
            if (engineConfiguration.getCustomPostDeployers() == null) {
                engineConfiguration.setCustomPostDeployers(new ArrayList<EngineDeployer>());
            }
            engineConfiguration.getCustomPostDeployers().addAll(deployers);
        }
    }

    protected abstract List<EngineDeployer> getCustomDeployers();

    protected abstract String getMybatisCfgPath();

    protected void registerCustomMybatisMappings(AbstractEngineConfiguration engineConfiguration) {
        String cfgPath = this.getMybatisCfgPath();
        if (cfgPath != null) {
            HashSet<String> resources = new HashSet<String>();
            ClassLoader classLoader = engineConfiguration.getClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            ArrayList<MybatisTypeAliasConfigurator> typeAliasConfigurators = new ArrayList<MybatisTypeAliasConfigurator>();
            ArrayList<MybatisTypeHandlerConfigurator> typeHandlerConfigurators = new ArrayList<MybatisTypeHandlerConfigurator>();
            try (InputStream inputStream = classLoader.getResourceAsStream(cfgPath);){
                DocumentBuilderFactory docBuilderFactory = this.createDocumentBuilderFactory();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                Document document = docBuilder.parse(inputStream);
                NodeList typeAliasList = document.getElementsByTagName("typeAlias");
                for (int i = 0; i < typeAliasList.getLength(); ++i) {
                    final Node node = typeAliasList.item(i);
                    MybatisTypeAliasConfigurator typeAlias = new MybatisTypeAliasConfigurator(){

                        @Override
                        public void configure(AbstractEngineConfiguration abstractEngineConfiguration, TypeAliasRegistry typeAliasRegistry) {
                            try {
                                typeAliasRegistry.registerAlias(node.getAttributes().getNamedItem("alias").getTextContent(), Class.forName(node.getAttributes().getNamedItem("type").getTextContent()));
                            }
                            catch (Exception e) {
                                throw new FlowableException("Failed to load type alias class", (Throwable)e);
                            }
                        }
                    };
                    typeAliasConfigurators.add(typeAlias);
                }
                NodeList typeHandlerList = document.getElementsByTagName("tagHandler");
                for (int i = 0; i < typeHandlerList.getLength(); ++i) {
                    final Node node = typeHandlerList.item(i);
                    MybatisTypeHandlerConfigurator typeHandler = new MybatisTypeHandlerConfigurator(){

                        @Override
                        public void configure(AbstractEngineConfiguration abstractEngineConfiguration, TypeHandlerRegistry typeHandlerRegistry) {
                            try {
                                typeHandlerRegistry.register(node.getAttributes().getNamedItem("javaType").getTextContent(), node.getAttributes().getNamedItem("handler").getTextContent());
                            }
                            catch (Exception e) {
                                throw new FlowableException("Failed to load type handler class", (Throwable)e);
                            }
                        }
                    };
                    typeHandlerConfigurators.add(typeHandler);
                }
                NodeList nodeList = document.getElementsByTagName("mapper");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    resources.add(node.getAttributes().getNamedItem("resource").getTextContent());
                }
            }
            catch (IOException e) {
                throw new FlowableException("Could not read IDM Mybatis configuration file", (Throwable)e);
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new FlowableException("Could not parse Mybatis configuration file", (Throwable)e);
            }
            if (typeAliasConfigurators.size() > 0) {
                if (engineConfiguration.getDependentEngineMybatisTypeAliasConfigs() == null) {
                    engineConfiguration.setDependentEngineMybatisTypeAliasConfigs(typeAliasConfigurators);
                } else {
                    engineConfiguration.getDependentEngineMybatisTypeAliasConfigs().addAll(typeAliasConfigurators);
                }
            }
            if (typeHandlerConfigurators.size() > 0) {
                if (engineConfiguration.getDependentEngineMybatisTypeHandlerConfigs() == null) {
                    engineConfiguration.setDependentEngineMybatisTypeHandlerConfigs(typeHandlerConfigurators);
                } else {
                    engineConfiguration.getDependentEngineMybatisTypeHandlerConfigs().addAll(typeHandlerConfigurators);
                }
            }
            if (engineConfiguration.getCustomMybatisXMLMappers() == null) {
                engineConfiguration.setCustomMybatisXMLMappers(resources);
            } else {
                engineConfiguration.getCustomMybatisXMLMappers().addAll(resources);
            }
        }
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        if (!this.enableMybatisXmlMappingValidation) {
            docBuilderFactory.setValidating(false);
            docBuilderFactory.setNamespaceAware(false);
            docBuilderFactory.setExpandEntityReferences(false);
            docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        }
        return docBuilderFactory;
    }

    protected List<MybatisTypeAliasConfigurator> getMybatisTypeAliases() {
        return null;
    }

    protected List<MybatisTypeHandlerConfigurator> getMybatisTypeHandlers() {
        return null;
    }

    protected synchronized E initEngine() {
        this.buildEngine = this.buildEngine();
        return this.buildEngine;
    }

    protected abstract E buildEngine();

    protected void initialiseCommonProperties(AbstractEngineConfiguration engineConfiguration, final AbstractBuildableEngineConfiguration<E> targetEngineConfiguration) {
        this.initialiseCommonProperties(engineConfiguration, (AbstractEngineConfiguration)targetEngineConfiguration);
        targetEngineConfiguration.setRunPostEngineBuildConsumer(false);
        engineConfiguration.addEngineLifecycleListener(new EngineLifecycleListener(){

            public void onEngineBuilt(Engine engine) {
                targetEngineConfiguration.getPostEngineBuildConsumer().accept(AbstractEngineConfigurator.this.buildEngine);
            }

            public void onEngineClosed(Engine engine) {
            }
        });
    }

    protected void initialiseCommonProperties(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        this.initEngineConfigurations(engineConfiguration, targetEngineConfiguration);
        this.initEventRegistryEventConsumers(engineConfiguration, targetEngineConfiguration);
        this.initCommandContextFactory(engineConfiguration, targetEngineConfiguration);
        this.initIdGenerator(engineConfiguration, targetEngineConfiguration);
        if (targetEngineConfiguration.isUsingRelationalDatabase()) {
            this.initDataSource(engineConfiguration, targetEngineConfiguration);
            this.initDbSqlSessionFactory(engineConfiguration, targetEngineConfiguration);
            this.initDbProperties(engineConfiguration, targetEngineConfiguration);
        }
        this.initSessionFactories(engineConfiguration, targetEngineConfiguration);
        this.initEventDispatcher(engineConfiguration, targetEngineConfiguration);
        this.initClock(engineConfiguration, targetEngineConfiguration);
        this.initObjectMapper(engineConfiguration, targetEngineConfiguration);
        this.initVariableTypes(engineConfiguration, targetEngineConfiguration);
        this.initSchemaManager(engineConfiguration, targetEngineConfiguration);
    }

    protected void initEngineConfigurations(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        targetEngineConfiguration.setEngineConfigurations(engineConfiguration.getEngineConfigurations());
    }

    protected void initServiceConfigurations(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        for (String serviceConfigurationKey : engineConfiguration.getServiceConfigurations().keySet()) {
            if (targetEngineConfiguration.getServiceConfigurations() != null && targetEngineConfiguration.getServiceConfigurations().containsKey(serviceConfigurationKey)) continue;
            targetEngineConfiguration.addServiceConfiguration(serviceConfigurationKey, engineConfiguration.getServiceConfigurations().get(serviceConfigurationKey));
        }
    }

    protected void initEventRegistryEventConsumers(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        targetEngineConfiguration.setEventRegistryEventConsumers(engineConfiguration.getEventRegistryEventConsumers());
    }

    protected void initCommandContextFactory(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        targetEngineConfiguration.setCommandContextFactory(engineConfiguration.getCommandContextFactory());
    }

    protected void initIdGenerator(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        if (targetEngineConfiguration.getIdGenerator() == null) {
            targetEngineConfiguration.setIdGenerator(engineConfiguration.getIdGenerator());
        }
        targetEngineConfiguration.setUsePrefixId(engineConfiguration.isUsePrefixId());
    }

    protected void initDataSource(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        if (engineConfiguration.getDataSource() == null) {
            throw new FlowableException("A datasource is required for initializing the engine ");
        }
        targetEngineConfiguration.setDataSource(engineConfiguration.getDataSource());
    }

    protected void initDbSqlSessionFactory(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        targetEngineConfiguration.setDbSqlSessionFactory(engineConfiguration.getDbSqlSessionFactory());
        targetEngineConfiguration.setSqlSessionFactory(engineConfiguration.getSqlSessionFactory());
        targetEngineConfiguration.defaultInitDbSqlSessionFactoryEntitySettings(this.getEntityInsertionOrder(), this.getEntityDeletionOrder());
    }

    protected void initSessionFactories(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        targetEngineConfiguration.setSessionFactories(engineConfiguration.getSessionFactories());
    }

    protected void initDbProperties(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        targetEngineConfiguration.setDatabaseType(engineConfiguration.getDatabaseType());
        targetEngineConfiguration.setDatabaseCatalog(engineConfiguration.getDatabaseCatalog());
        targetEngineConfiguration.setDatabaseSchema(engineConfiguration.getDatabaseSchema());
        targetEngineConfiguration.setDatabaseSchemaUpdate(engineConfiguration.getDatabaseSchemaUpdate());
        targetEngineConfiguration.setDatabaseTablePrefix(engineConfiguration.getDatabaseTablePrefix());
        targetEngineConfiguration.setDatabaseWildcardEscapeCharacter(engineConfiguration.getDatabaseWildcardEscapeCharacter());
        targetEngineConfiguration.setDefaultCommandConfig(engineConfiguration.getDefaultCommandConfig());
        targetEngineConfiguration.setSchemaCommandConfig(engineConfiguration.getSchemaCommandConfig());
        targetEngineConfiguration.setTransactionFactory(engineConfiguration.getTransactionFactory());
        targetEngineConfiguration.setTransactionContextFactory(engineConfiguration.getTransactionContextFactory());
        targetEngineConfiguration.setTransactionsExternallyManaged(engineConfiguration.isTransactionsExternallyManaged());
    }

    protected void initEventDispatcher(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        if (engineConfiguration.getEventDispatcher() != null) {
            targetEngineConfiguration.setEventDispatcher(engineConfiguration.getEventDispatcher());
        }
    }

    protected void initClock(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        targetEngineConfiguration.setClock(engineConfiguration.getClock());
    }

    protected void initObjectMapper(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        if (targetEngineConfiguration.getObjectMapper() == null) {
            targetEngineConfiguration.setObjectMapper(engineConfiguration.getObjectMapper());
        }
    }

    protected void initVariableTypes(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        if (engineConfiguration instanceof HasVariableTypes && targetEngineConfiguration instanceof HasVariableTypes) {
            ((HasVariableTypes)((Object)targetEngineConfiguration)).setVariableTypes(((HasVariableTypes)((Object)engineConfiguration)).getVariableTypes());
        }
    }

    protected void initSchemaManager(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        targetEngineConfiguration.setDatabaseSchemaUpdate(null);
        engineConfiguration.addAdditionalSchemaManager(targetEngineConfiguration.createEngineSchemaManager());
    }

    protected abstract List<Class<? extends Entity>> getEntityInsertionOrder();

    protected abstract List<Class<? extends Entity>> getEntityDeletionOrder();

    public boolean isEnableMybatisXmlMappingValidation() {
        return this.enableMybatisXmlMappingValidation;
    }

    public void setEnableMybatisXmlMappingValidation(boolean enableMybatisXmlMappingValidation) {
        this.enableMybatisXmlMappingValidation = enableMybatisXmlMappingValidation;
    }
}

