/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.components;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapJavascriptBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import java.util.Objects;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.model.IComponentAssignedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;

public class TooltipBehavior
extends BootstrapJavascriptBehavior {
    private static final long serialVersionUID = 1L;
    private final IModel<String> label;
    private final TooltipConfig config;
    private IModel<String> labelResolved;

    public TooltipBehavior(IModel<String> label) {
        this(label, new TooltipConfig());
    }

    public TooltipBehavior(IModel<String> label, TooltipConfig config) {
        this.label = label;
        this.config = config;
    }

    public void detach(Component component) {
        super.detach(component);
        this.label.detach();
        this.labelResolved.detach();
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        tag.put("rel", (CharSequence)this.createRelAttribute());
        String title = (String)this.labelResolved.getObject();
        if (!Strings.isEmpty((String)title)) {
            tag.put("title", (CharSequence)title);
        }
    }

    public void bind(Component component) {
        super.bind(component);
        this.labelResolved = this.wrapOnAssignment(this.label, component);
        component.setOutputMarkupId(true);
    }

    private IModel<String> wrapOnAssignment(IModel<String> label, Component component) {
        if (label != null && label instanceof IComponentAssignedModel) {
            IComponentAssignedModel cam = (IComponentAssignedModel)label;
            return cam.wrapOnAssignment(Objects.requireNonNull(component));
        }
        return label;
    }

    protected String createRelAttribute() {
        return "tooltip";
    }

    @Override
    public void renderHead(Component component, IHeaderResponse headerResponse) {
        super.renderHead(component, headerResponse);
        headerResponse.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createInitializerScript(component, (Config)this.config)));
    }

    protected CharSequence createInitializerScript(Component component, Config config) {
        return JQuery.$((Component)component).chain((CharSequence)"tooltip", config, new Config[0]).get();
    }
}

