/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.htmlcompressor;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.htmlcompressor.HTMLCompressingProperties;
import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.wicket.markup.MarkupFactory;
import org.apache.wicket.protocol.http.WebApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.wicketstuff.htmlcompressor.HtmlCompressingMarkupFactory;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.stuff.htmlcompressor", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={HtmlCompressingMarkupFactory.class})
@EnableConfigurationProperties(value={HTMLCompressingProperties.class})
public class HTMLCompressingConfig
implements WicketApplicationInitConfiguration {
    private Logger logger = LoggerFactory.getLogger(HTMLCompressingConfig.class);
    @Autowired
    private HTMLCompressingProperties props;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        HtmlCompressor compressor = new HtmlCompressor();
        this.setFeatureConfiguration(compressor);
        webApplication.getMarkupSettings().setMarkupFactory((MarkupFactory)new HtmlCompressingMarkupFactory(compressor));
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.props).build());
    }

    private void setFeatureConfiguration(HtmlCompressor compressor) {
        for (Map.Entry<String, Boolean> entrySet : this.props.getFeatures().entrySet()) {
            Method method = null;
            String capitalizedKey = StringUtils.capitalize((String)entrySet.getKey());
            String methodname = "set" + capitalizedKey;
            try {
                method = compressor.getClass().getMethod(methodname, Boolean.TYPE);
                method.setAccessible(true);
                ReflectionUtils.invokeMethod((Method)method, (Object)compressor, (Object[])new Object[]{entrySet.getValue()});
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke method: {} with value {}. Exception: {}", new Object[]{methodname, entrySet.getValue(), e.getMessage()});
            }
        }
    }
}

