/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.types.ClientAppType;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="ClientApps")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="clientApps")
public interface ClientAppService
extends JAXRSService {
    @GET
    @Path(value="{type}/{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public <T extends ClientAppTO> T read(@NotNull @PathParam(value="type") ClientAppType var1, @NotNull @PathParam(value="key") String var2);

    @GET
    @Path(value="{type}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public <T extends ClientAppTO> List<T> list(@NotNull @PathParam(value="type") ClientAppType var1);

    @ApiResponses(value={@ApiResponse(responseCode="201", description="ClientApp successfully created", headers={@Header(name="X-Syncope-Key", schema=@Schema(type="string"), description="UUID generated for the entity created"), @Header(name="Location", schema=@Schema(type="string"), description="URL of the entity created")})})
    @POST
    @Path(value="{type}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response create(@NotNull @PathParam(value="type") ClientAppType var1, @NotNull ClientAppTO var2);

    @Parameter(name="key", description="ClientApp's key", in=ParameterIn.PATH, schema=@Schema(type="string"))
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @PUT
    @Path(value="{type}/{key}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void update(@NotNull @PathParam(value="type") ClientAppType var1, @NotNull ClientAppTO var2);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{type}/{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@NotNull @PathParam(value="type") ClientAppType var1, @NotNull @PathParam(value="key") String var2);
}

