/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.principal;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.adaptors.x509.authentication.principal.AbstractX509PrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509ExtractorUtils;
import org.apereo.cas.adaptors.x509.authentication.principal.X509UPNExtractorUtils;
import org.apereo.cas.authentication.principal.resolvers.PrincipalResolutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509SubjectAlternativeNameUPNPrincipalResolver
extends AbstractX509PrincipalResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(X509SubjectAlternativeNameUPNPrincipalResolver.class);

    public X509SubjectAlternativeNameUPNPrincipalResolver(PrincipalResolutionContext context) {
        super(context);
    }

    @Override
    protected String resolvePrincipalInternal(X509Certificate certificate) {
        LOGGER.debug("Resolving principal from Subject Alternative Name UPN for [{}]", (Object)certificate);
        Collection<List<?>> subjectAltNames = X509ExtractorUtils.getSubjectAltNames(certificate);
        Optional<String> upnString = X509UPNExtractorUtils.extractUPNString(subjectAltNames);
        return upnString.orElseGet(() -> this.getAlternatePrincipal(certificate));
    }

    @Override
    @Generated
    public String toString() {
        return "X509SubjectAlternativeNameUPNPrincipalResolver(super=" + super.toString() + ")";
    }
}

