/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.client;

import com.okta.sdk.client.AuthenticationScheme;
import java.util.HashMap;
import java.util.Map;

public enum AuthorizationMode {
    SSWS("SSWS", AuthenticationScheme.SSWS),
    PRIVATE_KEY("PrivateKey", AuthenticationScheme.OAUTH2_PRIVATE_KEY),
    NONE("NONE", AuthenticationScheme.NONE);

    private final String label;
    private final AuthenticationScheme authenticationScheme;
    private static final Map<AuthenticationScheme, AuthorizationMode> lookup;

    private AuthorizationMode(String label, AuthenticationScheme authenticationScheme) {
        this.label = label;
        this.authenticationScheme = authenticationScheme;
    }

    public String getLabel() {
        return this.label;
    }

    public AuthenticationScheme getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public static AuthorizationMode get(AuthenticationScheme authenticationScheme) {
        return lookup.get((Object)authenticationScheme);
    }

    public static AuthorizationMode getAuthorizationMode(String label) {
        for (AuthorizationMode authorizationMode : AuthorizationMode.values()) {
            if (!authorizationMode.getLabel().equals(label)) continue;
            return authorizationMode;
        }
        throw new IllegalArgumentException();
    }

    static {
        lookup = new HashMap<AuthenticationScheme, AuthorizationMode>();
        for (AuthorizationMode authorizationMode : AuthorizationMode.values()) {
            lookup.put(authorizationMode.getAuthenticationScheme(), authorizationMode);
        }
    }
}

