/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.tcp;

import io.micrometer.shaded.io.netty.channel.ChannelOption;
import io.micrometer.shaded.io.netty.util.NetUtil;
import io.micrometer.shaded.reactor.netty.resources.ConnectionProvider;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import io.micrometer.shaded.reactor.netty.tcp.TcpClientConfig;
import io.micrometer.shaded.reactor.netty.transport.AddressUtils;
import java.util.Collections;

final class TcpClientConnect
extends TcpClient {
    final TcpClientConfig config;
    static final int DEFAULT_PORT;

    TcpClientConnect(ConnectionProvider provider) {
        this.config = new TcpClientConfig(provider, Collections.singletonMap(ChannelOption.AUTO_READ, false), () -> AddressUtils.createUnresolved(NetUtil.LOCALHOST.getHostAddress(), DEFAULT_PORT));
    }

    TcpClientConnect(TcpClientConfig config) {
        this.config = config;
    }

    @Override
    public TcpClientConfig configuration() {
        return this.config;
    }

    @Override
    protected TcpClient duplicate() {
        return new TcpClientConnect(new TcpClientConfig(this.config));
    }

    static {
        int port;
        String portStr = null;
        try {
            portStr = System.getenv("PORT");
            port = portStr != null ? Integer.parseInt(portStr) : 12012;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid environment variable [PORT=" + portStr + "].", e);
        }
        DEFAULT_PORT = port;
    }
}

