/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import com.nimbusds.jwt.JWTClaimsSet;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.OAuth20TokenSigningAndEncryptionService;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.jwt.JsonWebTokenSigner;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTokenSigningAndEncryptionService
implements OAuth20TokenSigningAndEncryptionService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTokenSigningAndEncryptionService.class);

    @Override
    public JwtClaims decode(String token, Optional<OAuthRegisteredService> registeredService) {
        return (JwtClaims)FunctionUtils.doUnchecked(() -> {
            PublicJsonWebKey jsonWebKey = this.getJsonWebKeySigningKey(registeredService);
            FunctionUtils.throwIf((jsonWebKey.getPublicKey() == null ? 1 : 0) != 0, () -> new IllegalArgumentException("JSON web key to validate the id token signature has no public key"));
            byte[] jwt = Objects.requireNonNull(this.verifySignature(token, jsonWebKey), "Unable to verify signature of the token using the JSON web key public key");
            String result = new String(jwt, StandardCharsets.UTF_8);
            JWTClaimsSet claims = JwtBuilder.parse((String)result);
            FunctionUtils.throwIf((boolean)StringUtils.isBlank((CharSequence)claims.getIssuer()), () -> new IllegalArgumentException("Claims do not contain an issuer"));
            this.validateIssuerClaim(claims, registeredService);
            FunctionUtils.throwIf((boolean)StringUtils.isBlank((CharSequence)claims.getStringClaim("client_id")), () -> new IllegalArgumentException("Claims do not contain a client id claim"));
            return JwtClaims.parse((String)claims.toString());
        });
    }

    public abstract Set<String> getAllowedSigningAlgorithms(OAuthRegisteredService var1);

    protected void validateIssuerClaim(JWTClaimsSet claims, Optional<OAuthRegisteredService> service) throws Throwable {
        LOGGER.debug("Validating claims as [{}] with issuer [{}]", (Object)claims, (Object)claims.getIssuer());
        String iss = this.resolveIssuer(service);
        Objects.requireNonNull(iss, "Issuer cannot be null or undefined");
        FunctionUtils.throwIf((!claims.getIssuer().equalsIgnoreCase(iss) ? 1 : 0) != 0, () -> new IllegalArgumentException("Issuer assigned to JWT claim " + claims.getIssuer() + " does not match defined issuer " + iss));
    }

    protected String signToken(OAuthRegisteredService registeredService, JwtClaims claims, PublicJsonWebKey jsonWebKey) {
        LOGGER.debug("Service [{}] is set to sign id tokens", (Object)registeredService.getServiceId());
        return JsonWebTokenSigner.builder().key((Key)Optional.ofNullable(jsonWebKey).map(PublicJsonWebKey::getPrivateKey).orElse(null)).keyId(Optional.ofNullable(jsonWebKey).map(JsonWebKey::getKeyId).orElseGet(() -> UUID.randomUUID().toString())).algorithm(this.getJsonWebKeySigningAlgorithm(registeredService, (JsonWebKey)jsonWebKey)).allowedAlgorithms(new LinkedHashSet<String>(this.getAllowedSigningAlgorithms(registeredService))).mediaType(this.getSigningMediaType()).build().sign(claims);
    }

    protected String getSigningMediaType() {
        return "JWT";
    }

    protected String signTokenIfNecessary(JwtClaims claims, OAuthRegisteredService registeredService) throws Throwable {
        if (this.shouldSignToken(registeredService)) {
            LOGGER.debug("Fetching JSON web key to sign the token for : [{}]", (Object)registeredService.getClientId());
            PublicJsonWebKey jsonWebKey = this.getJsonWebKeySigningKey(Optional.of(registeredService));
            LOGGER.debug("Found JSON web key to sign the token: [{}]", (Object)jsonWebKey);
            Objects.requireNonNull(jsonWebKey.getPrivateKey(), "JSON web key used to sign the token has no associated private key");
            return this.signToken(registeredService, claims, jsonWebKey);
        }
        JWTClaimsSet claimSet = JwtBuilder.parse((String)claims.toJson());
        return JwtBuilder.buildPlain((JWTClaimsSet)claimSet, Optional.of(registeredService));
    }

    protected byte[] verifySignature(String token, PublicJsonWebKey jsonWebKey) {
        return EncodingUtils.verifyJwsSignature((Key)jsonWebKey.getPublicKey(), (String)token);
    }

    @Generated
    public BaseTokenSigningAndEncryptionService() {
    }
}

