/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20DeviceCodeResponseTypeRequestValidator
implements OAuth20TokenRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20DeviceCodeResponseTypeRequestValidator.class);
    private final ServicesManager servicesManager;
    private final ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;
    private final OAuth20RequestParameterResolver requestParameterResolver;
    private int order = Integer.MAX_VALUE;

    public boolean validate(WebContext context) {
        String responseType = this.requestParameterResolver.resolveRequestParameter(context, "response_type").map(String::valueOf).orElse("");
        String grantType = this.requestParameterResolver.resolveRequestParameter(context, "grant_type").map(String::valueOf).orElse("");
        boolean validResponseType = OAuth20Utils.isResponseType(responseType, OAuth20ResponseTypes.DEVICE_CODE);
        boolean validGrantType = OAuth20Utils.isGrantType(grantType, OAuth20GrantTypes.DEVICE_CODE);
        if (!validResponseType && !validGrantType) {
            LOGGER.warn("Response type [{}] or grant type [{}] is not supported.", (Object)responseType, (Object)grantType);
            return false;
        }
        String clientId = this.requestParameterResolver.resolveRequestParameter(context, "client_id").orElse("");
        return (Boolean)FunctionUtils.doAndHandle(() -> {
            OAuthRegisteredService registeredService = Objects.requireNonNull(OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, clientId));
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
            return validResponseType && this.requestParameterResolver.isAuthorizedResponseTypeForService(context, registeredService) || validGrantType && this.requestParameterResolver.isAuthorizedGrantTypeForService(context, registeredService);
        }, t -> {
            LOGGER.warn("Registered service access is not allowed for service definition for client id [{}]", (Object)clientId);
            return false;
        }).get();
    }

    public boolean supports(WebContext context) {
        String responseType = this.requestParameterResolver.resolveRequestParameter(context, "response_type").map(String::valueOf).orElse("");
        String grantType = this.requestParameterResolver.resolveRequestParameter(context, "grant_type").map(String::valueOf).orElse("");
        String clientId = this.requestParameterResolver.resolveRequestParameter(context, "client_id").map(String::valueOf).orElse("");
        boolean validRequest = OAuth20Utils.isResponseType(responseType, OAuth20ResponseTypes.DEVICE_CODE) || OAuth20Utils.isGrantType(grantType, OAuth20GrantTypes.DEVICE_CODE);
        return validRequest && StringUtils.isNotBlank((CharSequence)clientId);
    }

    @Generated
    public OAuth20DeviceCodeResponseTypeRequestValidator(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, OAuth20RequestParameterResolver requestParameterResolver) {
        this.servicesManager = servicesManager;
        this.webApplicationServiceServiceFactory = webApplicationServiceServiceFactory;
        this.requestParameterResolver = requestParameterResolver;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public ServiceFactory<WebApplicationService> getWebApplicationServiceServiceFactory() {
        return this.webApplicationServiceServiceFactory;
    }

    @Generated
    public OAuth20RequestParameterResolver getRequestParameterResolver() {
        return this.requestParameterResolver;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

