/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.slo.SingleLogoutRequestExecutor;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.IdleExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistryStreamCriteria;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.ISOStandardDateFormat;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;

@Endpoint(id="ssoSessions", defaultAccess=Access.NONE)
public class SingleSignOnSessionsEndpoint
extends BaseCasRestActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleSignOnSessionsEndpoint.class);
    private static final ISOStandardDateFormat DATE_FORMAT = new ISOStandardDateFormat();
    private static final String STATUS = "status";
    private static final String TICKET_GRANTING_TICKET = "ticketGrantingTicket";
    private static final String MESSAGE_FEATURE_SUPPORTED_TICKET_REGISTRY = "The functionality provided here requires that the underlying ticket registry and store is able to store, maintain and return a collection tickets that represent the single sign-on session. You will not be able to collect and review sessions, if the ticket registry does not have this capability";
    private final ObjectProvider<TicketRegistry> ticketRegistryProvider;
    private final ObjectProvider<SingleLogoutRequestExecutor> singleLogoutRequestExecutor;

    public SingleSignOnSessionsEndpoint(ObjectProvider<TicketRegistry> ticketRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, ObjectProvider<SingleLogoutRequestExecutor> singleLogoutRequestExecutor) {
        super(casProperties, applicationContext);
        this.ticketRegistryProvider = ticketRegistry;
        this.singleLogoutRequestExecutor = singleLogoutRequestExecutor;
    }

    @GetMapping(path={"/users/{username}"}, produces={"application/json"})
    @Operation(summary="Get all single sign-on sessions for username. The functionality provided here requires that the underlying ticket registry and store is able to store, maintain and return a collection tickets that represent the single sign-on session. You will not be able to collect and review sessions, if the ticket registry does not have this capability", parameters={@Parameter(name="username", required=true, in=ParameterIn.PATH, description="The username to look up")})
    public Map<String, Object> getSsoSessionsForUser(@PathVariable String username) {
        return this.getSsoSessions(new SsoSessionsRequest().withUsername(username));
    }

    @DeleteMapping(path={"/users/{username}"}, produces={"application/json"})
    @Operation(summary="Destroy all single sign-on sessions for username. The functionality provided here requires that the underlying ticket registry and store is able to store, maintain and return a collection tickets that represent the single sign-on session. You will not be able to collect and review sessions, if the ticket registry does not have this capability", parameters={@Parameter(name="username", required=true, in=ParameterIn.PATH, description="The username to look up")})
    public Map<String, Object> destroySsoSessionsForUser(@PathVariable String username, HttpServletRequest request, HttpServletResponse response) {
        return this.destroySsoSessions(new SsoSessionsRequest().withUsername(username), request, response);
    }

    @GetMapping(produces={"application/json"})
    @Operation(summary="Get all single sign-on sessions with the given type. The functionality provided here requires that the underlying ticket registry and store is able to store, maintain and return a collection tickets that represent the single sign-on session. You will not be able to collect and review sessions, if the ticket registry does not have this capability", parameters={@Parameter(name="type", in=ParameterIn.QUERY, description="Type of sessions to retrieve (ALL, DIRECT, PROXIED)"), @Parameter(name="username", in=ParameterIn.QUERY, description="Username assigned to each session"), @Parameter(name="from", schema=@Schema(type="integer"), in=ParameterIn.QUERY, description="Starting position/index of the query"), @Parameter(name="count", schema=@Schema(type="integer"), in=ParameterIn.QUERY, description="Total number of sessions to return")})
    public Map<String, Object> getSsoSessions(@ModelAttribute @Valid SsoSessionsRequest ssoSessionsRequest) {
        HashMap<String, Object> sessionsMap = new HashMap<String, Object>();
        List<Map<String, Object>> activeSsoSessions = this.getActiveSsoSessions(ssoSessionsRequest).toList();
        sessionsMap.put("activeSsoSessions", activeSsoSessions);
        sessionsMap.put("totalSsoSessions", ((TicketRegistry)this.ticketRegistryProvider.getObject()).sessionCount());
        return sessionsMap;
    }

    @DeleteMapping(path={"/{ticketGrantingTicket}"}, produces={"application/json"})
    @Operation(summary="Remove single sign-on session for ticket id", parameters={@Parameter(name="ticketGrantingTicket", required=true, in=ParameterIn.PATH, description="The ticket-granting ticket to remove")})
    public Map<String, Object> destroySsoSession(@PathVariable String ticketGrantingTicket, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> sessionsMap = new HashMap<String, Object>(1);
        try {
            List sloRequests = ((SingleLogoutRequestExecutor)this.singleLogoutRequestExecutor.getObject()).execute(ticketGrantingTicket, request, response);
            sessionsMap.put(STATUS, 200);
            sessionsMap.put(TICKET_GRANTING_TICKET, ticketGrantingTicket);
            sessionsMap.put("singleLogoutRequests", sloRequests);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            sessionsMap.put(STATUS, 500);
            sessionsMap.put(TICKET_GRANTING_TICKET, ticketGrantingTicket);
            sessionsMap.put("message", e.getMessage());
        }
        return sessionsMap;
    }

    @Operation(summary="Remove single sign-on session for type and user", parameters={@Parameter(name="type", in=ParameterIn.QUERY, description="Type of sessions to retrieve (ALL, DIRECT, PROXIED)"), @Parameter(name="username", in=ParameterIn.QUERY, description="Username assigned to each session"), @Parameter(name="from", schema=@Schema(type="integer"), in=ParameterIn.QUERY, description="Starting position/index of the query"), @Parameter(name="count", schema=@Schema(type="integer"), in=ParameterIn.QUERY, description="Total number of sessions to return")})
    @DeleteMapping(produces={"application/json"})
    public Map<String, Object> destroySsoSessions(@Valid SsoSessionsRequest ssoSessionsRequest, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)ssoSessionsRequest.getUsername()) && StringUtils.isBlank((CharSequence)ssoSessionsRequest.getType())) {
            return Map.of(STATUS, 400);
        }
        if (StringUtils.isNotBlank((CharSequence)ssoSessionsRequest.getUsername())) {
            HashMap<String, Object> sessionsMap = new HashMap<String, Object>(1);
            Stream<Ticket> tickets = ((TicketRegistry)this.ticketRegistryProvider.getObject()).getSessionsFor(ssoSessionsRequest.getUsername());
            if (ssoSessionsRequest.getFrom() > 0L) {
                tickets = tickets.skip(ssoSessionsRequest.getFrom());
            }
            if (ssoSessionsRequest.getCount() > 0L) {
                tickets = tickets.limit(ssoSessionsRequest.getCount());
            }
            tickets.forEach(ticket -> sessionsMap.put(ticket.getId(), this.destroySsoSession(ticket.getId(), request, response)));
            return sessionsMap;
        }
        HashMap<String, Object> sessionsMap = new HashMap<String, Object>();
        this.getActiveSsoSessions(ssoSessionsRequest).map(sso -> sso.get(SsoSessionAttributeKeys.TICKET_GRANTING_TICKET_ID.getAttributeKey()).toString()).forEach(ticketGrantingTicket -> this.destroySsoSession((String)ticketGrantingTicket, request, response));
        sessionsMap.put(STATUS, 200);
        return sessionsMap;
    }

    private Stream<Map<String, Object>> getActiveSsoSessions(SsoSessionsRequest ssoSessionsRequest) {
        SsoSessionReportOptions option = Optional.ofNullable(ssoSessionsRequest.getType()).map(SsoSessionReportOptions::valueOf).orElse(SsoSessionReportOptions.ALL);
        return this.getNonExpiredTicketGrantingTickets(ssoSessionsRequest).map(TicketGrantingTicket.class::cast).filter(tgt -> option != SsoSessionReportOptions.DIRECT || tgt.getProxiedBy() == null).filter(tgt -> StringUtils.isBlank((CharSequence)ssoSessionsRequest.getUsername()) || StringUtils.equalsIgnoreCase((CharSequence)ssoSessionsRequest.getUsername(), (CharSequence)tgt.getAuthentication().getPrincipal().getId())).sorted(Comparator.comparing(Ticket::getId)).map(tgt -> SingleSignOnSessionsEndpoint.buildSingleSignOnSessionFromTicketGrantingTicket(option, tgt));
    }

    private static Map<String, Object> buildSingleSignOnSessionFromTicketGrantingTicket(SsoSessionReportOptions option, TicketGrantingTicket tgt) {
        Authentication authentication = tgt.getAuthentication();
        Principal principal = authentication.getPrincipal();
        LinkedHashMap<String, Object> sso = new LinkedHashMap<String, Object>(SsoSessionAttributeKeys.values().length);
        sso.put(SsoSessionAttributeKeys.AUTHENTICATED_PRINCIPAL.getAttributeKey(), principal.getId());
        sso.put(SsoSessionAttributeKeys.AUTHENTICATION_DATE.getAttributeKey(), authentication.getAuthenticationDate());
        sso.put(SsoSessionAttributeKeys.AUTHENTICATION_DATE_FORMATTED.getAttributeKey(), DATE_FORMAT.format(DateTimeUtils.dateOf((ChronoZonedDateTime)authentication.getAuthenticationDate())));
        sso.put(SsoSessionAttributeKeys.CREATION_DATE_FORMATTED.getAttributeKey(), DATE_FORMAT.format(DateTimeUtils.dateOf((ChronoZonedDateTime)tgt.getCreationTime())));
        sso.put(SsoSessionAttributeKeys.LAST_USED_DATE_FORMATTED.getAttributeKey(), DATE_FORMAT.format(DateTimeUtils.dateOf((ChronoZonedDateTime)tgt.getLastTimeUsed())));
        sso.put(SsoSessionAttributeKeys.NUMBER_OF_USES.getAttributeKey(), tgt.getCountOfUses());
        sso.put(SsoSessionAttributeKeys.TICKET_GRANTING_TICKET_ID.getAttributeKey(), tgt.getId());
        sso.put(SsoSessionAttributeKeys.PRINCIPAL_ATTRIBUTES.getAttributeKey(), principal.getAttributes());
        sso.put(SsoSessionAttributeKeys.AUTHENTICATION_ATTRIBUTES.getAttributeKey(), authentication.getAttributes());
        LinkedHashMap<String, Object> policyData = new LinkedHashMap<String, Object>();
        ExpirationPolicy expirationPolicy = tgt.getExpirationPolicy();
        if (expirationPolicy instanceof IdleExpirationPolicy) {
            IdleExpirationPolicy iep = (IdleExpirationPolicy)expirationPolicy;
            policyData.put("timeToIdle", iep.getTimeToIdle());
            Optional.ofNullable(iep.getIdleExpirationTime((Ticket)tgt)).ifPresent(dt -> policyData.put("idleExpirationTime", dt));
        }
        policyData.put("timeToLive", expirationPolicy.getTimeToLive());
        policyData.put("clock", expirationPolicy.getClock().toString());
        policyData.put("name", expirationPolicy.getName());
        Optional.ofNullable(expirationPolicy.toMaximumExpirationTime((Ticket)tgt)).ifPresent(dt -> policyData.put("maxExpirationTime", dt));
        sso.put(SsoSessionAttributeKeys.EXPIRATION_POLICY.getAttributeKey(), policyData);
        sso.put(SsoSessionAttributeKeys.REMEMBER_ME.getAttributeKey(), CoreAuthenticationUtils.isRememberMeAuthentication((Authentication)authentication));
        if (option != SsoSessionReportOptions.DIRECT) {
            if (tgt.getProxiedBy() != null) {
                sso.put(SsoSessionAttributeKeys.IS_PROXIED.getAttributeKey(), Boolean.TRUE);
                sso.put(SsoSessionAttributeKeys.PROXIED_BY.getAttributeKey(), tgt.getProxiedBy().getId());
            } else {
                sso.put(SsoSessionAttributeKeys.IS_PROXIED.getAttributeKey(), Boolean.FALSE);
            }
        }
        Map services = tgt.getServices();
        sso.put(SsoSessionAttributeKeys.AUTHENTICATED_SERVICES.getAttributeKey(), services);
        return sso;
    }

    private Stream<? extends Ticket> getNonExpiredTicketGrantingTickets(SsoSessionsRequest ssoSessionsRequest) {
        return ((TicketRegistry)this.ticketRegistryProvider.getObject()).stream(TicketRegistryStreamCriteria.builder().count(ssoSessionsRequest.getCount()).from(ssoSessionsRequest.getFrom()).build()).filter(ticket -> ticket instanceof TicketGrantingTicket && !ticket.isExpired());
    }

    @Generated
    public String toString() {
        return "SingleSignOnSessionsEndpoint(ticketRegistryProvider=" + String.valueOf(this.ticketRegistryProvider) + ", singleLogoutRequestExecutor=" + String.valueOf(this.singleLogoutRequestExecutor) + ")";
    }

    @Generated
    public ObjectProvider<TicketRegistry> getTicketRegistryProvider() {
        return this.ticketRegistryProvider;
    }

    @Generated
    public ObjectProvider<SingleLogoutRequestExecutor> getSingleLogoutRequestExecutor() {
        return this.singleLogoutRequestExecutor;
    }

    public static class SsoSessionsRequest
    implements Serializable {
        private static final long serialVersionUID = 9132400807103771828L;
        private String type = SsoSessionReportOptions.ALL.getType();
        private String username;
        private long from;
        private long count = 1000L;

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public long getFrom() {
            return this.from;
        }

        @Generated
        public long getCount() {
            return this.count;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setFrom(long from) {
            this.from = from;
        }

        @Generated
        public void setCount(long count) {
            this.count = count;
        }

        @Generated
        public SsoSessionsRequest(String type, String username, long from, long count) {
            this.type = type;
            this.username = username;
            this.from = from;
            this.count = count;
        }

        @Generated
        public SsoSessionsRequest() {
        }

        @Generated
        public SsoSessionsRequest withType(String type) {
            return this.type == type ? this : new SsoSessionsRequest(type, this.username, this.from, this.count);
        }

        @Generated
        public SsoSessionsRequest withUsername(String username) {
            return this.username == username ? this : new SsoSessionsRequest(this.type, username, this.from, this.count);
        }

        @Generated
        public SsoSessionsRequest withFrom(long from) {
            return this.from == from ? this : new SsoSessionsRequest(this.type, this.username, from, this.count);
        }

        @Generated
        public SsoSessionsRequest withCount(long count) {
            return this.count == count ? this : new SsoSessionsRequest(this.type, this.username, this.from, count);
        }
    }

    static enum SsoSessionReportOptions {
        ALL("ALL"),
        PROXIED("PROXIED"),
        DIRECT("DIRECT");

        private final String type;

        @Generated
        private SsoSessionReportOptions(String type) {
            this.type = type;
        }

        @Generated
        public String getType() {
            return this.type;
        }
    }

    static enum SsoSessionAttributeKeys {
        AUTHENTICATED_PRINCIPAL("authenticated_principal"),
        AUTHENTICATION_DATE("authentication_date"),
        CREATION_DATE_FORMATTED("creation_date_formatted"),
        LAST_USED_DATE_FORMATTED("last_used_date_formatted"),
        AUTHENTICATION_DATE_FORMATTED("authentication_date_formatted"),
        TICKET_GRANTING_TICKET_ID("ticket_granting_ticket"),
        AUTHENTICATION_ATTRIBUTES("authentication_attributes"),
        PRINCIPAL_ATTRIBUTES("principal_attributes"),
        PROXIED_BY("proxied_by"),
        AUTHENTICATED_SERVICES("authenticated_services"),
        IS_PROXIED("is_proxied"),
        REMEMBER_ME("remember_me"),
        EXPIRATION_POLICY("expiration_policy"),
        NUMBER_OF_USES("number_of_uses");

        private final String attributeKey;

        private SsoSessionAttributeKeys(String attributeKey) {
            this.attributeKey = attributeKey;
        }

        @Generated
        public String getAttributeKey() {
            return this.attributeKey;
        }
    }
}

