/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.server.ControllerMigrationSupport;
import kafka.server.ControllerServer;
import kafka.server.KRaftCachedControllerId;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTemplate;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import kafka.zk.TopicZNode;
import kafka.zk.ZkMigrationClient;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkMigrationIntegrationTest$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.migration.MigrationDriverState;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.security.EncryptingPasswordEncoder;
import org.apache.kafka.security.PasswordEncoder;
import org.apache.kafka.security.authorizer.AclEntry;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ExtendWith(value={ClusterTestExtensions.class})
@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0005\ruu!B\u00181\u0011\u0003)d!B\u001c1\u0011\u0003A\u0004\"B \u0002\t\u0003\u0001\u0005\"B!\u0002\t\u0003\u0011e\u0001B\u001c1\u0001ECQa\u0010\u0003\u0005\u0002ICq\u0001\u0016\u0003C\u0002\u0013\u0005Q\u000b\u0003\u0004_\t\u0001\u0006IA\u0016\u0004\u0005?\u0012\u0001\u0001\rC\u0003@\u0011\u0011\u0005\u0011\rC\u0004e\u0011\t\u0007I\u0011A3\t\r=D\u0001\u0015!\u0003g\u0011\u001d\u0001\b\u00021A\u0005\u0002EDq!\u001e\u0005A\u0002\u0013\u0005a\u000f\u0003\u0004}\u0011\u0001\u0006KA\u001d\u0005\u0006{\"!\tA \u0005\b\u0003+AA\u0011AA\f\u0011\u001d\tI\u0003\u0002C\u0001\u0003WAq!!%\u0005\t\u0003\t\u0019\nC\u0004\u0002D\u0012!\t!!2\t\u000f\u00055G\u0001\"\u0001\u0002P\"9\u0011Q\u001c\u0003\u0005\u0002\u0005}\u0007bBAu\t\u0011\u0005\u00111\u001e\u0005\b\u0003k$A\u0011AA|\u0011\u001d\ti\u0010\u0002C\u0001\u0003\u007fDqA!\u0003\u0005\t\u0003\u0011Y\u0001C\u0004\u0003\u0016\u0011!\tAa\u0006\t\u000f\t%B\u0001\"\u0001\u0003,!9!Q\u0007\u0003\u0005\u0002\t]\u0002b\u0002B?\t\u0011\u0005!q\u0010\u0005\b\u0005+#A\u0011\u0001BL\u0011\u001d\u0011\t\u000b\u0002C\u0001\u0005GCqAa+\u0005\t\u0003\u0011i\u000bC\u0004\u00036\u0012!\tAa.\t\u000f\t\u0005G\u0001\"\u0001\u0003D\"9!q\u001b\u0003\u0005\u0002\te\u0007bBB\b\t\u0011\u00051\u0011\u0003\u0005\b\u00077!A\u0011AB\u000f\u0011\u001d\u0019\t\u0003\u0002C\u0001\u0007GAqaa\n\u0005\t\u0003\u0019I\u0003C\u0004\u0004.\u0011!\taa\f\t\u000f\reB\u0001\"\u0001\u0004<!91q\b\u0003\u0005\u0002\r\u0005\u0003bBB#\t\u0011\u00051q\t\u0005\b\u0007\u0017\"A\u0011AB'\u0011\u001d\u0019\t\u0006\u0002C\u0001\u0007'Bqaa\u0016\u0005\t\u0003\u0019I&\u0001\u000e[W6KwM]1uS>t\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u00022e\u0005\u0011!p\u001b\u0006\u0002g\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u001c\u0002\u001b\u0005\u0001$A\u0007.l\u001b&<'/\u0019;j_:Le\u000e^3he\u0006$\u0018n\u001c8UKN$8CA\u0001:!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!N\u0001\"u.\u001cE.^:uKJ\u001chi\u001c:BY2l\u0015n\u001a:bi&|gNV3sg&|gn\u001d\u000b\u0002\u0007B\u0019A)S&\u000e\u0003\u0015S!AR$\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0011\u0006!!.\u0019<b\u0013\tQUI\u0001\u0003MSN$\bC\u0001'P\u001b\u0005i%B\u0001(3\u0003\u0011!Xm\u001d;\n\u0005Ak%!D\"mkN$XM]\"p]\u001aLwm\u0005\u0002\u0005sQ\t1\u000b\u0005\u00027\t\u0005\u0019An\\4\u0016\u0003Y\u0003\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\u000bMdg\r\u000e6\u000b\u0003m\u000b1a\u001c:h\u0013\ti\u0006L\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007EA\u000bNKR\fG-\u0019;b\t\u0016dG/\u0019,fe&4\u0017.\u001a:\u0014\u0005!ID#\u00012\u0011\u0005\rDQ\"\u0001\u0003\u0002\u001b5,G/\u00193bi\u0006$U\r\u001c;b+\u00051\u0007CA4n\u001b\u0005A'BA5k\u0003\u0015IW.Y4f\u0015\t\u00194N\u0003\u0002m5\u00061\u0011\r]1dQ\u0016L!A\u001c5\u0003\u001b5+G/\u00193bi\u0006$U\r\u001c;b\u00039iW\r^1eCR\fG)\u001a7uC\u0002\naa\u001c4gg\u0016$X#\u0001:\u0011\u0005i\u001a\u0018B\u0001;<\u0005\rIe\u000e^\u0001\u000b_\u001a47/\u001a;`I\u0015\fHCA<{!\tQ\u00040\u0003\u0002zw\t!QK\\5u\u0011\u001dYX\"!AA\u0002I\f1\u0001\u001f\u00132\u0003\u001dygMZ:fi\u0002\na!Y2dKB$HCA<\u0000\u0011\u001d\t\ta\u0004a\u0001\u0003\u0007\tQAY1uG\"\u0004B\u0001R%\u0002\u0006A!\u0011qAA\t\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011AB2p[6|gNC\u0002\u0002\u0010)\faa]3sm\u0016\u0014\u0018\u0002BA\n\u0003\u0013\u0011A#\u00119j\u001b\u0016\u001c8/Y4f\u0003:$g+\u001a:tS>t\u0017A\u0002<fe&4\u0017\u0010F\u0002x\u00033Aq!a\u0007\u0011\u0001\u0004\ti\"\u0001\u0005wKJLg-[3s!\u0019Q\u0014qDA\u0012o&\u0019\u0011\u0011E\u001e\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA4\u0002&%\u0019\u0011q\u00055\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0003=!Xm\u001d;NS\u001e\u0014\u0018\r^3BG2\u001cHcA<\u0002.!9\u0011qF\tA\u0002\u0005E\u0012aD2mkN$XM]%ogR\fgnY3\u0011\u00071\u000b\u0019$C\u0002\u000265\u0013qb\u00117vgR,'/\u00138ti\u0006t7-\u001a\u0015\u0018#\u0005e\u0012QIA$\u0003\u0013\nY%a\u0016\u0002Z\u0005\r\u0014QMA8\u0003c\u0002B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007fi\u0015AC1o]>$\u0018\r^5p]&!\u00111IA\u001f\u0005-\u0019E.^:uKJ$Vm\u001d;\u0002\u000f\t\u0014xn[3sgv\t1!A\u0003usB,7\u000f\f\u0002\u0002N\u0011\u0012\u0011qJ\u0005\u0005\u0003#\n\u0019&\u0001\u0002[\u0017*!\u0011QKA\u001f\u0003\u0011!\u0016\u0010]3\u0002\u0013\u0005,Ho\\*uCJ$HEAA.\u0013\u0011\ti&a\u0018\u0002\u0007e+5K\u0003\u0003\u0002b\u0005u\u0012!C!vi>\u001cF/\u0019:u\u0003=iW\r^1eCR\fg+\u001a:tS>tGEAA4\u0013\u0011\tI'a\u001b\u0002\u0017%\u0013\u0005kX\u001a`m}Ke+\r\u0006\u0005\u0003[\nI!A\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003A\u0019XM\u001d<feB\u0013x\u000e]3si&,7\u000f\f\u0003\u0002t\u0005\u001d5FCA;\u0003w\ni(!!\u0002\u0004B!\u00111HA<\u0013\u0011\tI(!\u0010\u0003+\rcWo\u001d;fe\u000e{gNZ5h!J|\u0007/\u001a:us\u0006\u00191.Z=\"\u0005\u0005}\u0014!F1vi\"|'/\u001b>fe:\u001aG.Y:t]9\fW.Z\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u000b\u000bqe[1gW\u0006t3/Z2ve&$\u0018PL1vi\"|'/\u001b>fe:\n5\r\\!vi\"|'/\u001b>fe.R\u0011QOA>\u0003\u0013\u000b\t)!$\"\u0005\u0005-\u0015aC:va\u0016\u0014h&^:feN\f#!a$\u0002\u001dU\u001bXM\u001d\u001eB\u001d>s\u0015,T(V'\u0006yB/Z:u'R\f'\u000f\u001e.l\u0005J|7.\u001a:XSRD\u0017)\u001e;i_JL'0\u001a:\u0015\u0007]\f)\nC\u0004\u0002\u0018J\u0001\r!!\r\u0002\u0013i\\7\t\\;ti\u0016\u0014\bf\u0006\n\u0002:\u0005\u0015\u0013qIA%\u00037\u000b9&!\u0017\u0002d\u0005\u0015\u0014qNAOY\t\ti\u0005\f\u0007\u0002t\u0005\u001d\u0015qTAU\u0003g\u000bIl\u000b\u0006\u0002v\u0005m\u0014\u0011UAA\u0003K\u000b#!a)\u00025%tG/\u001a:/EJ|7.\u001a:/Y&\u001cH/\u001a8fe:r\u0017-\\3\"\u0005\u0005\u001d\u0016\u0001C#Y)\u0016\u0013f*\u0011',\u0015\u0005U\u00141PAV\u0003\u0003\u000by+\t\u0002\u0002.\u0006IA.[:uK:,'o]\u0011\u0003\u0003c\u000ba\u0006\u0015'B\u0013:#V\t\u0017+;_=bwnY1mQ>\u001cHO\u000f\u0019-\u000bb#VI\u0015(B\u0019jzs\u0006\\8dC2Dwn\u001d;;a-R\u0011QOA>\u0003k\u000b\t)a,\"\u0005\u0005]\u0016\u0001F1em\u0016\u0014H/[:fI:b\u0017n\u001d;f]\u0016\u00148o\u000b\u0006\u0002v\u0005m\u00141XAA\u0003\u007f\u000b#!!0\u0002=1L7\u000f^3oKJt3/Z2ve&$\u0018P\f9s_R|7m\u001c7/[\u0006\u0004\u0018EAAa\u0003\u0019*\u0005\fV#S\u001d\u0006c%\b\u0015'B\u0013:#V\t\u0017+-!2\u000b\u0015J\u0014+F1RS\u0004\u000bT!J\u001dR+\u0005\fV\u0001\fi\u0016\u001cH/T5he\u0006$X\rF\u0002x\u0003\u000fDq!a\f\u0014\u0001\u0004\t\t\u0004K\b\u0014\u0003s\t)%a\u0012\u0002J\u0005-\u00171MA3Y\t\ti%A\ruKN$X*[4sCR,Gk\u001c9jG\u0012+G.\u001a;j_:\u001cHcA<\u0002R\"9\u0011q\u0013\u000bA\u0002\u0005E\u0002f\u0002\u000b\u0002V\u0006\u0005\u00151\u001c\t\u0005\u0003w\t9.\u0003\u0003\u0002Z\u0006u\"aD\"mkN$XM\u001d+f[Bd\u0017\r^3\"\u0003\u0005\u000b!\u0003^3ti\u0012+\u0018\r\\,sSR,7k\u0019:b[R\u0019q/!9\t\u000f\u0005]U\u00031\u0001\u00022!\u001aR#!\u000f\u0002J\u0005\u0015\u0018QIA$\u0003G\n)'a\u001c\u0002h2\u0012\u0011Q\n\u0017\t\u0003?\u000bI+a-\u0002:\u00061B/Z:u\t\u0016dW\r^3M_\u001e|en\u0015;beR,\b\u000fF\u0002x\u0003[Dq!a&\u0017\u0001\u0004\t\t\u0004K\b\u0017\u0003s\tI%!=\u0002F\u0005\u001d\u0013qNAzY\t\ti\u0005\f\u0005\u0002 \u0006%\u00161WA]\u00035!Xm\u001d;Ek\u0006dwK]5uKR\u0019q/!?\t\u000f\u0005]u\u00031\u0001\u00022!:q#!6\u0002\u0002\u0006m\u0017A\u0007;fgR$U/\u00197Xe&$X-U;pi\u0006\fe\u000eZ*de\u0006lGcA<\u0003\u0002!9\u0011q\u0013\rA\u0002\u0005E\u0002f\u0005\r\u0002:\u0005%#QAA#\u0003\u000f\n\u0019'!\u001a\u0002p\t\u001dAFAA'Y!\ty*!+\u00024\u0006e\u0016A\t;fgRtUm^!oI\u000eC\u0017M\\4fIR{\u0007/[2t\u0013:$U/\u00197Xe&$X\rF\u0002x\u0005\u001bAq!a&\u001a\u0001\u0004\t\t\u0004K\n\u001a\u0003s\tIE!\u0005\u0002F\u0005\u001d\u00131MA3\u0003_\u0012\u0019\u0002\f\u0002\u0002N1B\u0011qTAU\u0003g\u000bI,A\u0013uKN$\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$\u0018J\u001c%zEJLG-T8eKR\u0019qO!\u0007\t\u000f\u0005]%\u00041\u0001\u00022!\u001a\"$!\u000f\u0002J\tu\u0011Q\tB\u0010\u0003G\u0012\t#a\u001c\u0003(1\u0012\u0011QJ\u000f\u0002\t\u0011\u0012!1E\u0005\u0005\u0005K\tY'A\u0006J\u0005B{6gX\u001c`\u0013Z\u0003D\u0006CAP\u0003S\u000b\u0019,!/\u0002OQ,7\u000f^%oGJ,W.\u001a8uC2\fE\u000e^3s\u0007>tg-[4t!J,W*[4sCRLwN\u001c\u000b\u0004o\n5\u0002bBAL7\u0001\u0007\u0011\u0011\u0007\u0015\u00147\u0005e\u0012\u0011\nB\u0019\u0003\u000b\n9%a\u0019\u0002f\u0005=$1\u0007\u0017\u0003\u0003\u001bb\u0003\"a(\u0002*\u0006M\u0016\u0011X\u0001\fGJ,\u0017\r^3U_BL7\rF\u0006x\u0005s\u0011\u0019Fa\u0016\u0003b\t-\u0004b\u0002B\u001e9\u0001\u0007!QH\u0001\ni>\u0004\u0018n\u0019(b[\u0016\u0004BAa\u0010\u0003N9!!\u0011\tB%!\r\u0011\u0019eO\u0007\u0003\u0005\u000bR1Aa\u00125\u0003\u0019a$o\\8u}%\u0019!1J\u001e\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011yE!\u0015\u0003\rM#(/\u001b8h\u0015\r\u0011Ye\u000f\u0005\u0007\u0005+b\u0002\u0019\u0001:\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011\u001d\u0011I\u0006\ba\u0001\u00057\n\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s!\rQ$QL\u0005\u0004\u0005?Z$!B*i_J$\bb\u0002B29\u0001\u0007!QM\u0001\bG>tg-[4t!\u001d!%q\rB\u001f\u0005{I1A!\u001bF\u0005\ri\u0015\r\u001d\u0005\b\u0005[b\u0002\u0019\u0001B8\u0003\u0015\tG-\\5o!\u0011\u0011\tH!\u001f\u000e\u0005\tM$\u0002\u0002B7\u0005kR1Aa\u001ek\u0003\u001d\u0019G.[3oiNLAAa\u001f\u0003t\t)\u0011\tZ7j]\u0006Ya/\u001a:jMf$v\u000e]5d)59(\u0011\u0011BB\u0005\u000b\u00139I!#\u0003\f\"9!1H\u000fA\u0002\tu\u0002B\u0002B+;\u0001\u0007!\u000fC\u0004\u0003Zu\u0001\rAa\u0017\t\u000f\t\rT\u00041\u0001\u0003f!9!QN\u000fA\u0002\t=\u0004b\u0002BG;\u0001\u0007!qR\u0001\tu.\u001cE.[3oiB\u0019aG!%\n\u0007\tM\u0005GA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\"m\u0016\u0014\u0018NZ=L%\u00064G\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019\u000b\no\ne%1\u0014BO\u0005?CqAa\u000f\u001f\u0001\u0004\u0011i\u0004\u0003\u0004\u0003Vy\u0001\rA\u001d\u0005\b\u00053r\u0002\u0019\u0001B.\u0011\u001d\u0011iG\ba\u0001\u0005_\nqC^3sS\u001aL8JU1giR{\u0007/[2D_:4\u0017nZ:\u0015\u000f]\u0014)Ka*\u0003*\"9!1H\u0010A\u0002\tu\u0002b\u0002B2?\u0001\u0007!Q\r\u0005\b\u0005[z\u0002\u0019\u0001B8\u0003Q1XM]5gsj[Ek\u001c9jG\u000e{gNZ5hgR9qOa,\u00032\nM\u0006b\u0002B\u001eA\u0001\u0007!Q\b\u0005\b\u0005G\u0002\u0003\u0019\u0001B3\u0011\u001d\u0011i\t\ta\u0001\u0005\u001f\u000baD^3sS\u001aL(l\u0013+pa&\u001c\u0007+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1\u0015\u0013]\u0014ILa/\u0003>\n}\u0006b\u0002B\u001eC\u0001\u0007!Q\b\u0005\u0007\u0005+\n\u0003\u0019\u0001:\t\u000f\te\u0013\u00051\u0001\u0003\\!9!QR\u0011A\u0002\t=\u0015!\u0003;pa&\u001cG)Z:d)\u0019\u0011)M!5\u0003VB)!Ha2\u0003L&\u0019!\u0011Z\u001e\u0003\r=\u0003H/[8o!\u0011\u0011\tH!4\n\t\t='1\u000f\u0002\u0011)>\u0004\u0018n\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:DqAa5#\u0001\u0004\u0011i$A\u0003u_BL7\rC\u0004\u0003n\t\u0002\rAa\u001c\u0002/M,g\u000eZ!mY>\u001c\u0017\r^3Qe>$WoY3s\u0013\u0012\u001cH\u0003\u0002Bn\u0005[\u0004bA!8\u0003d\n\u001dXB\u0001Bp\u0015\r\u0011\t/R\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002\u0002Bs\u0005?\u0014\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!\rQ$\u0011^\u0005\u0004\u0005W\\$\u0001\u0002'p]\u001eDqAa<$\u0001\u0004\u0011\t0A\t{W\u000ecWo\u001d;fe&s7\u000f^1oG\u0016\u0004BAa=\u0004\n9!!Q_B\u0002\u001d\u0011\u00119Pa@\u000f\t\te(Q \b\u0005\u0005\u0007\u0012Y0C\u00014\u0013\tq%'C\u0002\u0004\u00025\u000bQA[;oSRLAa!\u0002\u0004\b\u0005Q\"l[\"mkN$XM]%om>\u001c\u0017\r^5p]\u000e{g\u000e^3yi*\u00191\u0011A'\n\t\r-1Q\u0002\u0002\u00125.\u001cE.^:uKJLen\u001d;b]\u000e,'\u0002BB\u0003\u0007\u000f\t1C]3bIB\u0013x\u000eZ;dKJLEM\u00117pG.$Baa\u0005\u0004\u001aA!\u0011qAB\u000b\u0013\u0011\u00199\"!\u0003\u0003!A\u0013x\u000eZ;dKJLEm\u001d\"m_\u000e\\\u0007b\u0002BGI\u0001\u0007!qR\u0001\u0013C2$XM\u001d\"s_.,'oQ8oM&<7\u000fF\u0002x\u0007?AqA!\u001c&\u0001\u0004\u0011y'\u0001\tbYR,'\u000fV8qS\u000e\u001cuN\u001c4jOR\u0019qo!\n\t\u000f\t5d\u00051\u0001\u0003p\u0005\t\u0012\r\u001c;fe\u000ec\u0017.\u001a8u#V|G/Y:\u0015\u0007]\u001cY\u0003C\u0004\u0003n\u001d\u0002\rAa\u001c\u00025\r\u0014X-\u0019;f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:\u0015\t\rE2q\u0007\t\u0005\u0005c\u001a\u0019$\u0003\u0003\u00046\tM$aH!mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014Vm];mi\"9!Q\u000e\u0015A\u0002\t=\u0014!G1mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN$Ba!\r\u0004>!9!QN\u0015A\u0002\t=\u0014A\u0005<fe&4\u0017\u0010V8qS\u000e\u001cuN\u001c4jON$2a^B\"\u0011\u001d\u0011iI\u000ba\u0001\u0005\u001f\u000b1C^3sS\u001aL(I]8lKJ\u001cuN\u001c4jON$2a^B%\u0011\u001d\u0011ii\u000ba\u0001\u0005\u001f\u000b!C^3sS\u001aL8\t\\5f]R\fVo\u001c;bgR\u0019qoa\u0014\t\u000f\t5E\u00061\u0001\u0003\u0010\u0006Qb/\u001a:jMf,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgR\u0019qo!\u0016\t\u000f\t5U\u00061\u0001\u0003\u0010\u0006\u00112\u000f[;uI><h.\u00138TKF,XM\\2f)\u0015981LB/\u0011\u001d\t9J\fa\u0001\u0003cAqaa\u0018/\u0001\u0004\u0019\t'\u0001\u0007le\u00064Go\u00117vgR,'\u000f\u0005\u0003\u0004d\r%TBAB3\u0015\r\u00199GM\u0001\bi\u0016\u001cHo[5u\u0013\u0011\u0019Yg!\u001a\u0003'-\u000bgm[1DYV\u001cH/\u001a:UKN$8*\u001b;)\u000f\u0011\u0019y'!!\u0004\u0006B!1\u0011OBA\u001b\t\u0019\u0019H\u0003\u0003\u0004v\r]\u0014!C3yi\u0016t7/[8o\u0015\u0011\u0019Iha\u001f\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0004~\r}\u0014a\u00026va&$XM\u001d\u0006\u0004\u0007\u0003Q\u0016\u0002BBB\u0007g\u0012!\"\u0012=uK:$w+\u001b;iY\t\u00199i\t\u0002\u0004\nB!11RBG\u001b\t\u00199!\u0003\u0003\u0004\u0010\u000e\u001d!!F\"mkN$XM\u001d+fgR,\u0005\u0010^3og&|gn\u001d\u0015\b\t\rM\u0015\u0011QBN!\u0011\u0019)ja&\u000e\u0005\r]\u0014\u0002BBM\u0007o\u0012q\u0001V5nK>,HO\b\u0002\u0002Y\u0001")
public class ZkMigrationIntegrationTest {
    private final Logger log = LoggerFactory.getLogger(ZkMigrationIntegrationTest.class);

    public static java.util.List<ClusterConfig> zkClustersForAllMigrationVersions() {
        return ZkMigrationIntegrationTest$.MODULE$.zkClustersForAllMigrationVersions();
    }

    public Logger log() {
        return this.log;
    }

    @ClusterTest(brokers=3, types={Type.ZK}, autoStart=AutoStart.YES, metadataVersion=MetadataVersion.IBP_3_6_IV1, serverProperties={@ClusterConfigProperty(key="authorizer.class.name", value="kafka.security.authorizer.AclAuthorizer"), @ClusterConfigProperty(key="super.users", value="User:ANONYMOUS")})
    public void testMigrateAcls(ClusterInstance clusterInstance) {
        Admin admin = clusterInstance.createAdminClient();
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        String username = "alice";
        KafkaPrincipal principal = new KafkaPrincipal("User", username);
        KafkaPrincipal wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry.WILDCARD_PRINCIPAL_STRING);
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(principal.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(principal.toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(principal.toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(wildcardPrincipal.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW));
        admin.createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$))))).asJava()).all().get();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().zkClient();
        ZkMigrationClient migrationClient = ZkMigrationClient$.MODULE$.apply(zkClient, PasswordEncoder.NOOP);
        MetadataDeltaVerifier verifier = new MetadataDeltaVerifier();
        migrationClient.readAllMetadata(batch -> verifier.accept((java.util.List<ApiMessageAndVersion>)batch), x$1 -> {});
        verifier.verify((Function1<MetadataImage, BoxedUnit>)(Function1 & Serializable)image -> {
            ZkMigrationIntegrationTest.$anonfun$testMigrateAcls$3(acl1, acl2, acl3, acl4, image);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(brokers=3, types={Type.ZK}, autoStart=AutoStart.YES, metadataVersion=MetadataVersion.IBP_3_6_IV1, serverProperties={@ClusterConfigProperty(key="authorizer.class.name", value="kafka.security.authorizer.AclAuthorizer"), @ClusterConfigProperty(key="super.users", value="User:ANONYMOUS"), @ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testStartZkBrokerWithAuthorizer(ClusterInstance zkCluster) {
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_6_IV1).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp("zookeeper.metadata.migration.enable", "true").setConfigProp("zookeeper.connect", ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            HashMap<String, String> serverProperties = new HashMap<String, String>(zkCluster.config().serverProperties());
            serverProperties.put("zookeeper.metadata.migration.enable", "true");
            serverProperties.put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            serverProperties.put("controller.listener.names", "CONTROLLER");
            serverProperties.put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            ClusterConfig clusterConfig = ClusterConfig.builder(zkCluster.config()).setServerProperties(serverProperties).build();
            ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).rollingBrokerRestart(Optional.of(clusterConfig));
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testStartZkBrokerWithAuthorizer$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.inDualWrite$1(kraftCluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for dual-write mode");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(brokers=3, types={Type.ZK}, metadataVersion=MetadataVersion.IBP_3_6_IV1)
    public void testMigrate(ClusterInstance clusterInstance) {
        PasswordEncoder passwordEncoder;
        Admin admin = clusterInstance.createAdminClient();
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic("test-topic-1", 2, (short)3).configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"102400"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"300000")}))).asJava()));
        newTopics.add(new NewTopic("test-topic-2", 1, (short)3));
        newTopics.add(new NewTopic("test-topic-3", 10, (short)3));
        admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
        ArrayList<ClientQuotaAlteration> quotas = new ArrayList<ClientQuotaAlteration>();
        ClientQuotaEntity defaultUserEntity = new ClientQuotaEntity(Collections.singletonMap("user", null));
        quotas.add(new ClientQuotaAlteration(defaultUserEntity, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(900.0)), (List)Nil$.MODULE$)).asJava()));
        ClientQuotaEntity defaultClientIdEntity = new ClientQuotaEntity(Collections.singletonMap("client-id", null));
        quotas.add(new ClientQuotaAlteration(defaultClientIdEntity, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(900.0)), (List)Nil$.MODULE$)).asJava()));
        ClientQuotaEntity defaultIpEntity = new ClientQuotaEntity(Collections.singletonMap("ip", null));
        quotas.add(new ClientQuotaAlteration(defaultIpEntity, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(9.0)), (List)Nil$.MODULE$)).asJava()));
        ClientQuotaEntity userEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user/1@prod")}))).asJava());
        quotas.add(new ClientQuotaAlteration(userEntity, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), (List)Nil$.MODULE$)).asJava()));
        ClientQuotaEntity userClientEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user/1@prod"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client/1@domain")}))).asJava());
        quotas.add(new ClientQuotaAlteration(userClientEntity, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(800.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
        ClientQuotaEntity ipEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"8.8.8.8")}))).asJava());
        quotas.add(new ClientQuotaAlteration(ipEntity, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)), (List)Nil$.MODULE$)).asJava()));
        admin.alterClientQuotas(quotas).all().get(60L, TimeUnit.SECONDS);
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().zkClient();
        KafkaConfig kafkaConfig = ((KafkaServer)((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().servers().head()).config();
        Option option = kafkaConfig.passwordEncoderSecret();
        if (option instanceof Some) {
            void encrypting_iterations;
            void encrypting_keyLength;
            void encrypting_cipherAlgorithm;
            Password secret = (Password)((Some)option).value();
            int n = Predef$.MODULE$.Integer2int(kafkaConfig.passwordEncoderIterations());
            int n2 = Predef$.MODULE$.Integer2int(kafkaConfig.passwordEncoderKeyLength());
            String string = kafkaConfig.passwordEncoderCipherAlgorithm();
            String encrypting_keyFactoryAlgorithm = kafkaConfig.passwordEncoderKeyFactoryAlgorithm();
            passwordEncoder = new EncryptingPasswordEncoder(secret, encrypting_keyFactoryAlgorithm, (String)encrypting_cipherAlgorithm, (int)encrypting_keyLength, (int)encrypting_iterations);
            Object var20_18 = null;
            string = null;
        } else if (None$.MODULE$.equals(option)) {
            passwordEncoder = PasswordEncoder.NOOP;
        } else {
            throw new MatchError((Object)option);
        }
        PasswordEncoder zkConfigEncoder = passwordEncoder;
        ZkMigrationClient migrationClient = ZkMigrationClient$.MODULE$.apply(zkClient, zkConfigEncoder);
        ZkMigrationLeadershipState migrationState = migrationClient.getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState.EMPTY);
        migrationState = migrationState.withNewKRaftController(3000, 42);
        migrationState = migrationClient.claimControllerLeadership(migrationState);
        HashSet brokers = new HashSet();
        MetadataDeltaVerifier verifier = new MetadataDeltaVerifier();
        migrationClient.readAllMetadata(batch -> verifier.accept((java.util.List<ApiMessageAndVersion>)batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(brokers).asScala().toSeq());
        verifier.verify((Function1<MetadataImage, BoxedUnit>)(Function1 & Serializable)image -> {
            ZkMigrationIntegrationTest.$anonfun$testMigrate$3(defaultUserEntity, defaultClientIdEntity, defaultIpEntity, userEntity, userClientEntity, ipEntity, image);
            return BoxedUnit.UNIT;
        });
        migrationClient.releaseControllerLeadership(migrationState);
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTemplate(value="zkClustersForAllMigrationVersions")
    public void testMigrateTopicDeletions(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic("test-topic-1", 10, (short)3));
        newTopics.add(new NewTopic("test-topic-2", 10, (short)3));
        newTopics.add(new NewTopic("test-topic-3", 10, (short)3));
        admin.createTopics(newTopics).all().get(300L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(zkCluster.config().metadataVersion()).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp("zookeeper.metadata.migration.enable", "true").setConfigProp("zookeeper.connect", ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            HashMap<String, String> serverProperties = new HashMap<String, String>(zkCluster.config().serverProperties());
            serverProperties.put("zookeeper.metadata.migration.enable", "true");
            serverProperties.put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            serverProperties.put("controller.listener.names", "CONTROLLER");
            serverProperties.put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            ClusterConfig clusterConfig = ClusterConfig.builder(zkCluster.config()).setServerProperties(serverProperties).build();
            ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).rollingBrokerRestart(Optional.of(clusterConfig));
            zkClient.createDeleteTopicPath("test-topic-1");
            zkClient.createDeleteTopicPath("test-topic-2");
            zkClient.createDeleteTopicPath("test-topic-3");
            zkCluster.waitForReadyBrokers();
            readyFuture.get(60L, TimeUnit.SECONDS);
            Assumptions.assumeTrue((boolean)zkClient.getTopicDeletions().nonEmpty(), (String)"This test needs pending topic deletions after a migration in order to verify the behavior");
            this.log().info("Waiting for ZK migration to complete");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testMigrateTopicDeletions$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for migration to complete");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            admin = zkCluster.createAdminClient();
            this.log().info("Waiting for topics to be deleted");
            long l2 = 1000L;
            long waitUntilTrue_waitTimeMs2 = 30000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.topicsAllDeleted$1(admin)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for topics to be deleted");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            ArrayList<NewTopic> newTopics2 = new ArrayList<NewTopic>();
            newTopics2.add(new NewTopic("test-topic-1", 2, (short)3));
            newTopics2.add(new NewTopic("test-topic-2", 1, (short)3));
            newTopics2.add(new NewTopic("test-topic-3", 10, (short)3));
            admin.createTopics(newTopics2).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Waiting for topics to be re-created");
            long l3 = 1000L;
            long waitUntilTrue_waitTimeMs3 = 30000L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.topicsAllRecreated$1(admin)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)"Timed out waiting for topics to be created");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
            long l4 = 300000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l5 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    scala.collection.immutable.Map map;
                    try {
                        map = CollectionConverters$.MODULE$.MapHasAsScala(admin.describeTopics(Arrays.asList("test-topic-1", "test-topic-2", "test-topic-3")).topicNameValues()).asScala().map((Function1 & Serializable)x0$1 -> {
                            if (x0$1 != null) {
                                String name = (String)x0$1._1();
                                KafkaFuture description = (KafkaFuture)x0$1._2();
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), description.get(60L, TimeUnit.SECONDS));
                            }
                            throw new MatchError(null);
                        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException) {
                            map = Predef$.MODULE$.Map().empty();
                        }
                        if (throwable != null) {
                            map = (scala.collection.immutable.Map)Assertions.fail((String)"Error describing topics", (Throwable)throwable.getCause());
                        }
                        throw null;
                    }
                    scala.collection.immutable.Map $anonfun$testMigrateTopicDeletions$7_topicDescriptions = map;
                    Assertions.assertEquals((int)2, (int)((TopicDescription)$anonfun$testMigrateTopicDeletions$7_topicDescriptions.apply((Object)"test-topic-1")).partitions().size());
                    Assertions.assertEquals((int)1, (int)((TopicDescription)$anonfun$testMigrateTopicDeletions$7_topicDescriptions.apply((Object)"test-topic-2")).partitions().size());
                    Assertions.assertEquals((int)10, (int)((TopicDescription)$anonfun$testMigrateTopicDeletions$7_topicDescriptions.apply((Object)"test-topic-3")).partitions().size());
                    $anonfun$testMigrateTopicDeletions$7_topicDescriptions.foreach((Function1 & Serializable)x0$2 -> {
                        ZkMigrationIntegrationTest.$anonfun$testMigrateTopicDeletions$9(x0$2);
                        return BoxedUnit.UNIT;
                    });
                    scala.collection.mutable.Set $anonfun$testMigrateTopicDeletions$7_absentTopics = CollectionConverters$.MODULE$.SetHasAsScala((Set)admin.listTopics().names().get(60L, TimeUnit.SECONDS)).asScala();
                    Assertions.assertTrue((boolean)$anonfun$testMigrateTopicDeletions$7_absentTopics.contains((Object)"test-topic-1"));
                    Assertions.assertTrue((boolean)$anonfun$testMigrateTopicDeletions$7_absentTopics.contains((Object)"test-topic-2"));
                    Assertions.assertTrue((boolean)$anonfun$testMigrateTopicDeletions$7_absentTopics.contains((Object)"test-topic-3"));
                    Object var36_28 = null;
                    Object var37_27 = null;
                    Object var38_29 = null;
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l5).append(", and then retrying.").toString();
                        Object var35_30 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l5);
                    l5 += package$.MODULE$.min(l5, 1000L);
                    continue;
                }
                break;
            }
            Object var29_21 = null;
            Object var34_25 = null;
            admin.close();
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(types={Type.ZK}, brokers=3, metadataVersion=MetadataVersion.IBP_3_6_IV1, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDualWriteScram(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        this.createUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_6_IV1).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp("zookeeper.metadata.migration.enable", "true").setConfigProp("zookeeper.connect", ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            HashMap<String, String> serverProperties = new HashMap<String, String>(zkCluster.config().serverProperties());
            serverProperties.put("zookeeper.metadata.migration.enable", "true");
            serverProperties.put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            serverProperties.put("controller.listener.names", "CONTROLLER");
            serverProperties.put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            ClusterConfig clusterConfig = ClusterConfig.builder(zkCluster.config()).setServerProperties(serverProperties).build();
            ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).rollingBrokerRestart(Optional.of(clusterConfig));
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWriteScram$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyUserScramCredentials(zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(types={Type.ZK}, brokers=3, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDeleteLogOnStartup(ClusterInstance zkCluster) {
        try (Admin admin = zkCluster.createAdminClient();){
            ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
            newTopics.add(new NewTopic("testDeleteLogOnStartup", 2, (short)3).configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"102400"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"300000")}))).asJava()));
            admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
        }
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_9_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp("zookeeper.metadata.migration.enable", "true").setConfigProp("zookeeper.connect", ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            HashMap<String, String> serverProperties = new HashMap<String, String>(zkCluster.config().serverProperties());
            serverProperties.put("zookeeper.metadata.migration.enable", "true");
            serverProperties.put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            serverProperties.put("controller.listener.names", "CONTROLLER");
            serverProperties.put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            ClusterConfig clusterConfig = ClusterConfig.builder(zkCluster.config()).setServerProperties(serverProperties).build();
            ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).rollingBrokerRestart(Optional.of(clusterConfig));
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDeleteLogOnStartup$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.hasKRaftController$1(zkCluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for ZK brokers to see a KRaft controller");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            this.log().info("Restart brokers again");
            ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).rollingBrokerRestart(Optional.empty());
            zkCluster.waitForReadyBrokers();
            admin = zkCluster.createAdminClient();
            try {
                long l3 = 100L;
                long waitUntilTrue_waitTimeMs3 = 30000L;
                long waitUntilTrue_startTime3 = System.currentTimeMillis();
                while (!CollectionConverters$.MODULE$.SetHasAsScala((Set)admin.listTopics().names().get(30L, TimeUnit.SECONDS)).asScala().contains((Object)"testDeleteLogOnStartup")) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                        Assertions.fail((String)"Timed out listing topics");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
                }
            }
            finally {
                admin.close();
            }
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTemplate(value="zkClustersForAllMigrationVersions")
    public void testDualWrite(ClusterInstance zkCluster) {
        String topicName = "test";
        Admin admin = zkCluster.createAdminClient();
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic(topicName, 2, (short)3).configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"102400"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"300000")}))).asJava()));
        admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        Properties propsBefore = zkClient.getEntityConfigs("topics", topicName);
        Assertions.assertEquals((Object)"102400", (Object)propsBefore.getProperty("segment.bytes"));
        Assertions.assertEquals((Object)"300000", (Object)propsBefore.getProperty("segment.ms"));
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(zkCluster.config().metadataVersion()).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp("zookeeper.metadata.migration.enable", "true").setConfigProp("zookeeper.connect", ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            LongRef nextProducerId = LongRef.create((long)-1L);
            long l = 60000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l2 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    Assertions.assertDoesNotThrow(() -> {
                        nextProducerId$1.elem = BoxesRunTime.unboxToLong((Object)this.sendAllocateProducerIds((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).get(20L, TimeUnit.SECONDS));
                    });
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                        Object var33_15 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l2);
                    l2 += package$.MODULE$.min(l2, 1000L);
                    continue;
                }
                break;
            }
            Object var15_12 = null;
            Object var20_17 = null;
            Assertions.assertEquals((long)0L, (long)nextProducerId.elem);
            this.log().info("Restart brokers in migration mode");
            HashMap<String, String> serverProperties = new HashMap<String, String>(zkCluster.config().serverProperties());
            serverProperties.put("zookeeper.metadata.migration.enable", "true");
            serverProperties.put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            serverProperties.put("controller.listener.names", "CONTROLLER");
            serverProperties.put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            ClusterConfig clusterConfig = ClusterConfig.builder(zkCluster.config()).setServerProperties(serverProperties).build();
            ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).rollingBrokerRestart(Optional.of(clusterConfig));
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l3 = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWrite$3(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterTopicConfig(admin);
            this.alterClientQuotas(admin);
            this.alterBrokerConfigs(admin);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyTopicConfigs(zkClient);
            this.verifyClientQuotas(zkClient);
            this.verifyBrokerConfigs(zkClient);
            LongRef nextKRaftProducerId = LongRef.create((long)-1L);
            long l4 = 60000L;
            TestUtils$ retry_this2 = TestUtils$.MODULE$;
            long l5 = 1L;
            long retry_startTime2 = System.currentTimeMillis();
            while (true) {
                try {
                    Assertions.assertDoesNotThrow(() -> {
                        nextKRaftProducerId$1.elem = BoxesRunTime.unboxToLong((Object)this.sendAllocateProducerIds((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).get(20L, TimeUnit.SECONDS));
                    });
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this2.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l5).append(", and then retrying.").toString();
                        Object var34_30 = null;
                        retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l5);
                    l5 += package$.MODULE$.min(l5, 1000L);
                    continue;
                }
                break;
            }
            Object var27_25 = null;
            Object var32_29 = null;
            Assertions.assertNotEquals((long)nextProducerId.elem, (long)nextKRaftProducerId.elem);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(types={Type.ZK}, brokers=3, metadataVersion=MetadataVersion.IBP_3_6_IV1, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDualWriteQuotaAndScram(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        this.createUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_6_IV1).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp("zookeeper.metadata.migration.enable", "true").setConfigProp("zookeeper.connect", ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            HashMap<String, String> serverProperties = new HashMap<String, String>(zkCluster.config().serverProperties());
            serverProperties.put("zookeeper.metadata.migration.enable", "true");
            serverProperties.put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            serverProperties.put("controller.listener.names", "CONTROLLER");
            serverProperties.put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            ClusterConfig clusterConfig = ClusterConfig.builder(zkCluster.config()).setServerProperties(serverProperties).build();
            ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).rollingBrokerRestart(Optional.of(clusterConfig));
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWriteQuotaAndScram$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
            this.alterClientQuotas(admin);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyUserScramCredentials(zkClient);
            this.verifyClientQuotas(zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(types={Type.ZK}, brokers=3, metadataVersion=MetadataVersion.IBP_3_6_IV1, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testNewAndChangedTopicsInDualWrite(ClusterInstance zkCluster) {
        String topic1 = "test1";
        String topic2 = "test2";
        zkCluster.createAdminClient();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_6_IV1).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp("zookeeper.metadata.migration.enable", "true").setConfigProp("zookeeper.connect", ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            void var14_22;
            Tuple2 tuple2;
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            HashMap<String, String> serverProperties = new HashMap<String, String>(zkCluster.config().serverProperties());
            serverProperties.put("zookeeper.metadata.migration.enable", "true");
            serverProperties.put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            serverProperties.put("controller.listener.names", "CONTROLLER");
            serverProperties.put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            ClusterConfig clusterConfig = ClusterConfig.builder(zkCluster.config()).setServerProperties(serverProperties).build();
            ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).rollingBrokerRestart(Optional.of(clusterConfig));
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Admin admin = zkCluster.createAdminClient();
            this.log().info(new StringBuilder(52).append("Create new topic ").append(topic1).append(" with AdminClient with some configs").toString());
            java.util.Map<String, String> topicConfigs = Collections.singletonMap("cleanup.policy", "compact");
            this.createTopic(topic1, 2, (short)3, topicConfigs, admin);
            this.verifyTopic(topic1, 2, (short)3, topicConfigs, admin, zkClient);
            this.log().info(new StringBuilder(50).append("Create new topic ").append(topic2).append(" with AdminClient without configs").toString());
            java.util.Map<String, String> emptyTopicConfigs = Collections.emptyMap();
            this.createTopic(topic2, 2, (short)3, emptyTopicConfigs, admin);
            this.verifyTopic(topic2, 2, (short)3, emptyTopicConfigs, admin, zkClient);
            int newPartitionCount = 3;
            this.log().info(new StringBuilder(42).append("Create new partitions with AdminClient to ").append(topic1).toString());
            admin.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)newPartitionCount))}))).asJava()).all().get(60L, TimeUnit.SECONDS);
            long l2 = 100L;
            long computeUntilTrue_waitTime = 15000L;
            long computeUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                void computeUntilTrue_pause;
                Option<TopicDescription> computeUntilTrue_result;
                if (ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$4(newPartitionCount, computeUntilTrue_result = this.topicDesc(topic1, admin))) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    break;
                }
                if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    break;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
            }
            Object var29_20 = null;
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Option topicDescOpt = (Option)tuple22._1();
            Assertions.assertTrue((boolean)var14_22.isDefined());
            Buffer partitions = CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)var14_22.get()).partitions()).asScala();
            Assertions.assertEquals((int)newPartitionCount, (int)partitions.size());
            this.verifyZKTopicPartitionMetadata(topic1, newPartitionCount, (short)3, zkClient);
            this.verifyKRaftTopicPartitionMetadata(topic1, newPartitionCount, (short)3, admin);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(types={Type.ZK}, brokers=4, metadataVersion=MetadataVersion.IBP_3_7_IV0, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testPartitionReassignmentInHybridMode(ClusterInstance zkCluster) {
        String topicName = "test";
        zkCluster.createAdminClient();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_7_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp("zookeeper.metadata.migration.enable", "true").setConfigProp("zookeeper.connect", ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            HashMap<String, String> serverProperties = new HashMap<String, String>(zkCluster.config().serverProperties());
            serverProperties.put("zookeeper.metadata.migration.enable", "true");
            serverProperties.put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            serverProperties.put("controller.listener.names", "CONTROLLER");
            serverProperties.put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            ClusterConfig clusterConfig = ClusterConfig.builder(zkCluster.config()).setServerProperties(serverProperties).build();
            ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).rollingBrokerRestart(Optional.of(clusterConfig));
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testPartitionReassignmentInHybridMode$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Create new topic with AdminClient");
            Admin admin = zkCluster.createAdminClient();
            ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
            java.util.Map<Integer, java.util.List> replicaAssignment = Collections.singletonMap(0, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})).map((Function1 & Serializable)x -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)x)))).asJava());
            newTopics.add(new NewTopic(topicName, replicaAssignment));
            admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
            TopicPartition topicPartition = new TopicPartition(topicName, 0);
            this.verifyZKTopicPartitionMetadata(topicName, 1, (short)3, zkClient);
            admin.alterPartitionReassignments(Collections.singletonMap(topicPartition, Optional.of(new NewPartitionReassignment(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})).map((Function1 & Serializable)x -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)x)))).asJava())))).all().get();
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!((java.util.Map)admin.listPartitionReassignments().reassignments().get()).isEmpty()) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for reassignments to complete.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            long l3 = 100L;
            long waitUntilTrue_waitTimeMs3 = 15000L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testPartitionReassignmentInHybridMode$7(zkCluster, topicPartition)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)"Timed out waiting for removed replica reassignment to be marked offline");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    @ClusterTest(types={Type.ZK}, brokers=3, metadataVersion=MetadataVersion.IBP_3_6_IV1, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testIncrementalAlterConfigsPreMigration(ClusterInstance zkCluster) {
        HashMap<String, String> serverProperties = new HashMap<String, String>(zkCluster.config().serverProperties());
        serverProperties.put("zookeeper.metadata.migration.enable", "true");
        serverProperties.put("controller.quorum.voters", "1@localhost:9999");
        serverProperties.put("controller.listener.names", "CONTROLLER");
        serverProperties.put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
        ClusterConfig clusterConfig = ClusterConfig.builder(zkCluster.config()).setServerProperties(serverProperties).build();
        ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).rollingBrokerRestart(Optional.of(clusterConfig));
        zkCluster.waitForReadyBrokers();
        Admin admin = zkCluster.createAdminClient();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        try {
            this.alterBrokerConfigs(admin);
            this.verifyBrokerConfigs(zkClient);
        }
        finally {
            admin.close();
            zkClient.close();
            zkCluster.stop();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createTopic(String topicName, int numPartitions, short replicationFactor, java.util.Map<String, String> configs, Admin admin) {
        NewTopic newTopic = new NewTopic(topicName, numPartitions, replicationFactor).configs(configs);
        admin.createTopics(Collections.singletonList(newTopic)).all().get(60L, TimeUnit.SECONDS);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ZkMigrationIntegrationTest.$anonfun$createTopic$1(admin, topicName)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$createTopic$2(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public void verifyTopic(String topicName, int numPartitions, short replicationFactor, java.util.Map<String, String> configs, Admin admin, KafkaZkClient zkClient) {
        this.verifyZKTopicPartitionMetadata(topicName, numPartitions, replicationFactor, zkClient);
        this.verifyZKTopicConfigs(topicName, configs, zkClient);
        this.verifyKRaftTopicPartitionMetadata(topicName, numPartitions, replicationFactor, admin);
        this.verifyKRaftTopicConfigs(topicName, configs, admin);
    }

    public void verifyKRaftTopicPartitionMetadata(String topicName, int numPartitions, short replicationFactor, Admin admin) {
        TopicDescription description = (TopicDescription)this.topicDesc(topicName, admin).get();
        Assertions.assertEquals((int)numPartitions, (int)description.partitions().size());
        description.partitions().forEach(p -> Assertions.assertEquals((int)replicationFactor, (int)p.isr().size()));
    }

    public void verifyKRaftTopicConfigs(String topicName, java.util.Map<String, String> configs, Admin admin) {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, topicName);
        Collection entries = ((Config)((KafkaFuture)admin.describeConfigs(Collections.singletonList(configResource)).values().get(configResource)).get()).entries();
        List dynamicConfigs = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(entries).asScala().filter((Function1 & Serializable)configEntry -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyKRaftTopicConfigs$1(configEntry)))).toList();
        Assertions.assertEquals((int)configs.size(), (int)dynamicConfigs.size());
        dynamicConfigs.foreach((Function1 & Serializable)c -> {
            ZkMigrationIntegrationTest.$anonfun$verifyKRaftTopicConfigs$2(configs, c);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void verifyZKTopicConfigs(String topicName, java.util.Map<String, String> configs, KafkaZkClient zkClient) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!zkClient.pathExists(ConfigEntityZNode$.MODULE$.path("topics", topicName))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ZkMigrationIntegrationTest.$anonfun$verifyZKTopicConfigs$2(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Properties props = zkClient.getEntityConfigs("topics", topicName);
        Assertions.assertEquals((int)configs.size(), (int)props.size());
        configs.forEach((x0$1, x1$1) -> Assertions.assertEquals((Object)x1$1, (Object)props.get(x0$1)));
    }

    /*
     * WARNING - void declaration
     */
    public void verifyZKTopicPartitionMetadata(String topicName, int numPartitions, short replicationFactor, KafkaZkClient zkClient) {
        void var7_11;
        Tuple2 tuple2;
        IndexedSeq partitions = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable)pId -> ZkMigrationIntegrationTest.$anonfun$verifyZKTopicPartitionMetadata$1(topicName, BoxesRunTime.unboxToInt((Object)pId)));
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Option computeUntilTrue_result;
            if ((computeUntilTrue_result = ZkMigrationIntegrationTest.$anonfun$verifyZKTopicPartitionMetadata$2(zkClient, topicName)).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyZKTopicPartitionMetadata$4(partitions$1, x$2)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var14_9 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Option topicIdReplicaAssignment = (Option)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)"Unable to find topic metadata in Zk");
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ZkMigrationIntegrationTest.$anonfun$verifyZKTopicPartitionMetadata$5(zkClient, partitions, replicationFactor, (Option)var7_11)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Unable to find topic partition metadata");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public Option<TopicDescription> topicDesc(String topic, Admin admin) {
        try {
            return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)admin.describeTopics(Collections.singleton(topic)).allTopicNames().get()).asScala().get((Object)topic);
        }
        catch (Throwable throwable) {
            return None$.MODULE$;
        }
    }

    public CompletableFuture<Object> sendAllocateProducerIds(ZkClusterInvocationContext.ZkClusterInstance zkClusterInstance) {
        NodeToControllerChannelManager channel = ((KafkaBroker)zkClusterInstance.getUnderlying().brokers().head()).clientToControllerChannelManager();
        int brokerId = ((KafkaBroker)zkClusterInstance.getUnderlying().brokers().head()).config().brokerId();
        long brokerEpoch = ((KafkaBroker)zkClusterInstance.getUnderlying().brokers().head()).replicaManager().brokerEpochSupplier().apply$mcJ$sp();
        AllocateProducerIdsRequest.Builder request = new AllocateProducerIdsRequest.Builder(new AllocateProducerIdsRequestData().setBrokerId(brokerId).setBrokerEpoch(brokerEpoch));
        CompletableFuture<Object> producerIdStart = new CompletableFuture<Object>();
        channel.sendRequest((AbstractRequest.Builder)request, new ControllerRequestCompletionHandler(null, producerIdStart){
            private final CompletableFuture producerIdStart$1;

            public void onTimeout() {
                this.producerIdStart$1.completeExceptionally(new TimeoutException("Request timed out"));
            }

            public void onComplete(ClientResponse response) {
                AllocateProducerIdsResponse body = (AllocateProducerIdsResponse)response.responseBody();
                if (body.data().errorCode() != 0) {
                    this.producerIdStart$1.completeExceptionally(new RuntimeException(new StringBuilder(20).append("Received error code ").append(body.data().errorCode()).toString()));
                    return;
                }
                this.producerIdStart$1.complete(BoxesRunTime.boxToLong((long)body.data().producerIdStart()));
            }
            {
                this.producerIdStart$1 = producerIdStart$1;
            }
        });
        return producerIdStart;
    }

    /*
     * WARNING - void declaration
     */
    public ProducerIdsBlock readProducerIdBlock(KafkaZkClient zkClient) {
        void var3_3;
        Tuple2 tuple2 = zkClient.getDataAndVersion("/latest_producer_id_block");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option dataOpt = (Option)tuple2._1();
        return (ProducerIdsBlock)var3_3.map((Function1 & Serializable)jsonData -> ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData(jsonData)).get();
    }

    /*
     * WARNING - void declaration
     */
    public void alterBrokerConfigs(Admin admin) {
        ConfigResource defaultBrokerResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        Collection defaultBrokerConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "86400000"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        ConfigResource broker0Resource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        ConfigResource broker1Resource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        Collection specificBrokerConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "43200000"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$alterBrokerConfigs$1(admin, defaultBrokerResource, defaultBrokerConfigs, broker0Resource, specificBrokerConfigs, broker1Resource);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var13_12 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void alterTopicConfig(Admin admin) {
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "test");
        Collection alterConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.bytes", "204800"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.ms", null), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))).asJavaCollection();
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$alterTopicConfig$1(admin, topicResource, alterConfigs);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var10_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void alterClientQuotas(Admin admin) {
        ArrayList<ClientQuotaAlteration> quotas = new ArrayList<ClientQuotaAlteration>();
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user@1")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), (List)Nil$.MODULE$)).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user@1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(800.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("user", null)), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(900.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"8.8.8.8")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)), (List)Nil$.MODULE$)).asJava()));
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$alterClientQuotas$1(admin, quotas);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var9_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    public AlterUserScramCredentialsResult createUserScramCredentials(Admin admin) {
        ArrayList<UserScramCredentialUpsertion> alterations = new ArrayList<UserScramCredentialUpsertion>();
        alterations.add(new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8190), "password0"));
        return admin.alterUserScramCredentials(alterations);
    }

    public AlterUserScramCredentialsResult alterUserScramCredentials(Admin admin) {
        ArrayList<UserScramCredentialUpsertion> alterations = new ArrayList<UserScramCredentialUpsertion>();
        alterations.add(new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8191), "password1"));
        alterations.add(new UserScramCredentialUpsertion("user@2", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8192), "password2"));
        return admin.alterUserScramCredentials(alterations);
    }

    public void verifyTopicConfigs(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyTopicConfigs$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void verifyBrokerConfigs(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyBrokerConfigs$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void verifyClientQuotas(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyClientQuotas$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void verifyUserScramCredentials(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyUserScramCredentials$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void shutdownInSequence(ClusterInstance zkCluster, KafkaClusterTestKit kraftCluster) {
        zkCluster.brokerIds().forEach(x$5 -> zkCluster.shutdownBroker(Predef$.MODULE$.Integer2int(x$5)));
        kraftCluster.close();
        zkCluster.stop();
    }

    public static final /* synthetic */ void $anonfun$testMigrateAcls$3(AclBinding acl1$1, AclBinding acl2$1, AclBinding acl3$1, AclBinding acl4$1, MetadataImage image) {
        java.util.Map aclMap = image.acls().acls();
        Assertions.assertEquals((int)4, (int)aclMap.size());
        Assertions.assertTrue((boolean)aclMap.values().containsAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl1$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl2$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl3$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl4$1), (List)Nil$.MODULE$))))).asJava()));
    }

    public static final /* synthetic */ boolean $anonfun$testStartZkBrokerWithAuthorizer$1(KafkaZkClient zkClient$1) {
        return zkClient$1.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testStartZkBrokerWithAuthorizer$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    private static final boolean inDualWrite$1(KafkaClusterTestKit kraftCluster$1) {
        return ((MigrationDriverState)((ControllerMigrationSupport)kraftCluster$1.controllers().get(BoxesRunTime.boxToInteger((int)3000)).migrationSupport().get()).migrationDriver().migrationState().get(10L, TimeUnit.SECONDS)).allowDualWrite();
    }

    public static final /* synthetic */ boolean $anonfun$testStartZkBrokerWithAuthorizer$3(KafkaClusterTestKit kraftCluster$1) {
        return ZkMigrationIntegrationTest.inDualWrite$1(kraftCluster$1);
    }

    public static final /* synthetic */ String $anonfun$testStartZkBrokerWithAuthorizer$4() {
        return "Timed out waiting for dual-write mode";
    }

    public static final /* synthetic */ void $anonfun$testMigrate$3(ClientQuotaEntity defaultUserEntity$1, ClientQuotaEntity defaultClientIdEntity$1, ClientQuotaEntity defaultIpEntity$1, ClientQuotaEntity userEntity$1, ClientQuotaEntity userClientEntity$1, ClientQuotaEntity ipEntity$1, MetadataImage image) {
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-1"));
        Assertions.assertEquals((int)2, (int)image.topics().getTopic("test-topic-1").partitions().size());
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-2"));
        Assertions.assertEquals((int)1, (int)image.topics().getTopic("test-topic-2").partitions().size());
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-3"));
        Assertions.assertEquals((int)10, (int)image.topics().getTopic("test-topic-3").partitions().size());
        java.util.Map clientQuotas = image.clientQuotas().entities();
        Assertions.assertEquals(new HashSet<ClientQuotaEntity>(Arrays.asList(defaultUserEntity$1, defaultClientIdEntity$1, defaultIpEntity$1, userEntity$1, userClientEntity$1, ipEntity$1)), clientQuotas.keySet());
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateTopicDeletions$1(KafkaZkClient zkClient$2) {
        return zkClient$2.getOrCreateMigrationState(ZkMigrationLeadershipState.EMPTY).initialZkMigrationComplete();
    }

    public static final /* synthetic */ String $anonfun$testMigrateTopicDeletions$2() {
        return "Timed out waiting for migration to complete";
    }

    private static final boolean topicsAllDeleted$1(Admin admin) {
        Set topics = (Set)admin.listTopics().names().get(60L, TimeUnit.SECONDS);
        topics.retainAll(Arrays.asList("test-topic-1", "test-topic-2", "test-topic-3"));
        return topics.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateTopicDeletions$3(ObjectRef admin$1) {
        return ZkMigrationIntegrationTest.topicsAllDeleted$1((Admin)admin$1.elem);
    }

    public static final /* synthetic */ String $anonfun$testMigrateTopicDeletions$4() {
        return "Timed out waiting for topics to be deleted";
    }

    private static final boolean topicsAllRecreated$1(Admin admin) {
        Set topics = (Set)admin.listTopics().names().get(60L, TimeUnit.SECONDS);
        topics.retainAll(Arrays.asList("test-topic-1", "test-topic-2", "test-topic-3"));
        return topics.size() == 3;
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateTopicDeletions$5(ObjectRef admin$1) {
        return ZkMigrationIntegrationTest.topicsAllRecreated$1((Admin)admin$1.elem);
    }

    public static final /* synthetic */ String $anonfun$testMigrateTopicDeletions$6() {
        return "Timed out waiting for topics to be created";
    }

    public static final /* synthetic */ void $anonfun$testMigrateTopicDeletions$9(Tuple2 x0$2) {
        if (x0$2 != null) {
            String topic = (String)x0$2._1();
            ((TopicDescription)x0$2._2()).partitions().forEach(partition -> {
                Assertions.assertEquals((int)3, (int)partition.replicas().size(), (String)new StringBuilder(35).append("Unexpected number of replicas for ").append(topic).append("-").append(partition.partition()).toString());
                Assertions.assertEquals((int)3, (int)partition.isr().size(), (String)new StringBuilder(20).append("Unexpected ISR for ").append(topic).append("-").append(partition.partition()).toString());
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testMigrateTopicDeletions$7(ObjectRef admin$1) {
        scala.collection.immutable.Map map;
        try {
            map = CollectionConverters$.MODULE$.MapHasAsScala(((Admin)admin$1.elem).describeTopics(Arrays.asList("test-topic-1", "test-topic-2", "test-topic-3")).topicNameValues()).asScala().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String name = (String)x0$1._1();
                    KafkaFuture description = (KafkaFuture)x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), description.get(60L, TimeUnit.SECONDS));
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException) {
                map = Predef$.MODULE$.Map().empty();
            }
            if (throwable != null) {
                map = (scala.collection.immutable.Map)Assertions.fail((String)"Error describing topics", (Throwable)throwable.getCause());
            }
            throw null;
        }
        scala.collection.immutable.Map topicDescriptions = map;
        Assertions.assertEquals((int)2, (int)((TopicDescription)topicDescriptions.apply((Object)"test-topic-1")).partitions().size());
        Assertions.assertEquals((int)1, (int)((TopicDescription)topicDescriptions.apply((Object)"test-topic-2")).partitions().size());
        Assertions.assertEquals((int)10, (int)((TopicDescription)topicDescriptions.apply((Object)"test-topic-3")).partitions().size());
        topicDescriptions.foreach((Function1 & Serializable)x0$2 -> {
            ZkMigrationIntegrationTest.$anonfun$testMigrateTopicDeletions$9(x0$2);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Set absentTopics = CollectionConverters$.MODULE$.SetHasAsScala((Set)((Admin)admin$1.elem).listTopics().names().get(60L, TimeUnit.SECONDS)).asScala();
        Assertions.assertTrue((boolean)absentTopics.contains((Object)"test-topic-1"));
        Assertions.assertTrue((boolean)absentTopics.contains((Object)"test-topic-2"));
        Assertions.assertTrue((boolean)absentTopics.contains((Object)"test-topic-3"));
    }

    public static final /* synthetic */ boolean $anonfun$testDualWriteScram$1(KafkaZkClient zkClient$3) {
        return zkClient$3.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWriteScram$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLogOnStartup$1(KafkaZkClient zkClient$4) {
        return zkClient$4.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDeleteLogOnStartup$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLogOnStartup$3(KafkaBroker broker) {
        Option option = broker.metadataCache().getControllerId();
        return option instanceof Some && ((Some)option).value() instanceof KRaftCachedControllerId;
    }

    private static final boolean hasKRaftController$1(ClusterInstance zkCluster$1) {
        return ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster$1).getUnderlying().brokers().forall((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$testDeleteLogOnStartup$3(broker)));
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLogOnStartup$4(ClusterInstance zkCluster$1) {
        return ZkMigrationIntegrationTest.hasKRaftController$1(zkCluster$1);
    }

    public static final /* synthetic */ String $anonfun$testDeleteLogOnStartup$5() {
        return "Timed out waiting for ZK brokers to see a KRaft controller";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLogOnStartup$6(ObjectRef admin$2) {
        return CollectionConverters$.MODULE$.SetHasAsScala((Set)((Admin)admin$2.elem).listTopics().names().get(30L, TimeUnit.SECONDS)).asScala().contains((Object)"testDeleteLogOnStartup");
    }

    public static final /* synthetic */ String $anonfun$testDeleteLogOnStartup$7() {
        return "Timed out listing topics";
    }

    public static final /* synthetic */ void $anonfun$testDualWrite$1(ZkMigrationIntegrationTest $this, LongRef nextProducerId$1, ClusterInstance zkCluster$2) {
        Assertions.assertDoesNotThrow(() -> {
            nextProducerId$1.elem = BoxesRunTime.unboxToLong((Object)this.sendAllocateProducerIds((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).get(20L, TimeUnit.SECONDS));
        });
    }

    public static final /* synthetic */ boolean $anonfun$testDualWrite$3(KafkaZkClient zkClient$5) {
        return zkClient$5.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWrite$4() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ void $anonfun$testDualWrite$5(ZkMigrationIntegrationTest $this, LongRef nextKRaftProducerId$1, ClusterInstance zkCluster$2) {
        Assertions.assertDoesNotThrow(() -> {
            nextKRaftProducerId$1.elem = BoxesRunTime.unboxToLong((Object)this.sendAllocateProducerIds((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).get(20L, TimeUnit.SECONDS));
        });
    }

    public static final /* synthetic */ boolean $anonfun$testDualWriteQuotaAndScram$1(KafkaZkClient zkClient$6) {
        return zkClient$6.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWriteQuotaAndScram$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testNewAndChangedTopicsInDualWrite$1(KafkaZkClient zkClient$7) {
        return zkClient$7.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testNewAndChangedTopicsInDualWrite$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ Option $anonfun$testNewAndChangedTopicsInDualWrite$3(ZkMigrationIntegrationTest $this, String topic1$1, ObjectRef admin$3) {
        return $this.topicDesc(topic1$1, (Admin)admin$3.elem);
    }

    public static final /* synthetic */ boolean $anonfun$testNewAndChangedTopicsInDualWrite$4(int newPartitionCount$1, Option td) {
        return td.isDefined() && CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)td.get()).partitions()).asScala().size() == newPartitionCount$1;
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentInHybridMode$1(KafkaZkClient zkClient$8) {
        return zkClient$8.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentInHybridMode$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentInHybridMode$5(ObjectRef admin$4) {
        return ((java.util.Map)((Admin)admin$4.elem).listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentInHybridMode$6() {
        return "Timed out waiting for reassignments to complete.";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentInHybridMode$7(ClusterInstance zkCluster$3, TopicPartition topicPartition$1) {
        Buffer<KafkaBroker> brokers = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster$3).getUnderlying().brokers();
        Assertions.assertTrue((brokers.size() == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((((KafkaBroker)brokers.head()).config().brokerId() == 0 ? 1 : 0) != 0);
        return ((KafkaBroker)brokers.head()).replicaManager().onlinePartition(topicPartition$1).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentInHybridMode$8() {
        return "Timed out waiting for removed replica reassignment to be marked offline";
    }

    public static final /* synthetic */ boolean $anonfun$createTopic$1(Admin admin$5, String topicName$1) {
        return ((Set)admin$5.listTopics().names().get()).contains(topicName$1);
    }

    public static final /* synthetic */ String $anonfun$createTopic$2(String topicName$1) {
        return new StringBuilder(21).append("Unable to find topic ").append(topicName$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$verifyKRaftTopicConfigs$1(ConfigEntry configEntry) {
        ConfigEntry.ConfigSource configSource = configEntry.source();
        ConfigEntry.ConfigSource configSource2 = ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG;
        return !(configSource != null ? !configSource.equals(configSource2) : configSource2 != null);
    }

    public static final /* synthetic */ void $anonfun$verifyKRaftTopicConfigs$2(java.util.Map configs$1, ConfigEntry c) {
        Assertions.assertEquals(configs$1.get(c.name()), (Object)c.value());
    }

    public static final /* synthetic */ String $anonfun$verifyZKTopicConfigs$2(String topicName$2) {
        return new StringBuilder(28).append("Unable to find ").append(ConfigEntityZNode$.MODULE$.path("topics", topicName$2)).append(" in ZooKeeper").toString();
    }

    public static final /* synthetic */ TopicPartition $anonfun$verifyZKTopicPartitionMetadata$1(String topicName$3, int pId) {
        return new TopicPartition(topicName$3, pId);
    }

    public static final /* synthetic */ Option $anonfun$verifyZKTopicPartitionMetadata$2(KafkaZkClient zkClient$10, String topicName$3) {
        return zkClient$10.getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName$3}))).headOption();
    }

    public static final /* synthetic */ boolean $anonfun$verifyZKTopicPartitionMetadata$4(IndexedSeq partitions$1, TopicZNode.TopicIdReplicaAssignment x$2) {
        return x$2.assignment().size() == partitions$1.size();
    }

    public static final /* synthetic */ boolean $anonfun$verifyZKTopicPartitionMetadata$7(TopicPartition tp$1, LeaderIsrAndControllerEpoch lisr$1, TopicZNode.TopicIdReplicaAssignment x$4) {
        Seq seq = ((ReplicaAssignment)x$4.assignment().apply((Object)tp$1)).replicas();
        List list = lisr$1.leaderAndIsr().isr();
        return !(seq != null ? !seq.equals(list) : list != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyZKTopicPartitionMetadata$6(short replicationFactor$2, Option topicIdReplicaAssignment$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            LeaderIsrAndControllerEpoch lisr = (LeaderIsrAndControllerEpoch)x0$1._2();
            return lisr.leaderAndIsr().isr().size() == replicationFactor$2 && lisr.leaderAndIsr().leader() >= 0 && topicIdReplicaAssignment$1.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyZKTopicPartitionMetadata$7(tp, lisr, x$4)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyZKTopicPartitionMetadata$5(KafkaZkClient zkClient$10, IndexedSeq partitions$1, short replicationFactor$2, Option topicIdReplicaAssignment$1) {
        Map lisrMap = zkClient$10.getTopicPartitionStates((Seq)partitions$1);
        return lisrMap.size() == partitions$1.size() && lisrMap.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyZKTopicPartitionMetadata$6(replicationFactor$2, topicIdReplicaAssignment$1, x0$1)));
    }

    public static final /* synthetic */ String $anonfun$verifyZKTopicPartitionMetadata$8() {
        return "Unable to find topic partition metadata";
    }

    public static final /* synthetic */ void $anonfun$alterBrokerConfigs$1(Admin admin$6, ConfigResource defaultBrokerResource$1, Collection defaultBrokerConfigs$1, ConfigResource broker0Resource$1, Collection specificBrokerConfigs$1, ConfigResource broker1Resource$1) {
        try {
            admin$6.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBrokerResource$1), (Object)defaultBrokerConfigs$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker0Resource$1), (Object)specificBrokerConfigs$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker1Resource$1), (Object)specificBrokerConfigs$1)}))).asJava()).all().get(10L, TimeUnit.SECONDS);
            return;
        }
        catch (Throwable t) {
            Assertions.fail((String)"Alter Broker Configs had an error", (Throwable)t);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$alterTopicConfig$1(Admin admin$7, ConfigResource topicResource$1, Collection alterConfigs$1) {
        try {
            admin$7.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource$1), (Object)alterConfigs$1)}))).asJava()).all().get(10L, TimeUnit.SECONDS);
            return;
        }
        catch (Throwable t) {
            Assertions.fail((String)"Alter Topic Configs had an error", (Throwable)t);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$alterClientQuotas$1(Admin admin$8, ArrayList quotas$1) {
        try {
            admin$8.alterClientQuotas((Collection)quotas$1).all().get(10L, TimeUnit.SECONDS);
            return;
        }
        catch (Throwable t) {
            Assertions.fail((String)"Alter Client Quotas had an error", (Throwable)t);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$verifyTopicConfigs$1(KafkaZkClient zkClient$11) {
        Properties propsAfter = zkClient$11.getEntityConfigs("topics", "test");
        Assertions.assertEquals((Object)"204800", (Object)propsAfter.getProperty("segment.bytes"));
        Assertions.assertFalse((boolean)propsAfter.containsKey("segment.ms"));
    }

    public static final /* synthetic */ void $anonfun$verifyBrokerConfigs$1(KafkaZkClient zkClient$12) {
        Properties defaultBrokerProps = zkClient$12.getEntityConfigs("brokers", "<default>");
        Assertions.assertEquals((Object)"86400000", (Object)defaultBrokerProps.getProperty(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG));
        Properties broker0Props = zkClient$12.getEntityConfigs("brokers", "0");
        Assertions.assertEquals((Object)"43200000", (Object)broker0Props.getProperty(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG));
        Properties broker1Props = zkClient$12.getEntityConfigs("brokers", "1");
        Assertions.assertEquals((Object)"43200000", (Object)broker1Props.getProperty(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG));
    }

    public static final /* synthetic */ void $anonfun$verifyClientQuotas$1(KafkaZkClient zkClient$13) {
        Assertions.assertEquals((Object)"1000", (Object)zkClient$13.getEntityConfigs("users", Sanitizer.sanitize((String)"user@1")).getProperty("consumer_byte_rate"));
        Assertions.assertEquals((Object)"900", (Object)zkClient$13.getEntityConfigs("users", "<default>").getProperty("consumer_byte_rate"));
        Assertions.assertEquals((Object)"800", (Object)zkClient$13.getEntityConfigs(new StringBuilder(14).append("users/").append(Sanitizer.sanitize((String)"user@1")).append("/clients").toString(), "clientA").getProperty("consumer_byte_rate"));
        Assertions.assertEquals((Object)"100", (Object)zkClient$13.getEntityConfigs(new StringBuilder(14).append("users/").append(Sanitizer.sanitize((String)"user@1")).append("/clients").toString(), "clientA").getProperty("producer_byte_rate"));
        Assertions.assertEquals((Object)"10", (Object)zkClient$13.getEntityConfigs("ips", "8.8.8.8").getProperty("connection_creation_rate"));
    }

    public static final /* synthetic */ void $anonfun$verifyUserScramCredentials$1(KafkaZkClient zkClient$14) {
        ScramCredential scramCredentials1 = ScramCredentialUtils.credentialFromString((String)zkClient$14.getEntityConfigs("users", Sanitizer.sanitize((String)"user1")).getProperty("SCRAM-SHA-256"));
        Assertions.assertEquals((int)8191, (int)scramCredentials1.iterations());
        String propertyValue2 = zkClient$14.getEntityConfigs("users", Sanitizer.sanitize((String)"user@2")).getProperty("SCRAM-SHA-256");
        Assertions.assertNotNull((Object)propertyValue2);
        ScramCredential scramCredentials2 = ScramCredentialUtils.credentialFromString((String)propertyValue2);
        Assertions.assertEquals((int)8192, (int)scramCredentials2.iterations());
    }

    public static final /* synthetic */ Object $anonfun$testNewAndChangedTopicsInDualWrite$4$adapted(int newPartitionCount$1, Option td) {
        return BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$4(newPartitionCount$1, td));
    }

    public static final /* synthetic */ Object $anonfun$verifyZKTopicPartitionMetadata$3$adapted(IndexedSeq partitions$1, Option x) {
        return BoxesRunTime.boxToBoolean((boolean)x.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyZKTopicPartitionMetadata$4(partitions$1, x$2))));
    }

    public class MetadataDeltaVerifier {
        private final MetadataDelta metadataDelta;
        private int offset;

        public MetadataDelta metadataDelta() {
            return this.metadataDelta;
        }

        public int offset() {
            return this.offset;
        }

        public void offset_$eq(int x$1) {
            this.offset = x$1;
        }

        public void accept(java.util.List<ApiMessageAndVersion> batch) {
            batch.forEach(message -> {
                this.metadataDelta().replay(message.message());
                this.offset_$eq(this.offset() + 1);
            });
        }

        public void verify(Function1<MetadataImage, BoxedUnit> verifier) {
            MetadataImage image = this.metadataDelta().apply(new MetadataProvenance((long)this.offset(), 0, 0L));
            verifier.apply((Object)image);
        }

        public /* synthetic */ ZkMigrationIntegrationTest kafka$zk$ZkMigrationIntegrationTest$MetadataDeltaVerifier$$$outer() {
            return ZkMigrationIntegrationTest.this;
        }

        public MetadataDeltaVerifier() {
            if (ZkMigrationIntegrationTest.this == null) {
                throw null;
            }
            this.metadataDelta = new MetadataDelta(MetadataImage.EMPTY);
            this.offset = 0;
        }
    }
}

