/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.cxf;

import jakarta.validation.ValidationException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.attrvalue.InvalidEntityException;
import org.apache.syncope.core.persistence.api.attrvalue.ParsingValidationException;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.MalformedPathException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.apache.syncope.core.workflow.api.WorkflowException;
import org.apache.syncope.ext.scimv2.api.BadRequestException;
import org.apache.syncope.ext.scimv2.api.data.SCIMError;
import org.apache.syncope.ext.scimv2.api.type.ErrorType;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.transaction.TransactionSystemException;

@Provider
public class SCIMExceptionMapper
implements ExceptionMapper<Exception> {
    protected static final Logger LOG = LoggerFactory.getLogger(SCIMExceptionMapper.class);
    protected static Class<?> ENTITYEXISTS_EXCLASS = null;
    protected static Class<?> PERSISTENCE_EXCLASS = null;
    protected static Class<?> ROLLBACK_EXCLASS = null;
    protected static Class<?> JPASYSTEM_EXCLASS = null;
    protected static Class<?> CONNECTOR_EXCLASS = null;
    protected static Class<?> IBATISPERSISTENCE_EXCLASS = null;

    public Response toResponse(Exception ex) {
        Response.ResponseBuilder builder;
        LOG.error("Exception thrown", (Throwable)ex);
        if (ex instanceof AccessDeniedException || ex instanceof ForbiddenException || ex instanceof NotAuthorizedException) {
            builder = null;
        } else {
            if (ex instanceof NotFoundException) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new SCIMError(null, Response.Status.NOT_FOUND.getStatusCode(), ExceptionUtils.getRootCauseMessage((Throwable)ex))).build();
            }
            if (ex instanceof SyncopeClientException) {
                SyncopeClientException sce = (SyncopeClientException)ex;
                builder = this.builder(sce.getType(), ExceptionUtils.getRootCauseMessage((Throwable)ex));
            } else if (ex instanceof DelegatedAdministrationException || ExceptionUtils.getRootCause((Throwable)ex) instanceof DelegatedAdministrationException) {
                builder = this.builder(ClientExceptionType.DelegatedAdministration, ExceptionUtils.getRootCauseMessage((Throwable)ex));
            } else if (ENTITYEXISTS_EXCLASS.isAssignableFrom(ex.getClass()) || ex instanceof DuplicateException || PERSISTENCE_EXCLASS.isAssignableFrom(ex.getClass()) && ENTITYEXISTS_EXCLASS.isAssignableFrom(ex.getCause().getClass())) {
                builder = this.builder(ClientExceptionType.EntityExists, ExceptionUtils.getRootCauseMessage((Throwable)ex));
            } else if (ex instanceof DataIntegrityViolationException || JPASYSTEM_EXCLASS.isAssignableFrom(ex.getClass())) {
                builder = this.builder(ClientExceptionType.DataIntegrityViolation, ExceptionUtils.getRootCauseMessage((Throwable)ex));
            } else if (CONNECTOR_EXCLASS.isAssignableFrom(ex.getClass())) {
                builder = this.builder(ClientExceptionType.ConnectorException, ExceptionUtils.getRootCauseMessage((Throwable)ex));
            } else {
                builder = this.processInvalidEntityExceptions(ex);
                if (builder == null) {
                    builder = this.processBadRequestExceptions(ex);
                }
                if (builder == null && ex instanceof ValidationException) {
                    builder = this.builder(ClientExceptionType.RESTValidation, ExceptionUtils.getRootCauseMessage((Throwable)ex));
                }
                if (builder == null && ex instanceof UnsupportedOperationException) {
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new SCIMError(ErrorType.invalidSyntax, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ExceptionUtils.getRootCauseMessage((Throwable)ex)));
                }
                if (builder == null) {
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ExceptionUtils.getRootCauseMessage((Throwable)ex));
                }
            }
        }
        return Optional.ofNullable(builder).map(Response.ResponseBuilder::build).orElse(null);
    }

    protected Response.ResponseBuilder processInvalidEntityExceptions(Exception ex) {
        Throwable throwable;
        InvalidEntityException iee = null;
        if (ex instanceof InvalidEntityException) {
            InvalidEntityException entityException;
            iee = entityException = (InvalidEntityException)ex;
        }
        if (ex instanceof TransactionSystemException && ROLLBACK_EXCLASS.isAssignableFrom(ex.getCause().getClass()) && (throwable = ex.getCause().getCause()) instanceof InvalidEntityException) {
            InvalidEntityException invalidEntityException;
            iee = invalidEntityException = (InvalidEntityException)throwable;
        }
        if (iee != null) {
            ClientExceptionType exType;
            if (iee.getEntityClassSimpleName().endsWith("Policy")) {
                exType = ClientExceptionType.InvalidPolicy;
            } else if (iee.getEntityClassSimpleName().equals(PlainAttr.class.getSimpleName())) {
                exType = ClientExceptionType.InvalidValues;
            } else {
                try {
                    exType = ClientExceptionType.valueOf((String)("Invalid" + iee.getEntityClassSimpleName()));
                }
                catch (IllegalArgumentException e) {
                    exType = ClientExceptionType.InvalidEntity;
                }
            }
            StringBuilder msg = new StringBuilder();
            for (Map.Entry violation : iee.getViolations().entrySet()) {
                for (EntityViolationType violationType : (Set)violation.getValue()) {
                    msg.append(violationType.name()).append(": ").append(violationType.getMessage()).append('\n');
                }
            }
            return this.builder(exType, msg.toString());
        }
        return null;
    }

    protected Response.ResponseBuilder processBadRequestExceptions(Exception ex) {
        if (ex instanceof WorkflowException) {
            return this.builder(ClientExceptionType.Workflow, ExceptionUtils.getRootCauseMessage((Throwable)ex));
        }
        if (PERSISTENCE_EXCLASS.isAssignableFrom(ex.getClass())) {
            return this.builder(ClientExceptionType.GenericPersistence, ExceptionUtils.getRootCauseMessage((Throwable)ex));
        }
        if (IBATISPERSISTENCE_EXCLASS != null && IBATISPERSISTENCE_EXCLASS.isAssignableFrom(ex.getClass())) {
            return this.builder(ClientExceptionType.Workflow, "Currently unavailable. Please try later.");
        }
        if (JPASYSTEM_EXCLASS.isAssignableFrom(ex.getClass())) {
            return this.builder(ClientExceptionType.DataIntegrityViolation, ExceptionUtils.getRootCauseMessage((Throwable)ex));
        }
        if (ex instanceof ConfigurationException) {
            return this.builder(ClientExceptionType.InvalidConnIdConf, ExceptionUtils.getRootCauseMessage((Throwable)ex));
        }
        if (ex instanceof ParsingValidationException) {
            return this.builder(ClientExceptionType.InvalidValues, ExceptionUtils.getRootCauseMessage((Throwable)ex));
        }
        if (ex instanceof MalformedPathException) {
            return this.builder(ClientExceptionType.InvalidPath, ExceptionUtils.getRootCauseMessage((Throwable)ex));
        }
        if (ex instanceof BadRequestException) {
            BadRequestException badRequestException = (BadRequestException)ex;
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new SCIMError(badRequestException));
        }
        return null;
    }

    protected Response.ResponseBuilder builder(ClientExceptionType hType, String msg) {
        Response.ResponseBuilder builder = Response.status((Response.Status)hType.getResponseStatus());
        ErrorType scimType = null;
        if (hType.name().startsWith("Invalid") || hType == ClientExceptionType.RESTValidation) {
            scimType = ErrorType.invalidValue;
        } else if (hType == ClientExceptionType.EntityExists) {
            scimType = ErrorType.uniqueness;
        }
        return builder.entity((Object)new SCIMError(scimType, hType.getResponseStatus().getStatusCode(), msg));
    }

    static {
        try {
            ENTITYEXISTS_EXCLASS = Class.forName("jakarta.persistence.EntityExistsException");
            PERSISTENCE_EXCLASS = Class.forName("jakarta.persistence.PersistenceException");
            ROLLBACK_EXCLASS = Class.forName("jakarta.persistence.RollbackException");
            JPASYSTEM_EXCLASS = Class.forName("org.springframework.orm.jpa.JpaSystemException");
            CONNECTOR_EXCLASS = Class.forName("org.identityconnectors.framework.common.exceptions.ConnectorException");
            IBATISPERSISTENCE_EXCLASS = Class.forName("org.apache.ibatis.exceptions.PersistenceException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

