/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.spring;

import jakarta.persistence.Cache;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.Query;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.metamodel.Metamodel;
import java.io.Closeable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.syncope.common.keymaster.client.api.model.JPADomain;
import org.apache.syncope.core.persistence.jpa.DomainProperties;
import org.apache.syncope.core.persistence.jpa.PersistenceProperties;
import org.apache.syncope.core.persistence.jpa.openjpa.ConnectorManagerRemoteCommitListener;
import org.apache.syncope.core.persistence.jpa.spring.CommonEntityManagerFactoryConf;
import org.apache.syncope.core.persistence.jpa.spring.DomainEntityManagerFactoryBean;
import org.apache.syncope.core.persistence.jpa.spring.OpenJpaVendorAdapter;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.orm.jpa.JpaVendorAdapter;

public class DomainRoutingEntityManagerFactory
implements EntityManagerFactory,
Closeable {
    protected static final Logger LOG = LoggerFactory.getLogger(DomainRoutingEntityManagerFactory.class);
    protected final CommonEntityManagerFactoryConf commonEMFConf;
    protected final Map<String, EntityManagerFactory> delegates = new ConcurrentHashMap<String, EntityManagerFactory>();

    public DomainRoutingEntityManagerFactory(CommonEntityManagerFactoryConf commonEMFConf) {
        this.commonEMFConf = commonEMFConf;
    }

    protected void addToJpaPropertyMap(DomainEntityManagerFactoryBean emf, OpenJpaVendorAdapter vendorAdapter, String dbSchema, String orm, String metadataFactory) {
        emf.getJpaPropertyMap().putAll(vendorAdapter.getJpaPropertyMap());
        Optional.ofNullable(dbSchema).ifPresent(s -> emf.getJpaPropertyMap().put("openjpa.jdbc.Schema", s));
        Optional.ofNullable(metadataFactory).ifPresent(m -> emf.getJpaPropertyMap().put("openjpa.MetaDataFactory", m.replace("##orm##", orm)));
    }

    public void master(PersistenceProperties props, JndiObjectFactoryBean dataSource) {
        OpenJpaVendorAdapter vendorAdapter = new OpenJpaVendorAdapter();
        vendorAdapter.setShowSql(false);
        vendorAdapter.setGenerateDdl(true);
        vendorAdapter.setDatabasePlatform(((DomainProperties)((Object)props.getDomain().getFirst())).getDatabasePlatform());
        DomainEntityManagerFactoryBean emf = new DomainEntityManagerFactoryBean();
        emf.setPersistenceUnitName("Master");
        emf.setMappingResources(new String[]{((DomainProperties)((Object)props.getDomain().getFirst())).getOrm()});
        emf.setDataSource(Objects.requireNonNull((DataSource)dataSource.getObject()));
        emf.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        emf.setCommonEntityManagerFactoryConf(this.commonEMFConf);
        emf.setConnectorManagerRemoteCommitListener(new ConnectorManagerRemoteCommitListener("Master"));
        this.addToJpaPropertyMap(emf, vendorAdapter, ((DomainProperties)((Object)props.getDomain().getFirst())).getDbSchema(), ((DomainProperties)((Object)props.getDomain().getFirst())).getOrm(), props.getMetaDataFactory());
        emf.afterPropertiesSet();
        this.delegates.put("Master", emf.getObject());
    }

    public void domain(JPADomain domain, DataSource dataSource, String metadataFactory) {
        OpenJpaVendorAdapter vendorAdapter = new OpenJpaVendorAdapter();
        vendorAdapter.setShowSql(false);
        vendorAdapter.setGenerateDdl(true);
        vendorAdapter.setDatabasePlatform(domain.getDatabasePlatform());
        DomainEntityManagerFactoryBean emf = new DomainEntityManagerFactoryBean();
        emf.setPersistenceUnitName(domain.getKey());
        emf.setMappingResources(new String[]{domain.getOrm()});
        emf.setDataSource(dataSource);
        emf.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        emf.setCommonEntityManagerFactoryConf(this.commonEMFConf);
        emf.setConnectorManagerRemoteCommitListener(new ConnectorManagerRemoteCommitListener(domain.getKey()));
        this.addToJpaPropertyMap(emf, vendorAdapter, domain.getDbSchema(), domain.getOrm(), metadataFactory);
        emf.afterPropertiesSet();
        this.delegates.put(domain.getKey(), emf.getObject());
    }

    public void remove(String domain) {
        EntityManagerFactory emf = this.delegates.remove(domain);
        this.close(domain, emf);
    }

    protected EntityManagerFactory delegate() {
        return this.delegates.computeIfAbsent(AuthContextUtils.getDomain(), domain -> {
            throw new IllegalStateException("Could not find EntityManagerFactory for domain " + domain);
        });
    }

    public EntityManager createEntityManager() {
        return this.delegate().createEntityManager();
    }

    public EntityManager createEntityManager(Map map) {
        return this.delegate().createEntityManager(map);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        return this.delegate().createEntityManager(synchronizationType);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        return this.delegate().createEntityManager(synchronizationType, map);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.delegate().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.delegate().getMetamodel();
    }

    public boolean isOpen() {
        return this.delegate().isOpen();
    }

    protected void close(String domain, EntityManagerFactory emf) {
        LOG.info("Closing JPA EntityManagerFactory for persistence unit '{}'", (Object)domain);
        try {
            emf.close();
        }
        catch (Exception e) {
            LOG.error("While closing EntityManagerFactory for persistence unit '{}'", (Object)domain, (Object)e);
        }
    }

    @Override
    public void close() {
        this.delegates.forEach(this::close);
    }

    public Map<String, Object> getProperties() {
        return this.delegate().getProperties();
    }

    public Cache getCache() {
        return this.delegate().getCache();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.delegate().getPersistenceUnitUtil();
    }

    public void addNamedQuery(String name, Query query) {
        this.delegate().addNamedQuery(name, query);
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.delegate().unwrap(cls);
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        this.delegate().addNamedEntityGraph(graphName, entityGraph);
    }
}

