/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.search;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;

public final class SearchableFields {
    private static final String[] ATTRIBUTES_NOTINCLUDED = new String[]{"serialVersionUID", "discriminator", "password", "type", "udynMembershipCond", "securityAnswer", "token", "tokenExpireTime"};
    private static final Set<String> ANY_FIELDS = new HashSet<String>();

    public static boolean contains(String schema) {
        return ANY_FIELDS.contains(schema);
    }

    public static Map<String, AttrSchemaType> get(Class<? extends AnyTO> anyRef) {
        TreeMap<String, AttrSchemaType> fields = new TreeMap<String, AttrSchemaType>(Collections.reverseOrder());
        for (Class<? extends AnyTO> clazz = anyRef; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (ArrayUtils.contains((Object[])ATTRIBUTES_NOTINCLUDED, (Object)field.getName()) || Collection.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType())) continue;
                fields.put(field.getName(), AttrSchemaType.getAttrSchemaTypeByClass(field.getType()));
            }
        }
        return fields;
    }

    private SearchableFields() {
    }

    static {
        ANY_FIELDS.addAll(SearchableFields.get(UserTO.class).keySet());
        ANY_FIELDS.addAll(SearchableFields.get(GroupTO.class).keySet());
        ANY_FIELDS.addAll(SearchableFields.get(AnyObjectTO.class).keySet());
    }
}

