/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverConfig;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.Collapsible;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.ListViewPanel;
import org.apache.syncope.client.console.panels.search.AbstractSearchPanel;
import org.apache.syncope.client.console.panels.search.ConnObjectSearchPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchClausePanel;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.ReconciliationRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.CollectionPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.status.StatusUtils;
import org.apache.syncope.client.ui.commons.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.ReconStatus;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.MatchType;
import org.apache.syncope.common.rest.api.beans.ConnObjectTOQuery;
import org.apache.syncope.common.rest.api.beans.ReconQuery;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnObjectListViewPanel
extends Panel {
    private static final long serialVersionUID = 4986172040062752781L;
    protected static final Logger LOG = LoggerFactory.getLogger(ConnObjectListViewPanel.class);
    protected static final int SIZE = 10;
    protected static final String STATUS = "Status";
    @SpringBean
    protected ReconciliationRestClient reconciliationRestClient;
    @SpringBean
    protected ResourceRestClient resourceRestClient;
    @SpringBean
    protected AnyTypeRestClient anyTypeRestClient;
    protected String nextPageCookie;
    protected AbstractSearchPanel searchPanel;
    protected WebMarkupContainer arrows;
    protected String anyType;
    protected ResourceTO resource;
    protected final PageReference pageRef;

    protected ConnObjectListViewPanel(String id, final ResourceTO resource, final String anyType, final PageReference pageRef) {
        super(id);
        this.anyType = anyType;
        this.resource = resource;
        this.pageRef = pageRef;
        final Model model = Model.of((Serializable)Integer.valueOf(-1));
        final StringResourceModel res = new StringResourceModel("search.result", (Component)this, (IModel)new Model((Serializable)((Object)anyType)));
        Accordion accordion = new Accordion("accordionPanel", List.of(new AbstractTab((IModel)res){
            private static final long serialVersionUID = 1037272333056449377L;

            public WebMarkupContainer getPanel(String panelId) {
                ConnObjectListViewPanel.this.searchPanel = ConnObjectListViewPanel.this.getSearchPanel(panelId, anyType);
                return ConnObjectListViewPanel.this.searchPanel;
            }
        }), (IModel)model){
            private static final long serialVersionUID = 6581261306163L;

            protected Component newTitle(String markupId, ITab tab, Collapsible.State state) {
                return new AjaxLink<Integer>(markupId){
                    private static final long serialVersionUID = 6584438659172L;

                    protected void onComponentTag(ComponentTag tag) {
                        super.onComponentTag(tag);
                        tag.put("style", (CharSequence)"color: #337ab7");
                    }

                    public void onClick(AjaxRequestTarget target) {
                        model.setObject((Serializable)Integer.valueOf((Integer)model.getObject() == 0 ? -1 : 0));
                    }
                }.setBody((IModel)res);
            }
        };
        accordion.setOutputMarkupId(true);
        this.add(new Component[]{accordion.setEnabled(true).setVisible(true)});
        List<ConnObject> listOfItems = this.reloadItems(resource.getKey(), anyType, null, null);
        ListViewPanel.Builder<ConnObject> builder = new ListViewPanel.Builder<ConnObject>(ConnObject.class, pageRef){
            private static final long serialVersionUID = -8251750413385566738L;

            protected Component getValueComponent(String key, ConnObject bean) {
                if (Strings.CS.equals(key, ConnObjectListViewPanel.STATUS)) {
                    ReconStatus status;
                    try {
                        status = ConnObjectListViewPanel.this.reconciliationRestClient.status(new ReconQuery.Builder(anyType, resource.getKey()).fiql(bean.getFiql()).build());
                    }
                    catch (Exception e) {
                        LOG.error("While requesting for reconciliation status of {} {} with FIQL '{}'", new Object[]{anyType, resource.getKey(), bean.getFiql(), e});
                        status = new ReconStatus();
                    }
                    return status.getOnSyncope() == null ? StatusUtils.getLabel((String)"field", (String)"notfound icon", (String)"Not found", (String)"fas fa-minus-circle") : new Label("field", (IModel)Model.of()).add(new Behavior[]{new PopoverBehavior((IModel)Model.of(), (IModel)Model.of((Serializable)((Object)status.getAnyKey())), new PopoverConfig().withTitle((String)(status.getMatchType() == MatchType.LINKED_ACCOUNT ? MatchType.LINKED_ACCOUNT.name() + ", " + String.valueOf(AnyTypeKind.USER) : status.getAnyTypeKind().name())).withPlacement((TooltipConfig.IPlacement)TooltipConfig.Placement.left)){
                        private static final long serialVersionUID = -7867802555691605021L;

                        protected String createRelAttribute() {
                            return "field";
                        }

                        public void onComponentTag(Component component, ComponentTag tag) {
                            super.onComponentTag(component, tag);
                            tag.put("class", (CharSequence)"far fa-check-circle");
                        }
                    }});
                }
                Optional<Attr> attr = bean.getAttrs().stream().filter(object -> object.getSchema().equals(key)).findAny();
                return attr.filter(a -> !a.getValues().isEmpty()).map(a -> new CollectionPanel("field", a.getValues())).orElseGet(() -> new Label("field", (Serializable)((Object)"")));
            }
        };
        builder.setReuseItem(false);
        builder.addAction((ActionLink)new ActionLink<ConnObject>(){
            private static final long serialVersionUID = 7511002881490248598L;

            public void onClick(AjaxRequestTarget target, ConnObject modelObject) {
                ConnObjectListViewPanel.this.viewConnObject(modelObject, target);
            }
        }, ActionLink.ActionType.VIEW, "RESOURCE_GET_CONNOBJECT").setItems(listOfItems).includes(new String[]{"__UID__", "__NAME__", "__ENABLE__"}).withChecks(ListViewPanel.CheckAvailability.NONE).setReuseItem(false);
        if (!Strings.CS.equals(anyType, "REALM")) {
            builder.addAction((ActionLink)new ActionLink<ConnObject>(){
                private static final long serialVersionUID = 6377238742125L;

                public void onClick(AjaxRequestTarget target, ConnObject modelObject) {
                    try {
                        ReconStatus status = ConnObjectListViewPanel.this.reconciliationRestClient.status(new ReconQuery.Builder(anyType, resource.getKey()).fiql(modelObject.getFiql()).build());
                        ConnObjectListViewPanel.this.pullConnObject(modelObject.getFiql(), target, resource.getKey(), anyType, status.getRealm(), StringUtils.isNotBlank((CharSequence)status.getAnyKey()), pageRef);
                    }
                    catch (Exception e) {
                        LOG.error("While puling single object {} {} with FIQL '{}'", new Object[]{anyType, resource.getKey(), modelObject.getFiql(), e});
                        SyncopeConsoleSession.get().onException(e);
                        ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                }
            }, ActionLink.ActionType.RECONCILIATION_PULL, "TASK_EXECUTE");
            builder.includes(new String[]{STATUS});
        }
        this.add(new Component[]{builder.build("objs")});
        this.arrows = new WebMarkupContainer("arrows");
        this.add(new Component[]{this.arrows.setOutputMarkupId(true)});
        this.arrows.add(new Component[]{new AjaxLink<Serializable>("next"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                List<ConnObject> listOfItems = ConnObjectListViewPanel.this.reloadItems(resource.getKey(), anyType, ConnObjectListViewPanel.this.nextPageCookie, ConnObjectListViewPanel.this.getFiql());
                target.add(new Component[]{ConnObjectListViewPanel.this.arrows});
                this.send((IEventSink)ConnObjectListViewPanel.this, Broadcast.DEPTH, new ListViewPanel.ListViewReload(listOfItems, target));
            }

            public boolean isVisible() {
                return ConnObjectListViewPanel.this.nextPageCookie != null;
            }
        }});
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof SearchClausePanel.SearchEvent) {
            this.nextPageCookie = null;
            AjaxRequestTarget target = ((SearchClausePanel.SearchEvent)SearchClausePanel.SearchEvent.class.cast(event.getPayload())).getTarget();
            List<ConnObject> listOfItems = this.reloadItems(this.resource.getKey(), this.anyType, null, this.getFiql());
            target.add(new Component[]{this.arrows});
            this.send((IEventSink)this, Broadcast.DEPTH, new ListViewPanel.ListViewReload(listOfItems, target));
        } else {
            super.onEvent(event);
        }
    }

    protected abstract void viewConnObject(ConnObject var1, AjaxRequestTarget var2);

    protected abstract void pullConnObject(String var1, AjaxRequestTarget var2, String var3, String var4, String var5, boolean var6, PageReference var7);

    protected List<ConnObject> reloadItems(String resource, String anyType, String cookie, String fiql) {
        Pair<String, List<ConnObject>> items = this.resourceRestClient.searchConnObjects(resource, anyType, new ConnObjectTOQuery.Builder().size(Integer.valueOf(10)).pagedResultsCookie(cookie).fiql(fiql), (SortParam<String>)new SortParam((Object)"__UID__", true));
        this.nextPageCookie = (String)items.getLeft();
        return (List)items.getRight();
    }

    protected AbstractSearchPanel getSearchPanel(String id, String anyType) {
        ArrayList<SearchClause> clauses = new ArrayList<SearchClause>();
        SearchClause clause = new SearchClause();
        clauses.add(clause);
        clause.setComparator(SearchClause.Comparator.EQUALS);
        clause.setType(SearchClause.Type.ATTRIBUTE);
        clause.setProperty("");
        AnyTypeKind anyTypeKind = Strings.CS.equals(anyType, "REALM") || StringUtils.isEmpty((CharSequence)anyType) ? AnyTypeKind.ANY_OBJECT : this.anyTypeRestClient.read(anyType).getKind();
        return new ConnObjectSearchPanel.Builder(this.resource, anyTypeKind, anyType, (IModel<List<SearchClause>>)new ListModel(clauses), this.pageRef).required(true).enableSearch().build(id);
    }

    protected String getFiql() {
        return SearchUtils.buildFIQL((List)((List)this.searchPanel.getModel().getObject()), (AbstractFiqlSearchConditionBuilder)SyncopeClient.getConnObjectTOFiqlSearchConditionBuilder(), (Map)this.searchPanel.getAvailableSchemaTypes(), (Function)SearchUtils.NO_CUSTOM_CONDITION);
    }
}

