/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.websocket.common.io;

import com.signalfx.shaded.jetty.io.ByteBufferPool;
import com.signalfx.shaded.jetty.io.EndPoint;
import com.signalfx.shaded.jetty.util.BufferUtil;
import com.signalfx.shaded.jetty.util.IteratingCallback;
import com.signalfx.shaded.jetty.util.log.Log;
import com.signalfx.shaded.jetty.util.log.Logger;
import com.signalfx.shaded.jetty.websocket.api.BatchMode;
import com.signalfx.shaded.jetty.websocket.api.WriteCallback;
import com.signalfx.shaded.jetty.websocket.api.extensions.Frame;
import com.signalfx.shaded.jetty.websocket.common.Generator;
import com.signalfx.shaded.jetty.websocket.common.frames.BinaryFrame;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;

public class FrameFlusher
extends IteratingCallback {
    public static final BinaryFrame FLUSH_FRAME = new BinaryFrame();
    private static final Logger LOG = Log.getLogger(FrameFlusher.class);
    private final ByteBufferPool bufferPool;
    private final EndPoint endPoint;
    private final int bufferSize;
    private final Generator generator;
    private final int maxGather;
    private final Deque<FrameEntry> queue = new ArrayDeque<FrameEntry>();
    private final List<FrameEntry> entries;
    private final List<ByteBuffer> buffers;
    private final LongAdder messagesOut = new LongAdder();
    private final LongAdder bytesOut = new LongAdder();
    private boolean closed;
    private boolean canEnqueue = true;
    private Throwable terminated;
    private ByteBuffer aggregate;
    private BatchMode batchMode;

    public FrameFlusher(ByteBufferPool bufferPool, Generator generator, EndPoint endPoint, int bufferSize, int maxGather) {
        this.bufferPool = bufferPool;
        this.endPoint = endPoint;
        this.bufferSize = bufferSize;
        this.generator = Objects.requireNonNull(generator);
        this.maxGather = maxGather;
        this.entries = new ArrayList<FrameEntry>(maxGather);
        this.buffers = new ArrayList<ByteBuffer>(maxGather * 2 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueue(Frame frame, WriteCallback callback, BatchMode batchMode) {
        Throwable dead;
        FrameEntry entry = new FrameEntry(frame, callback, batchMode);
        FrameFlusher frameFlusher = this;
        synchronized (frameFlusher) {
            if (this.canEnqueue) {
                dead = this.terminated;
                if (dead == null) {
                    byte opCode = frame.getOpCode();
                    if (opCode == 9 || opCode == 10) {
                        this.queue.offerFirst(entry);
                    } else {
                        this.queue.offerLast(entry);
                    }
                    if (opCode == 8) {
                        this.canEnqueue = false;
                    }
                }
            } else {
                dead = new ClosedChannelException();
            }
        }
        if (dead == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Enqueued {} to {}", entry, this);
            }
            return true;
        }
        this.notifyCallbackFailure(callback, dead);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IteratingCallback.Action process() throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Flushing {}", this);
        }
        int space = this.aggregate == null ? this.bufferSize : BufferUtil.space(this.aggregate);
        BatchMode currentBatchMode = BatchMode.AUTO;
        FrameFlusher frameFlusher = this;
        synchronized (frameFlusher) {
            if (this.closed) {
                return IteratingCallback.Action.SUCCEEDED;
            }
            if (this.terminated != null) {
                throw this.terminated;
            }
            while (!this.queue.isEmpty() && this.entries.size() < this.maxGather) {
                int payloadLength;
                int approxFrameLength;
                FrameEntry entry = this.queue.poll();
                currentBatchMode = BatchMode.max(currentBatchMode, entry.batchMode);
                this.messagesOut.increment();
                if (entry.frame == FLUSH_FRAME) {
                    currentBatchMode = BatchMode.OFF;
                }
                if ((approxFrameLength = 28 + (payloadLength = BufferUtil.length(entry.frame.getPayload()))) > this.bufferSize >> 2) {
                    currentBatchMode = BatchMode.OFF;
                }
                if ((space -= approxFrameLength) <= 0) {
                    currentBatchMode = BatchMode.OFF;
                }
                this.entries.add(entry);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} processing {} entries: {}", this, this.entries.size(), this.entries);
        }
        if (this.entries.isEmpty()) {
            if (this.batchMode != BatchMode.AUTO) {
                this.releaseAggregate();
                return IteratingCallback.Action.IDLE;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} auto flushing", this);
            }
            return this.flush();
        }
        this.batchMode = currentBatchMode;
        return currentBatchMode == BatchMode.OFF ? this.flush() : this.batch();
    }

    private IteratingCallback.Action batch() {
        if (this.aggregate == null) {
            this.aggregate = this.bufferPool.acquire(this.bufferSize, true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} acquired aggregate buffer {}", this, this.aggregate);
            }
        }
        for (FrameEntry entry : this.entries) {
            entry.generateHeaderBytes(this.aggregate);
            ByteBuffer payload = entry.frame.getPayload();
            if (!BufferUtil.hasContent(payload)) continue;
            BufferUtil.append(this.aggregate, payload);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} aggregated {} frames: {}", this, this.entries.size(), this.entries);
        }
        this.succeeded();
        return IteratingCallback.Action.SCHEDULED;
    }

    private IteratingCallback.Action flush() {
        if (!BufferUtil.isEmpty(this.aggregate)) {
            this.buffers.add(this.aggregate);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} flushing aggregate {}", this, this.aggregate);
            }
        }
        for (FrameEntry entry : this.entries) {
            if (entry.frame == FLUSH_FRAME) continue;
            this.buffers.add(entry.generateHeaderBytes());
            ByteBuffer payload = entry.frame.getPayload();
            if (!BufferUtil.hasContent(payload)) continue;
            this.buffers.add(payload);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} flushing {} frames: {}", this, this.entries.size(), this.entries);
        }
        if (this.buffers.isEmpty()) {
            this.releaseAggregate();
            this.succeedEntries();
            return IteratingCallback.Action.IDLE;
        }
        int i = 0;
        int bytes = 0;
        ByteBuffer[] bufferArray = new ByteBuffer[this.buffers.size()];
        for (ByteBuffer bb : this.buffers) {
            bytes += bb.limit() - bb.position();
            bufferArray[i++] = bb;
        }
        this.bytesOut.add(bytes);
        this.endPoint.write(this, this.buffers.toArray(new ByteBuffer[this.buffers.size()]));
        this.buffers.clear();
        return IteratingCallback.Action.SCHEDULED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getQueueSize() {
        FrameFlusher frameFlusher = this;
        synchronized (frameFlusher) {
            return this.queue.size();
        }
    }

    @Override
    public void succeeded() {
        this.succeedEntries();
        super.succeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void succeedEntries() {
        for (FrameEntry entry : this.entries) {
            this.notifyCallbackSuccess(entry.callback);
            entry.release();
            if (entry.frame.getOpCode() != 8) continue;
            FrameFlusher frameFlusher = this;
            synchronized (frameFlusher) {
                this.closed = true;
            }
            this.endPoint.shutdownOutput();
        }
        this.entries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleteFailure(Throwable failure) {
        this.releaseAggregate();
        FrameFlusher frameFlusher = this;
        synchronized (frameFlusher) {
            if (this.terminated == null) {
                this.terminated = failure;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Write flush failure", failure);
                }
            }
            this.entries.addAll(this.queue);
            this.queue.clear();
        }
        for (FrameEntry entry : this.entries) {
            this.notifyCallbackFailure(entry.callback, failure);
            entry.release();
        }
        this.entries.clear();
    }

    private void releaseAggregate() {
        if (BufferUtil.isEmpty(this.aggregate)) {
            this.bufferPool.release(this.aggregate);
            this.aggregate = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate(Throwable cause) {
        Throwable reason;
        FrameFlusher frameFlusher = this;
        synchronized (frameFlusher) {
            reason = this.terminated;
            if (reason == null) {
                this.terminated = cause;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {}", reason == null ? "Terminating" : "Terminated", this);
        }
        if (reason == null) {
            this.iterate();
        }
    }

    protected void notifyCallbackSuccess(WriteCallback callback) {
        block3: {
            try {
                if (callback != null) {
                    callback.writeSuccess();
                }
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying success of callback " + callback, x);
            }
        }
    }

    protected void notifyCallbackFailure(WriteCallback callback, Throwable failure) {
        block3: {
            try {
                if (callback != null) {
                    callback.writeFailed(failure);
                }
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying failure of callback " + callback, x);
            }
        }
    }

    public long getMessagesOut() {
        return this.messagesOut.longValue();
    }

    public long getBytesOut() {
        return this.bytesOut.longValue();
    }

    @Override
    public String toString() {
        int aggSize = -1;
        ByteBuffer agg = this.aggregate;
        if (agg != null) {
            aggSize = agg.position();
        }
        return String.format("%s[queueSize=%d,aggregateSize=%d,terminated=%s]", super.toString(), this.getQueueSize(), aggSize, this.terminated);
    }

    private class FrameEntry {
        private final Frame frame;
        private final WriteCallback callback;
        private final BatchMode batchMode;
        private ByteBuffer headerBuffer;

        private FrameEntry(Frame frame, WriteCallback callback, BatchMode batchMode) {
            this.frame = Objects.requireNonNull(frame);
            this.callback = callback;
            this.batchMode = batchMode;
        }

        private ByteBuffer generateHeaderBytes() {
            this.headerBuffer = FrameFlusher.this.generator.generateHeaderBytes(this.frame);
            return this.headerBuffer;
        }

        private void generateHeaderBytes(ByteBuffer buffer) {
            FrameFlusher.this.generator.generateHeaderBytes(this.frame, buffer);
        }

        private void release() {
            if (this.headerBuffer != null) {
                FrameFlusher.this.generator.getBufferPool().release(this.headerBuffer);
                this.headerBuffer = null;
            }
        }

        public String toString() {
            return String.format("%s[%s,%s,%s,%s]", new Object[]{this.getClass().getSimpleName(), this.frame, this.callback, this.batchMode, FrameFlusher.this.terminated});
        }
    }
}

