/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractLogic<T extends EntityTO> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractLogic.class);

    public T resolveBeanReference(Method method, Object ... args) throws UnresolvedReferenceException {
        Transactional transactional = method.getAnnotation(Transactional.class);
        if (transactional != null && transactional.readOnly()) {
            throw new UnresolvedReferenceException();
        }
        return this.resolveReference(method, args);
    }

    protected abstract T resolveReference(Method var1, Object ... var2) throws UnresolvedReferenceException;
}

