/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.layout;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.layout.col.LargeScreenSpanType;
import de.agilecoders.wicket.core.markup.html.bootstrap.layout.col.SpanType;
import de.agilecoders.wicket.core.markup.html.bootstrap.layout.offset.LargeOffsetType;
import de.agilecoders.wicket.core.markup.html.bootstrap.layout.offset.OffsetType;
import de.agilecoders.wicket.core.markup.html.bootstrap.layout.order.LargeOrderType;
import de.agilecoders.wicket.core.markup.html.bootstrap.layout.order.OrderType;
import de.agilecoders.wicket.core.util.Attributes;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.util.lang.Args;

public class SpanBehavior
extends BootstrapBaseBehavior {
    private static final long serialVersionUID = 1L;
    private final SpanType type;
    private final OffsetType offsetType;
    private final OrderType orderType;

    public SpanBehavior() {
        this(LargeScreenSpanType.SPAN12);
    }

    public SpanBehavior(SpanType spanType) {
        this(spanType, LargeOffsetType.OFFSET0, LargeOrderType.ORDER0);
    }

    public SpanBehavior(SpanType spanType, OffsetType offsetType) {
        this(spanType, offsetType, LargeOrderType.ORDER0);
    }

    public SpanBehavior(SpanType spanType, OrderType orderType) {
        this(spanType, LargeOffsetType.OFFSET0, orderType);
    }

    public SpanBehavior(SpanType spanType, OffsetType offsetType, OrderType orderType) {
        Args.notNull((Object)spanType, (String)"spanType");
        Args.notNull((Object)offsetType, (String)"offsetType");
        Args.notNull((Object)orderType, (String)"orderType");
        this.type = spanType;
        this.offsetType = offsetType;
        this.orderType = orderType;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.addClass(tag, this.type.cssClassName(), this.offsetType.cssClassName(), this.orderType.cssClassName());
    }
}

