/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.components.progress;

import de.agilecoders.wicket.core.markup.html.bootstrap.utilities.BackgroundColorBehavior;
import de.agilecoders.wicket.core.util.Attributes;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;

public class Stack
extends GenericPanel<Integer> {
    private static final long serialVersionUID = 1L;
    private Label visuallyHidden;
    private BackgroundColorBehavior backgroundColorBehavior = BackgroundColorBehavior.secondary();
    private boolean labeled = false;
    private boolean animated = false;
    private boolean striped = false;

    public Stack(String id, IModel<Integer> model) {
        super(id, model);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.visuallyHidden = new Label("visuallyHidden", this.createLabelModel());
        this.visuallyHidden.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"visually-hidden"))});
        this.add(new Component[]{this.visuallyHidden});
    }

    public BackgroundColorBehavior.Color color() {
        return this.backgroundColorBehavior.getColor();
    }

    public Stack color(BackgroundColorBehavior.Color color) {
        this.backgroundColorBehavior.color(color);
        return this;
    }

    public boolean labeled() {
        return this.labeled;
    }

    public Stack labeled(boolean labeled) {
        this.labeled = labeled;
        return this;
    }

    public boolean striped() {
        return this.striped;
    }

    public Stack striped(boolean value) {
        this.striped = value;
        return this;
    }

    public boolean active() {
        return this.animated;
    }

    public Stack active(boolean value) {
        this.animated = value;
        if (value) {
            this.striped(true);
        }
        return this;
    }

    protected void onConfigure() {
        super.onConfigure();
        if (this.labeled()) {
            this.visuallyHidden.setRenderBodyOnly(true);
        }
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Integer value = (Integer)this.getModelObject();
        Attributes.set(tag, "aria-valuenow", String.valueOf(value));
        Attributes.set(tag, "aria-valuemin", String.valueOf(0));
        Attributes.set(tag, "aria-valuemax", String.valueOf(100));
        if (this.animated) {
            Attributes.addClass(tag, "progress-bar-active");
        }
        if (this.striped) {
            Attributes.addClass(tag, "progress-bar-striped");
        }
        Attributes.addClass(tag, this.color().cssClassName());
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)("Wicket.WUPB.prototype.setPercent(" + this.getDefaultModelObject() + ", '" + this.getMarkupId(true) + "');")));
    }

    protected IModel<String> createLabelModel() {
        return (IModel & Serializable)() -> String.format("%s%%", this.getModelObject());
    }
}

