/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.nio.charset.StandardCharsets;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005U2A\u0001C\u0005\u0001\u001d!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00015!)1\u0006\u0001C\u00015!)Q\u0006\u0001C\u00015!)q\u0006\u0001C\u00015!)\u0011\u0007\u0001C\u00015!)1\u0007\u0001C\u00015\t\u0001b)Z1ukJ,'LT8eKR+7\u000f\u001e\u0006\u0003\u0015-\t!A_6\u000b\u00031\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001fA\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"A\u0005\u0002!Q,7\u000f^#oG>$W\rR3d_\u0012,G#A\u000e\u0011\u0005Aa\u0012BA\u000f\u0012\u0005\u0011)f.\u001b;)\u0005\ty\u0002C\u0001\u0011*\u001b\u0005\t#B\u0001\u0012$\u0003\r\t\u0007/\u001b\u0006\u0003I\u0015\nqA[;qSR,'O\u0003\u0002'O\u0005)!.\u001e8ji*\t\u0001&A\u0002pe\u001eL!AK\u0011\u0003\tQ+7\u000f^\u0001\u0014i\u0016\u001cH\u000fR3d_\u0012,7+^2dKN\u001ch+\r\u0015\u0003\u0007}\t1\u0003^3ti\u0012+7m\u001c3f'V\u001c7-Z:t-JB#\u0001B\u0010\u0002OQ,7\u000f\u001e#fG>$WMR1jY>s\u0017J\u001c<bY&$g+\u001a:tS>t\u0017I\u001c3Ti\u0006$Xo\u001d\u0015\u0003\u000b}\t\u0011\u0005^3ti\u0012+7m\u001c3f\r\u0006LGn\u00148J]Z\fG.\u001b3GK\u0006$XO]3t-FB#AB\u0010\u0002CQ,7\u000f\u001e#fG>$WMR1jY>s\u0017J\u001c<bY&$g)Z1ukJ,7O\u0016\u001a)\u0005\u001dy\u0002")
public class FeatureZNodeTest {
    @Test
    public void testEncodeDecode() {
        FeatureZNode featureZNodeV1 = FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature1"), (Object)BoxesRunTime.boxToShort((short)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature2"), (Object)BoxesRunTime.boxToShort((short)4))})));
        FeatureZNode decodedV1 = FeatureZNode$.MODULE$.decode(FeatureZNode$.MODULE$.encode(featureZNodeV1));
        Assertions.assertEquals((Object)featureZNodeV1, (Object)decodedV1);
        FeatureZNode featureZNodeV2 = FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_3_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature1"), (Object)BoxesRunTime.boxToShort((short)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature2"), (Object)BoxesRunTime.boxToShort((short)4))})));
        FeatureZNode decodedV2 = FeatureZNode$.MODULE$.decode(FeatureZNode$.MODULE$.encode(featureZNodeV2));
        Assertions.assertEquals((Object)featureZNodeV2, (Object)decodedV2);
    }

    @Test
    public void testDecodeSuccessV1() {
        String featureZNodeStrTemplate = "{\n      \"version\":1,\n      \"status\":1,\n      \"features\":%s\n    }";
        String validFeatures = "{\"feature1\": {\"min_version_level\": 1, \"max_version_level\": 2}, \"feature2\": {\"min_version_level\": 2, \"max_version_level\": 4}}";
        FeatureZNode node1 = FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{validFeatures})).getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)FeatureZNodeStatus.Enabled$.MODULE$, (Object)node1.status());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature1"), (Object)BoxesRunTime.boxToShort((short)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature2"), (Object)BoxesRunTime.boxToShort((short)4))})), (Object)node1.features());
        String emptyFeatures = "{}";
        FeatureZNode node2 = FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{emptyFeatures})).getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)FeatureZNodeStatus.Enabled$.MODULE$, (Object)node2.status());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)node2.features());
    }

    @Test
    public void testDecodeSuccessV2() {
        String featureZNodeStrTemplate = "{\n      \"version\":2,\n      \"status\":1,\n      \"features\":%s\n    }";
        String validFeatures = "{\"feature1\": {\"max_version_level\": 2}, \"feature2\": {\"max_version_level\": 4}}";
        FeatureZNode node1 = FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{validFeatures})).getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)FeatureZNodeStatus.Enabled$.MODULE$, (Object)node1.status());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature1"), (Object)BoxesRunTime.boxToShort((short)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature2"), (Object)BoxesRunTime.boxToShort((short)4))})), (Object)node1.features());
        String emptyFeatures = "{}";
        FeatureZNode node2 = FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{emptyFeatures})).getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)FeatureZNodeStatus.Enabled$.MODULE$, (Object)node2.status());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)node2.features());
    }

    @Test
    public void testDecodeFailOnInvalidVersionAndStatus() {
        String featureZNodeStrTemplate = "{\n      \"version\":%d,\n      \"status\":%d,\n      \"features\":{\"feature1\": {\"min_version_level\": 1, \"max_version_level\": 2}, \"feature2\": {\"min_version_level\": 2, \"max_version_level\": 4}}\n    }";
        Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(FeatureZNode$.MODULE$.V1() - 1)), BoxesRunTime.boxToInteger((int)1)})).getBytes(StandardCharsets.UTF_8)));
        int invalidStatus = FeatureZNodeStatus.Enabled$.MODULE$.id() + 1;
        Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)FeatureZNode$.MODULE$.V2()), BoxesRunTime.boxToInteger((int)invalidStatus)})).getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    public void testDecodeFailOnInvalidFeaturesV1() {
        String featureZNodeStrTemplate = "{\n      \"version\":1,\n      \"status\":1%s\n    }";
        String missingFeatures = "";
        Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{missingFeatures})).getBytes(StandardCharsets.UTF_8)));
        String malformedFeatures = ",\"features\":{\"feature1\": {\"min_version_level\": 1, \"max_version_level\": 2}, \"partial\"}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{malformedFeatures})).getBytes(StandardCharsets.UTF_8)));
        String invalidFeaturesMinVersionLevel = ",\"features\":{\"feature1\": {\"min_version_level\": 0, \"max_version_level\": 2}}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{invalidFeaturesMinVersionLevel})).getBytes(StandardCharsets.UTF_8)));
        String invalidFeaturesMaxVersionLevel = ",\"features\":{\"feature1\": {\"min_version_level\": 2, \"max_version_level\": 1}}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{invalidFeaturesMaxVersionLevel})).getBytes(StandardCharsets.UTF_8)));
        String invalidFeaturesMissingMinVersionLevel = ",\"features\":{\"feature1\": {\"max_version_level\": 1}}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{invalidFeaturesMissingMinVersionLevel})).getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    public void testDecodeFailOnInvalidFeaturesV2() {
        String featureZNodeStrTemplate = "{\n      \"version\":2,\n      \"status\":1%s\n    }";
        String missingFeatures = "";
        Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{missingFeatures})).getBytes(StandardCharsets.UTF_8)));
        String malformedFeatures = ",\"features\":{\"feature1\": {\"min_version_level\": 1, \"max_version_level\": 2}, \"partial\"}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{malformedFeatures})).getBytes(StandardCharsets.UTF_8)));
        String invalidFeaturesMinVersionLevel = ",\"features\":{\"feature1\": {\"min_version_level\": 0, \"max_version_level\": 2}}";
        Assertions.assertDoesNotThrow(() -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{invalidFeaturesMinVersionLevel})).getBytes(StandardCharsets.UTF_8)));
        String invalidFeaturesMaxVersionLevel = ",\"features\":{\"feature1\": {\"min_version_level\": 2, \"max_version_level\": 1}}";
        Assertions.assertDoesNotThrow(() -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{invalidFeaturesMaxVersionLevel})).getBytes(StandardCharsets.UTF_8)));
        String invalidFeaturesMissingMinVersionLevel = ",\"features\":{\"feature1\": {\"max_version_level\": 1}}";
        Assertions.assertDoesNotThrow(() -> FeatureZNode$.MODULE$.decode(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(featureZNodeStrTemplate), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{invalidFeaturesMissingMinVersionLevel})).getBytes(StandardCharsets.UTF_8)));
    }
}

