/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.query.CacheAwareQuery;
import org.flowable.common.engine.impl.db.SuspensionState;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.engine.impl.ExecutionQueryProperty;
import org.flowable.engine.impl.IdentityLinkQueryObject;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ExecutionQuery;
import org.flowable.eventsubscription.service.impl.EventSubscriptionQueryValue;
import org.flowable.variable.service.impl.AbstractVariableQueryImpl;

public class ExecutionQueryImpl
extends AbstractVariableQueryImpl<ExecutionQuery, Execution>
implements ExecutionQuery,
CacheAwareQuery<ExecutionEntity> {
    private static final long serialVersionUID = 1L;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processDefinitionKeyLike;
    protected String processDefinitionKeyLikeIgnoreCase;
    protected String processDefinitionCategory;
    protected String processDefinitionCategoryLike;
    protected String processDefinitionCategoryLikeIgnoreCase;
    protected String processDefinitionName;
    protected String processDefinitionNameLike;
    protected String processDefinitionNameLikeIgnoreCase;
    protected Integer processDefinitionVersion;
    protected String processDefinitionEngineVersion;
    protected String activityId;
    protected String executionId;
    protected String parentId;
    protected boolean onlyChildExecutions;
    protected boolean onlySubProcessExecutions;
    protected boolean onlyProcessInstanceExecutions;
    protected String processInstanceId;
    protected String rootProcessInstanceId;
    protected List<EventSubscriptionQueryValue> eventSubscriptions;
    protected String tenantId;
    protected String tenantIdLike;
    protected String tenantIdLikeIgnoreCase;
    protected boolean withoutTenantId;
    protected String locale;
    protected boolean withLocalizationFallback;
    protected Date startedBefore;
    protected Date startedAfter;
    protected String startedBy;
    protected String superProcessInstanceId;
    protected String subProcessInstanceId;
    protected boolean excludeSubprocesses;
    protected SuspensionState suspensionState;
    protected String businessKey;
    protected String businessKeyLike;
    protected String businessKeyLikeIgnoreCase;
    protected boolean includeChildExecutionsWithBusinessKeyQuery;
    protected boolean isActive;
    protected String involvedUser;
    protected Set<String> involvedGroups;
    private List<List<String>> safeInvolvedGroups;
    protected Set<String> processDefinitionKeys;
    protected Set<String> excludeProcessDefinitionKeys;
    protected Set<String> processDefinitionIds;
    protected String name;
    protected String nameLike;
    protected String nameLikeIgnoreCase;
    protected String deploymentId;
    protected List<String> deploymentIds;
    protected String activeActivityId;
    protected Set<String> activeActivityIds;
    protected String callbackId;
    protected String callbackType;
    protected String parentCaseInstanceId;
    protected String referenceId;
    protected String referenceType;
    protected List<ExecutionQueryImpl> orQueryObjects = new ArrayList<ExecutionQueryImpl>();
    protected ExecutionQueryImpl currentOrQueryObject;
    protected boolean inOrStatement;

    public ExecutionQueryImpl() {
    }

    public ExecutionQueryImpl(CommandContext commandContext, ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(commandContext, processEngineConfiguration.getVariableServiceConfiguration());
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public ExecutionQueryImpl(CommandExecutor commandExecutor, ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(commandExecutor, processEngineConfiguration.getVariableServiceConfiguration());
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public boolean isProcessInstancesOnly() {
        return false;
    }

    @Override
    public ExecutionQueryImpl processDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Process definition id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionId = processDefinitionId;
        } else {
            this.processDefinitionId = processDefinitionId;
        }
        return this;
    }

    @Override
    public ExecutionQueryImpl processDefinitionKey(String processDefinitionKey) {
        if (processDefinitionKey == null) {
            throw new FlowableIllegalArgumentException("Process definition key is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionKey = processDefinitionKey;
        } else {
            this.processDefinitionKey = processDefinitionKey;
        }
        return this;
    }

    @Override
    public ExecutionQueryImpl processDefinitionKeyLike(String processDefinitionKeyLike) {
        if (processDefinitionKeyLike == null) {
            throw new FlowableIllegalArgumentException("Process definition key is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionKeyLike = processDefinitionKeyLike;
        } else {
            this.processDefinitionKeyLike = processDefinitionKeyLike;
        }
        return this;
    }

    @Override
    public ExecutionQueryImpl processDefinitionKeyLikeIgnoreCase(String processDefinitionKeyLikeIgnoreCase) {
        if (processDefinitionKeyLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("Process definition key is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionKeyLikeIgnoreCase = processDefinitionKeyLikeIgnoreCase;
        } else {
            this.processDefinitionKeyLikeIgnoreCase = processDefinitionKeyLikeIgnoreCase;
        }
        return this;
    }

    @Override
    public ExecutionQuery processDefinitionCategory(String processDefinitionCategory) {
        if (processDefinitionCategory == null) {
            throw new FlowableIllegalArgumentException("Process definition category is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionCategory = processDefinitionCategory;
        } else {
            this.processDefinitionCategory = processDefinitionCategory;
        }
        return this;
    }

    @Override
    public ExecutionQuery processDefinitionCategoryLike(String processDefinitionCategoryLike) {
        if (processDefinitionCategoryLike == null) {
            throw new FlowableIllegalArgumentException("Process definition category is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionCategoryLike = processDefinitionCategoryLike;
        } else {
            this.processDefinitionCategoryLike = processDefinitionCategoryLike;
        }
        return this;
    }

    @Override
    public ExecutionQuery processDefinitionCategoryLikeIgnoreCase(String processDefinitionCategoryLikeIgnoreCase) {
        if (processDefinitionCategoryLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("Process definition category is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionCategoryLikeIgnoreCase = processDefinitionCategoryLikeIgnoreCase;
        } else {
            this.processDefinitionCategoryLikeIgnoreCase = processDefinitionCategoryLikeIgnoreCase;
        }
        return this;
    }

    @Override
    public ExecutionQuery processDefinitionName(String processDefinitionName) {
        if (processDefinitionName == null) {
            throw new FlowableIllegalArgumentException("Process definition name is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionName = processDefinitionName;
        } else {
            this.processDefinitionName = processDefinitionName;
        }
        return this;
    }

    @Override
    public ExecutionQuery processDefinitionNameLike(String processDefinitionNameLike) {
        if (processDefinitionNameLike == null) {
            throw new FlowableIllegalArgumentException("Process definition name is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionNameLike = processDefinitionNameLike;
        } else {
            this.processDefinitionNameLike = processDefinitionNameLike;
        }
        return this;
    }

    @Override
    public ExecutionQuery processDefinitionNameLikeIgnoreCase(String processDefinitionNameLikeIgnoreCase) {
        if (processDefinitionNameLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("Process definition name is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionNameLikeIgnoreCase = processDefinitionNameLikeIgnoreCase;
        } else {
            this.processDefinitionNameLikeIgnoreCase = processDefinitionNameLikeIgnoreCase;
        }
        return this;
    }

    @Override
    public ExecutionQuery processDefinitionVersion(Integer processDefinitionVersion) {
        if (processDefinitionVersion == null) {
            throw new FlowableIllegalArgumentException("Process definition version is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionVersion = processDefinitionVersion;
        } else {
            this.processDefinitionVersion = processDefinitionVersion;
        }
        return this;
    }

    @Override
    public ExecutionQuery processDefinitionEngineVersion(String processDefinitionEngineVersion) {
        if (processDefinitionEngineVersion == null) {
            throw new FlowableIllegalArgumentException("Process definition engine version is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionEngineVersion = processDefinitionEngineVersion;
        } else {
            this.processDefinitionEngineVersion = processDefinitionEngineVersion;
        }
        return this;
    }

    @Override
    public ExecutionQueryImpl processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new FlowableIllegalArgumentException("Process instance id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processInstanceId = processInstanceId;
        } else {
            this.processInstanceId = processInstanceId;
        }
        return this;
    }

    @Override
    public ExecutionQueryImpl rootProcessInstanceId(String rootProcessInstanceId) {
        if (rootProcessInstanceId == null) {
            throw new FlowableIllegalArgumentException("Root process instance id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.rootProcessInstanceId = rootProcessInstanceId;
        } else {
            this.rootProcessInstanceId = rootProcessInstanceId;
        }
        return this;
    }

    @Override
    public ExecutionQuery processInstanceBusinessKey(String businessKey) {
        if (businessKey == null) {
            throw new FlowableIllegalArgumentException("Business key is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.businessKey = businessKey;
        } else {
            this.businessKey = businessKey;
        }
        return this;
    }

    @Override
    public ExecutionQuery processInstanceBusinessKey(String processInstanceBusinessKey, boolean includeChildExecutions) {
        if (!includeChildExecutions) {
            return this.processInstanceBusinessKey(processInstanceBusinessKey);
        }
        if (processInstanceBusinessKey == null) {
            throw new FlowableIllegalArgumentException("Business key is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.businessKey = processInstanceBusinessKey;
            this.currentOrQueryObject.includeChildExecutionsWithBusinessKeyQuery = includeChildExecutions;
        } else {
            this.businessKey = processInstanceBusinessKey;
            this.includeChildExecutionsWithBusinessKeyQuery = includeChildExecutions;
        }
        return this;
    }

    @Override
    public ExecutionQuery processInstanceBusinessKeyLike(String businessKeyLike) {
        if (businessKeyLike == null) {
            throw new FlowableIllegalArgumentException("Business key is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.businessKeyLike = businessKeyLike;
        } else {
            this.businessKeyLike = businessKeyLike;
        }
        return this;
    }

    @Override
    public ExecutionQuery processInstanceBusinessKeyLike(String processInstanceBusinessKeyLike, boolean includeChildExecutions) {
        if (!includeChildExecutions) {
            return this.processInstanceBusinessKeyLike(processInstanceBusinessKeyLike);
        }
        if (processInstanceBusinessKeyLike == null) {
            throw new FlowableIllegalArgumentException("Business key is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.businessKeyLike = processInstanceBusinessKeyLike;
            this.currentOrQueryObject.includeChildExecutionsWithBusinessKeyQuery = includeChildExecutions;
        } else {
            this.businessKeyLike = processInstanceBusinessKeyLike;
            this.includeChildExecutionsWithBusinessKeyQuery = includeChildExecutions;
        }
        return this;
    }

    @Override
    public ExecutionQuery processInstanceBusinessKeyLikeIgnoreCase(String businessKeyLikeIgnoreCase) {
        if (businessKeyLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("Business key is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.businessKeyLikeIgnoreCase = businessKeyLikeIgnoreCase;
        } else {
            this.businessKeyLikeIgnoreCase = businessKeyLikeIgnoreCase;
        }
        return this;
    }

    @Override
    public ExecutionQuery processInstanceBusinessKeyLikeIgnoreCase(String processInstanceBusinessKeyLikeIgnoreCase, boolean includeChildExecutions) {
        if (!includeChildExecutions) {
            return this.processInstanceBusinessKeyLikeIgnoreCase(processInstanceBusinessKeyLikeIgnoreCase);
        }
        if (processInstanceBusinessKeyLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("Business key is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.businessKeyLikeIgnoreCase = processInstanceBusinessKeyLikeIgnoreCase;
            this.currentOrQueryObject.includeChildExecutionsWithBusinessKeyQuery = includeChildExecutions;
        } else {
            this.businessKeyLikeIgnoreCase = processInstanceBusinessKeyLikeIgnoreCase;
            this.includeChildExecutionsWithBusinessKeyQuery = includeChildExecutions;
        }
        return this;
    }

    @Override
    public ExecutionQuery processDefinitionKeys(Set<String> processDefinitionKeys) {
        if (processDefinitionKeys == null) {
            throw new FlowableIllegalArgumentException("Process definition keys is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionKeys = processDefinitionKeys;
        } else {
            this.processDefinitionKeys = processDefinitionKeys;
        }
        return this;
    }

    @Override
    public ExecutionQuery excludeProcessDefinitionKeys(Set<String> excludeProcessDefinitionKeys) {
        if (excludeProcessDefinitionKeys == null) {
            throw new FlowableIllegalArgumentException("Process definition keys is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.excludeProcessDefinitionKeys = excludeProcessDefinitionKeys;
        } else {
            this.excludeProcessDefinitionKeys = excludeProcessDefinitionKeys;
        }
        return this;
    }

    @Override
    public ExecutionQueryImpl executionId(String executionId) {
        if (executionId == null) {
            throw new FlowableIllegalArgumentException("Execution id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.executionId = executionId;
        } else {
            this.executionId = executionId;
        }
        return this;
    }

    @Override
    public ExecutionQueryImpl activityId(String activityId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.activityId = activityId;
            if (activityId != null) {
                this.currentOrQueryObject.isActive = true;
            }
        } else {
            this.activityId = activityId;
            if (activityId != null) {
                this.isActive = true;
            }
        }
        return this;
    }

    @Override
    public ExecutionQueryImpl parentId(String parentId) {
        if (parentId == null) {
            throw new FlowableIllegalArgumentException("Parent id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.parentId = parentId;
        } else {
            this.parentId = parentId;
        }
        return this;
    }

    @Override
    public ExecutionQuery onlyChildExecutions() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.onlyChildExecutions = true;
        } else {
            this.onlyChildExecutions = true;
        }
        return this;
    }

    @Override
    public ExecutionQuery onlySubProcessExecutions() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.onlySubProcessExecutions = true;
        } else {
            this.onlySubProcessExecutions = true;
        }
        return this;
    }

    @Override
    public ExecutionQuery onlyProcessInstanceExecutions() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.onlyProcessInstanceExecutions = true;
        } else {
            this.onlyProcessInstanceExecutions = true;
        }
        return this;
    }

    @Override
    public ExecutionQueryImpl executionTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("execution tenant id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.tenantId = tenantId;
        } else {
            this.tenantId = tenantId;
        }
        return this;
    }

    @Override
    public ExecutionQueryImpl executionTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("execution tenant id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.tenantIdLike = tenantIdLike;
        } else {
            this.tenantIdLike = tenantIdLike;
        }
        return this;
    }

    @Override
    public ExecutionQueryImpl executionTenantIdLikeIgnoreCase(String tenantIdLikeIgnoreCase) {
        if (tenantIdLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("execution tenant id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.tenantIdLikeIgnoreCase = tenantIdLikeIgnoreCase;
        } else {
            this.tenantIdLikeIgnoreCase = tenantIdLikeIgnoreCase;
        }
        return this;
    }

    @Override
    public ExecutionQueryImpl executionWithoutTenantId() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withoutTenantId = true;
        } else {
            this.withoutTenantId = true;
        }
        return this;
    }

    @Override
    public ExecutionQuery executionReferenceId(String referenceId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.referenceId = referenceId;
        } else {
            this.referenceId = referenceId;
        }
        return this;
    }

    @Override
    public ExecutionQuery executionReferenceType(String referenceType) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.referenceType = referenceType;
        } else {
            this.referenceType = referenceType;
        }
        return this;
    }

    public ExecutionQuery signalEventSubscription(String signalName) {
        return this.eventSubscription("signal", signalName);
    }

    @Override
    public ExecutionQuery signalEventSubscriptionName(String signalName) {
        return this.eventSubscription("signal", signalName);
    }

    @Override
    public ExecutionQuery messageEventSubscriptionName(String messageName) {
        return this.eventSubscription("message", messageName);
    }

    public ExecutionQuery eventSubscription(String eventType, String eventName) {
        if (eventName == null) {
            throw new FlowableIllegalArgumentException("event name is null");
        }
        if (eventType == null) {
            throw new FlowableIllegalArgumentException("event type is null");
        }
        if (this.inOrStatement) {
            if (this.currentOrQueryObject.eventSubscriptions == null) {
                this.currentOrQueryObject.eventSubscriptions = new ArrayList<EventSubscriptionQueryValue>();
            }
            this.currentOrQueryObject.eventSubscriptions.add(new EventSubscriptionQueryValue(eventName, eventType));
        } else {
            if (this.eventSubscriptions == null) {
                this.eventSubscriptions = new ArrayList<EventSubscriptionQueryValue>();
            }
            this.eventSubscriptions.add(new EventSubscriptionQueryValue(eventName, eventType));
        }
        return this;
    }

    @Override
    public ExecutionQuery processVariableValueEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(variableName, variableValue, false);
            return this;
        }
        return (ExecutionQuery)this.variableValueEquals(variableName, variableValue, false);
    }

    @Override
    public ExecutionQuery processVariableValueEquals(Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(variableValue, false);
            return this;
        }
        return (ExecutionQuery)this.variableValueEquals(variableValue, false);
    }

    @Override
    public ExecutionQuery processVariableValueNotEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEquals(variableName, variableValue, false);
            return this;
        }
        return (ExecutionQuery)this.variableValueNotEquals(variableName, variableValue, false);
    }

    @Override
    public ExecutionQuery processVariableValueEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEqualsIgnoreCase(name, value, false);
            return this;
        }
        return (ExecutionQuery)this.variableValueEqualsIgnoreCase(name, value, false);
    }

    @Override
    public ExecutionQuery processVariableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEqualsIgnoreCase(name, value, false);
            return this;
        }
        return (ExecutionQuery)this.variableValueNotEqualsIgnoreCase(name, value, false);
    }

    @Override
    public ExecutionQuery processVariableValueLike(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLike(name, value, false);
            return this;
        }
        return (ExecutionQuery)this.variableValueLike(name, value, false);
    }

    @Override
    public ExecutionQuery processVariableValueLikeIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLikeIgnoreCase(name, value, false);
            return this;
        }
        return (ExecutionQuery)this.variableValueLikeIgnoreCase(name, value, false);
    }

    @Override
    public ExecutionQuery processVariableValueGreaterThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThan(name, value, false);
        } else {
            this.variableValueGreaterThan(name, value, false);
        }
        return this;
    }

    @Override
    public ExecutionQuery processVariableValueGreaterThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThanOrEqual(name, value, false);
        } else {
            this.variableValueGreaterThanOrEqual(name, value, false);
        }
        return this;
    }

    @Override
    public ExecutionQuery processVariableValueLessThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThan(name, value, false);
        } else {
            this.variableValueLessThan(name, value, false);
        }
        return this;
    }

    @Override
    public ExecutionQuery processVariableValueLessThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThanOrEqual(name, value, false);
        } else {
            this.variableValueLessThanOrEqual(name, value, false);
        }
        return this;
    }

    @Override
    public ExecutionQuery processVariableExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableExists(name, false);
            return this;
        }
        return (ExecutionQuery)this.variableExists(name, false);
    }

    @Override
    public ExecutionQuery processVariableNotExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableNotExists(name, false);
            return this;
        }
        return (ExecutionQuery)this.variableNotExists(name, false);
    }

    @Override
    public ExecutionQuery variableValueEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(variableName, variableValue, true);
            return this;
        }
        return (ExecutionQuery)this.variableValueEquals(variableName, variableValue, true);
    }

    @Override
    public ExecutionQuery variableValueEquals(Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(variableValue, true);
            return this;
        }
        return (ExecutionQuery)this.variableValueEquals(variableValue, true);
    }

    @Override
    public ExecutionQuery variableValueNotEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEquals(variableName, variableValue, true);
            return this;
        }
        return (ExecutionQuery)this.variableValueNotEquals(variableName, variableValue, true);
    }

    @Override
    public ExecutionQuery variableValueEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEqualsIgnoreCase(name, value, true);
            return this;
        }
        return (ExecutionQuery)this.variableValueEqualsIgnoreCase(name, value, true);
    }

    @Override
    public ExecutionQuery variableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEqualsIgnoreCase(name, value, true);
            return this;
        }
        return (ExecutionQuery)this.variableValueNotEqualsIgnoreCase(name, value, true);
    }

    @Override
    public ExecutionQuery variableValueLike(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLike(name, value, true);
            return this;
        }
        return (ExecutionQuery)this.variableValueLike(name, value, true);
    }

    @Override
    public ExecutionQuery variableValueLikeIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLikeIgnoreCase(name, value, true);
            return this;
        }
        return (ExecutionQuery)this.variableValueLikeIgnoreCase(name, value, true);
    }

    @Override
    public ExecutionQuery variableValueGreaterThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThan(name, value, true);
            return this;
        }
        return (ExecutionQuery)this.variableValueGreaterThan(name, value, true);
    }

    @Override
    public ExecutionQuery variableValueGreaterThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThanOrEqual(name, value, true);
            return this;
        }
        return (ExecutionQuery)this.variableValueGreaterThanOrEqual(name, value, true);
    }

    @Override
    public ExecutionQuery variableValueLessThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThan(name, value, true);
            return this;
        }
        return (ExecutionQuery)this.variableValueLessThan(name, value, true);
    }

    @Override
    public ExecutionQuery variableValueLessThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThanOrEqual(name, value, true);
            return this;
        }
        return (ExecutionQuery)this.variableValueLessThanOrEqual(name, value, true);
    }

    @Override
    public ExecutionQuery variableExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableExists(name, true);
            return this;
        }
        return (ExecutionQuery)this.variableExists(name, true);
    }

    @Override
    public ExecutionQuery variableNotExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableNotExists(name, true);
            return this;
        }
        return (ExecutionQuery)this.variableNotExists(name, true);
    }

    @Override
    public ExecutionQuery locale(String locale) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.locale = locale;
        } else {
            this.locale = locale;
        }
        return this;
    }

    @Override
    public ExecutionQuery withLocalizationFallback() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withLocalizationFallback = true;
        } else {
            this.withLocalizationFallback = true;
        }
        return this;
    }

    @Override
    public ExecutionQuery startedBefore(Date beforeTime) {
        if (beforeTime == null) {
            throw new FlowableIllegalArgumentException("before time is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.startedBefore = beforeTime;
        } else {
            this.startedBefore = beforeTime;
        }
        return this;
    }

    @Override
    public ExecutionQuery startedAfter(Date afterTime) {
        if (afterTime == null) {
            throw new FlowableIllegalArgumentException("after time is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.startedAfter = afterTime;
        } else {
            this.startedAfter = afterTime;
        }
        return this;
    }

    @Override
    public ExecutionQuery startedBy(String userId) {
        if (userId == null) {
            throw new FlowableIllegalArgumentException("user id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.startedBy = userId;
        } else {
            this.startedBy = userId;
        }
        return this;
    }

    @Override
    public ExecutionQuery or() {
        if (this.inOrStatement) {
            throw new FlowableException("the query is already in an or statement");
        }
        this.inOrStatement = true;
        this.currentOrQueryObject = this.commandContext != null ? new ExecutionQueryImpl(this.commandContext, this.processEngineConfiguration) : new ExecutionQueryImpl(this.commandExecutor, this.processEngineConfiguration);
        this.orQueryObjects.add(this.currentOrQueryObject);
        return this;
    }

    @Override
    public ExecutionQuery endOr() {
        if (!this.inOrStatement) {
            throw new FlowableException("endOr() can only be called after calling or()");
        }
        this.inOrStatement = false;
        this.currentOrQueryObject = null;
        return this;
    }

    @Override
    public ExecutionQueryImpl orderByProcessInstanceId() {
        this.orderProperty = ExecutionQueryProperty.PROCESS_INSTANCE_ID;
        return this;
    }

    @Override
    public ExecutionQueryImpl orderByProcessDefinitionId() {
        this.orderProperty = ExecutionQueryProperty.PROCESS_DEFINITION_ID;
        return this;
    }

    @Override
    public ExecutionQueryImpl orderByProcessDefinitionKey() {
        this.orderProperty = ExecutionQueryProperty.PROCESS_DEFINITION_KEY;
        return this;
    }

    @Override
    public ExecutionQueryImpl orderByTenantId() {
        this.orderProperty = ExecutionQueryProperty.TENANT_ID;
        return this;
    }

    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        if (this.processEngineConfiguration.getExecutionQueryInterceptor() != null) {
            this.processEngineConfiguration.getExecutionQueryInterceptor().beforeExecutionQueryExecute(this);
        }
        return this.processEngineConfiguration.getExecutionEntityManager().findExecutionCountByQueryCriteria(this);
    }

    public List<Execution> executeList(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        if (this.processEngineConfiguration.getExecutionQueryInterceptor() != null) {
            this.processEngineConfiguration.getExecutionQueryInterceptor().beforeExecutionQueryExecute(this);
        }
        List<Execution> executions = this.processEngineConfiguration.getExecutionEntityManager().findExecutionsByQueryCriteria(this);
        if (this.processEngineConfiguration.getPerformanceSettings().isEnableLocalization()) {
            for (ExecutionEntity executionEntity : executions) {
                String activityId = null;
                if (executionEntity.getId().equals(executionEntity.getProcessInstanceId())) {
                    if (executionEntity.getProcessDefinitionId() != null) {
                        ProcessDefinition processDefinition = this.processEngineConfiguration.getDeploymentManager().findDeployedProcessDefinitionById(executionEntity.getProcessDefinitionId());
                        activityId = processDefinition.getKey();
                    }
                } else {
                    activityId = executionEntity.getActivityId();
                }
                if (activityId == null) continue;
                this.localize(executionEntity, activityId);
            }
        }
        if (this.processEngineConfiguration.getExecutionQueryInterceptor() != null) {
            this.processEngineConfiguration.getExecutionQueryInterceptor().afterExecutionQueryExecute(this, executions);
        }
        return executions;
    }

    protected void localize(Execution execution, String activityId) {
        ObjectNode languageNode;
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        executionEntity.setLocalizedName(null);
        executionEntity.setLocalizedDescription(null);
        String processDefinitionId = executionEntity.getProcessDefinitionId();
        if (this.locale != null && processDefinitionId != null && (languageNode = BpmnOverrideContext.getLocalizationElementProperties(this.locale, activityId, processDefinitionId, this.withLocalizationFallback)) != null) {
            JsonNode languageDescriptionNode;
            JsonNode languageNameNode = languageNode.get("name");
            if (languageNameNode != null && !languageNameNode.isNull()) {
                executionEntity.setLocalizedName(languageNameNode.asText());
            }
            if ((languageDescriptionNode = languageNode.get("description")) != null && !languageDescriptionNode.isNull()) {
                executionEntity.setLocalizedDescription(languageDescriptionNode.asText());
            }
        }
    }

    protected void ensureVariablesInitialized() {
        super.ensureVariablesInitialized();
        for (ExecutionQueryImpl orQueryObject : this.orQueryObjects) {
            orQueryObject.ensureVariablesInitialized();
        }
    }

    public boolean getOnlyProcessInstances() {
        return false;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionKeyLike() {
        return this.processDefinitionKeyLike;
    }

    public String getProcessDefinitionKeyLikeIgnoreCase() {
        return this.processDefinitionKeyLikeIgnoreCase;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionCategory() {
        return this.processDefinitionCategory;
    }

    public String getProcessDefinitionCategoryLike() {
        return this.processDefinitionCategoryLike;
    }

    public String getProcessDefinitionCategoryLikeIgnoreCase() {
        return this.processDefinitionCategoryLikeIgnoreCase;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public String getProcessDefinitionNameLike() {
        return this.processDefinitionNameLike;
    }

    public String getProcessDefinitionNameLikeIgnoreCase() {
        return this.processDefinitionNameLikeIgnoreCase;
    }

    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public String getProcessDefinitionEngineVersion() {
        return this.processDefinitionEngineVersion;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public String getProcessInstanceIds() {
        return null;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getBusinessKeyLike() {
        return this.businessKeyLike;
    }

    public String getBusinessKeyLikeIgnoreCase() {
        return this.businessKeyLikeIgnoreCase;
    }

    public String getBusinessStatus() {
        return null;
    }

    public String getBusinessStatusLike() {
        return null;
    }

    public String getBusinessStatusLikeIgnoreCase() {
        return null;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getId() {
        return this.executionId;
    }

    public String getSuperProcessInstanceId() {
        return this.superProcessInstanceId;
    }

    public String getSubProcessInstanceId() {
        return this.subProcessInstanceId;
    }

    public boolean isExcludeSubprocesses() {
        return this.excludeSubprocesses;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(SuspensionState suspensionState) {
        this.suspensionState = suspensionState;
    }

    public List<EventSubscriptionQueryValue> getEventSubscriptions() {
        return this.eventSubscriptions;
    }

    public boolean isIncludeChildExecutionsWithBusinessKeyQuery() {
        return this.includeChildExecutionsWithBusinessKeyQuery;
    }

    public void setEventSubscriptions(List<EventSubscriptionQueryValue> eventSubscriptions) {
        this.eventSubscriptions = eventSubscriptions;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String getInvolvedUser() {
        return this.involvedUser;
    }

    public void setInvolvedUser(String involvedUser) {
        this.involvedUser = involvedUser;
    }

    public IdentityLinkQueryObject getInvolvedUserIdentityLink() {
        return null;
    }

    public IdentityLinkQueryObject getInvolvedGroupIdentityLink() {
        return null;
    }

    public Set<String> getInvolvedGroups() {
        return this.involvedGroups;
    }

    public void setInvolvedGroups(Set<String> involvedGroups) {
        this.involvedGroups = involvedGroups;
    }

    public Set<String> getProcessDefinitionIds() {
        return this.processDefinitionIds;
    }

    public Set<String> getProcessDefinitionKeys() {
        return this.processDefinitionKeys;
    }

    public Set<String> getExcludeProcessDefinitionKeys() {
        return this.excludeProcessDefinitionKeys;
    }

    public String getParentId() {
        return this.parentId;
    }

    public boolean isOnlyChildExecutions() {
        return this.onlyChildExecutions;
    }

    public boolean isOnlySubProcessExecutions() {
        return this.onlySubProcessExecutions;
    }

    public boolean isOnlyProcessInstanceExecutions() {
        return this.onlyProcessInstanceExecutions;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public String getTenantIdLikeIgnoreCase() {
        return this.tenantIdLikeIgnoreCase;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    public String getNameLikeIgnoreCase() {
        return this.nameLikeIgnoreCase;
    }

    public void setNameLikeIgnoreCase(String nameLikeIgnoreCase) {
        this.nameLikeIgnoreCase = nameLikeIgnoreCase;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public List<String> getDeploymentIds() {
        return this.deploymentIds;
    }

    public void setDeploymentIds(List<String> deploymentIds) {
        this.deploymentIds = deploymentIds;
    }

    public String getActiveActivityId() {
        return this.activeActivityId;
    }

    public void setActiveActivityId(String activeActivityId) {
        this.activeActivityId = activeActivityId;
    }

    public Set<String> getActiveActivityIds() {
        return this.activeActivityIds;
    }

    public void setActiveActivityIds(Set<String> activeActivityIds) {
        this.activeActivityIds = activeActivityIds;
    }

    public Date getStartedBefore() {
        return this.startedBefore;
    }

    public void setStartedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
    }

    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public void setStartedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    public String getLocale() {
        return this.locale;
    }

    public boolean isWithLocalizationFallback() {
        return this.withLocalizationFallback;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    public String getCallbackType() {
        return this.callbackType;
    }

    public String getParentCaseInstanceId() {
        return this.parentCaseInstanceId;
    }

    public List<ExecutionQueryImpl> getOrQueryObjects() {
        return this.orQueryObjects;
    }

    public List<List<String>> getSafeProcessInstanceIds() {
        return null;
    }

    public List<List<String>> getSafeInvolvedGroups() {
        return this.safeInvolvedGroups;
    }

    public void setSafeInvolvedGroups(List<List<String>> safeInvolvedGroups) {
        this.safeInvolvedGroups = safeInvolvedGroups;
    }

    public String getRootScopeId() {
        return null;
    }

    public String getParentScopeId() {
        return null;
    }
}

