/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20DefaultAccessToken;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.code.OAuth20DefaultCode;
import org.apereo.cas.ticket.device.OAuth20DefaultDeviceToken;
import org.apereo.cas.ticket.device.OAuth20DefaultDeviceUserCode;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.apereo.cas.ticket.device.OAuth20DeviceUserCode;
import org.apereo.cas.ticket.refreshtoken.OAuth20DefaultRefreshToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.ticket.serialization.TicketSerializationExecutionPlanConfigurer;
import org.apereo.cas.util.serialization.BaseJacksonSerializer;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.OAuth})
@Configuration(value="CasOAuth20TicketSerializationConfiguration", proxyBeanMethods=false)
class CasOAuth20TicketSerializationConfiguration {
    CasOAuth20TicketSerializationConfiguration() {
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public TicketSerializationExecutionPlanConfigurer oauthTicketSerializationExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext) {
        return plan -> {
            plan.registerTicketSerializer((StringSerializer)new OAuthCodeTicketStringSerializer(applicationContext));
            plan.registerTicketSerializer((StringSerializer)new AccessTokenTicketStringSerializer(applicationContext));
            plan.registerTicketSerializer((StringSerializer)new RefreshTokenTicketStringSerializer(applicationContext));
            plan.registerTicketSerializer((StringSerializer)new DeviceTokenTicketStringSerializer(applicationContext));
            plan.registerTicketSerializer((StringSerializer)new DeviceUserCodeTicketStringSerializer(applicationContext));
            plan.registerTicketSerializer(OAuth20Code.class.getName(), (StringSerializer)new OAuthCodeTicketStringSerializer(applicationContext));
            plan.registerTicketSerializer(OAuth20AccessToken.class.getName(), (StringSerializer)new AccessTokenTicketStringSerializer(applicationContext));
            plan.registerTicketSerializer(OAuth20RefreshToken.class.getName(), (StringSerializer)new RefreshTokenTicketStringSerializer(applicationContext));
            plan.registerTicketSerializer(OAuth20DeviceToken.class.getName(), (StringSerializer)new DeviceTokenTicketStringSerializer(applicationContext));
            plan.registerTicketSerializer(OAuth20DeviceUserCode.class.getName(), (StringSerializer)new DeviceUserCodeTicketStringSerializer(applicationContext));
            plan.registerTicketSerializer("OC", (StringSerializer)new OAuthCodeTicketStringSerializer(applicationContext));
            plan.registerTicketSerializer("AT", (StringSerializer)new AccessTokenTicketStringSerializer(applicationContext));
            plan.registerTicketSerializer("RT", (StringSerializer)new RefreshTokenTicketStringSerializer(applicationContext));
            plan.registerTicketSerializer("ODT", (StringSerializer)new DeviceTokenTicketStringSerializer(applicationContext));
            plan.registerTicketSerializer("ODUC", (StringSerializer)new DeviceUserCodeTicketStringSerializer(applicationContext));
        };
    }

    private static final class OAuthCodeTicketStringSerializer
    extends BaseJacksonSerializer<OAuth20DefaultCode> {
        private static final long serialVersionUID = -2198623586274810263L;

        OAuthCodeTicketStringSerializer(ConfigurableApplicationContext applicationContext) {
            super(MINIMAL_PRETTY_PRINTER, applicationContext, OAuth20DefaultCode.class);
        }
    }

    private static final class AccessTokenTicketStringSerializer
    extends BaseJacksonSerializer<OAuth20DefaultAccessToken> {
        private static final long serialVersionUID = -2198623586274810263L;

        AccessTokenTicketStringSerializer(ConfigurableApplicationContext applicationContext) {
            super(MINIMAL_PRETTY_PRINTER, applicationContext, OAuth20DefaultAccessToken.class);
        }
    }

    private static final class RefreshTokenTicketStringSerializer
    extends BaseJacksonSerializer<OAuth20DefaultRefreshToken> {
        private static final long serialVersionUID = -2198623586274810263L;

        RefreshTokenTicketStringSerializer(ConfigurableApplicationContext applicationContext) {
            super(MINIMAL_PRETTY_PRINTER, applicationContext, OAuth20DefaultRefreshToken.class);
        }
    }

    private static final class DeviceTokenTicketStringSerializer
    extends BaseJacksonSerializer<OAuth20DefaultDeviceToken> {
        private static final long serialVersionUID = -2198623586274810263L;

        DeviceTokenTicketStringSerializer(ConfigurableApplicationContext applicationContext) {
            super(MINIMAL_PRETTY_PRINTER, applicationContext, OAuth20DefaultDeviceToken.class);
        }
    }

    private static final class DeviceUserCodeTicketStringSerializer
    extends BaseJacksonSerializer<OAuth20DefaultDeviceUserCode> {
        private static final long serialVersionUID = -2198623586274810263L;

        DeviceUserCodeTicketStringSerializer(ConfigurableApplicationContext applicationContext) {
            super(MINIMAL_PRETTY_PRINTER, applicationContext, OAuth20DefaultDeviceUserCode.class);
        }
    }
}

