/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.handler.SearchResultHandler;
import org.ldaptive.transport.AbstractMessageFunctionalEntryHandler;

public class RecursiveResultHandler
extends AbstractMessageFunctionalEntryHandler<SearchResponse>
implements SearchResultHandler {
    private static final int HASH_CODE_SEED = 829;
    private String searchAttribute;
    private String[] mergeAttributes;
    private String[] retAttrs;

    public RecursiveResultHandler() {
    }

    public RecursiveResultHandler(String searchAttr, String ... mergeAttrs) {
        this.searchAttribute = searchAttr;
        this.mergeAttributes = mergeAttrs;
        this.initializeReturnAttributes();
    }

    public String getSearchAttribute() {
        return this.searchAttribute;
    }

    public void setSearchAttribute(String name) {
        this.assertMutable();
        this.searchAttribute = name;
        this.initializeReturnAttributes();
    }

    public String[] getMergeAttributes() {
        return LdapUtils.copyArray(this.mergeAttributes);
    }

    public void setMergeAttributes(String ... mergeAttrs) {
        this.assertMutable();
        this.mergeAttributes = LdapUtils.copyArray(mergeAttrs);
        this.initializeReturnAttributes();
    }

    protected void initializeReturnAttributes() {
        if (this.mergeAttributes != null && this.searchAttribute != null) {
            this.retAttrs = new String[this.mergeAttributes.length + 1];
            System.arraycopy(this.mergeAttributes, 0, this.retAttrs, 0, this.mergeAttributes.length);
            this.retAttrs[this.retAttrs.length - 1] = this.searchAttribute;
        }
    }

    @Override
    public SearchResponse apply(SearchResponse response) {
        response.getEntries().forEach(this::handleEntry);
        return response;
    }

    @Override
    public void handleEntry(LdapEntry entry) {
        ArrayList<String> searchedDns = new ArrayList<String>();
        try {
            if (entry.getAttribute(this.searchAttribute) != null) {
                searchedDns.add(entry.getDn());
                this.readSearchAttribute(entry, searchedDns);
            } else {
                this.recursiveSearch(entry.getDn(), entry, searchedDns);
            }
        }
        catch (LdapException e) {
            throw new RuntimeException(e);
        }
    }

    private void readSearchAttribute(LdapEntry entry, List<String> searchedDns) throws LdapException {
        LdapAttribute attr;
        if (entry != null && (attr = entry.getAttribute(this.searchAttribute)) != null && !attr.isBinary()) {
            ArrayList<String> values = new ArrayList<String>(attr.getStringValues());
            for (String s : values) {
                this.recursiveSearch(s, entry, searchedDns);
            }
        }
    }

    private void recursiveSearch(String dn, LdapEntry entry, List<String> searchedDns) throws LdapException {
        if (!searchedDns.contains(dn)) {
            LdapEntry newEntry = null;
            SearchResponse result = this.performSearch(dn, this.retAttrs);
            if (result.isSuccess() && result.entrySize() == 1) {
                newEntry = LdapEntry.copy(result.getEntry());
            }
            searchedDns.add(dn);
            if (newEntry != null) {
                this.readSearchAttribute(newEntry, searchedDns);
                for (String s : this.mergeAttributes) {
                    LdapAttribute newAttr = newEntry.getAttribute(s);
                    if (newAttr == null) continue;
                    entry.mergeAttributes(newAttr);
                }
            }
        }
    }

    protected SearchResponse performSearch(String baseDn, String[] attrs) throws LdapException {
        return this.getConnection().operation(SearchRequest.objectScopeSearchRequest(baseDn, attrs)).execute();
    }

    public RecursiveResultHandler newInstance() {
        return new RecursiveResultHandler(this.searchAttribute, this.mergeAttributes);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RecursiveResultHandler) {
            RecursiveResultHandler v = (RecursiveResultHandler)o;
            return LdapUtils.areEqual(this.mergeAttributes, v.mergeAttributes) && LdapUtils.areEqual(this.retAttrs, v.retAttrs) && LdapUtils.areEqual(this.searchAttribute, v.searchAttribute);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(829, this.mergeAttributes, this.retAttrs, this.searchAttribute);
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::searchAttribute=" + this.searchAttribute + ", mergeAttributes=" + Arrays.toString(this.mergeAttributes) + ", retAttrs=" + Arrays.toString(this.retAttrs) + "]";
    }
}

