/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.LinkedHashMap;
import org.passay.CharacterSequence;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.SequenceData;

public class IllegalSequenceRule
implements Rule {
    public static final int DEFAULT_SEQUENCE_LENGTH = 5;
    public static final int MINIMUM_SEQUENCE_LENGTH = 3;
    protected final SequenceData sequenceData;
    protected int sequenceLength;
    protected boolean wrapSequence;
    protected boolean reportAllFailures;

    public IllegalSequenceRule(SequenceData data) {
        this(data, 5, false, true);
    }

    public IllegalSequenceRule(SequenceData data, int sl, boolean wrap) {
        this(data, sl, wrap, true);
    }

    public IllegalSequenceRule(SequenceData data, int sl, boolean wrap, boolean reportAll) {
        if (sl < 3) {
            throw new IllegalArgumentException(String.format("sequence length must be >= %s", 3));
        }
        this.sequenceData = data;
        this.sequenceLength = sl;
        this.wrapSequence = wrap;
        this.reportAllFailures = reportAll;
    }

    public int getSequenceLength() {
        return this.sequenceLength;
    }

    public SequenceData getSequenceData() {
        return this.sequenceData;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult();
        String password = passwordData.getPassword() + '\uffff';
        StringBuilder match = new StringBuilder(password.length());
        for (CharacterSequence cs : this.sequenceData.getSequences()) {
            int csLength = cs.length();
            int direction = 0;
            int prevPosition = -1;
            for (int i = 0; i < password.length(); ++i) {
                int diff;
                char c = password.charAt(i);
                int position = this.indexOf(cs, c);
                int n = diff = (position | prevPosition) < 0 ? 0 : position - prevPosition;
                if (this.wrapSequence && (diff == csLength - 1 || diff == 1 - csLength)) {
                    diff -= Integer.signum(diff) * csLength;
                }
                if (diff != direction && match.length() >= this.sequenceLength) {
                    this.addError(result, match.toString());
                }
                if (diff == 1 || diff == -1) {
                    if (diff != direction) {
                        match.delete(0, match.length() - 1);
                        direction = diff;
                    }
                } else {
                    match.setLength(0);
                    direction = 0;
                }
                match.append(c);
                prevPosition = position;
            }
        }
        return result;
    }

    public String toString() {
        return String.format("%s@%h::length=%d,wrap=%s,reportAllFailures=%s", this.getClass().getName(), this.hashCode(), this.sequenceLength, this.wrapSequence, this.reportAllFailures);
    }

    private int indexOf(CharacterSequence sequence, char c) {
        for (int i = 0; i < sequence.length(); ++i) {
            if (!sequence.matches(i, c)) continue;
            return i;
        }
        return -1;
    }

    private void addError(RuleResult result, String match) {
        if (this.reportAllFailures || result.getDetails().isEmpty()) {
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            m.put("sequence", match);
            result.addError(this.sequenceData.getErrorCode(), m);
        }
    }
}

