/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkThread;
import org.apache.kafka.clients.consumer.internals.ConsumerTestBuilder;
import org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.OffsetsRequestManager;
import org.apache.kafka.clients.consumer.internals.RequestManager;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEventProcessor;
import org.apache.kafka.clients.consumer.internals.events.AssignmentChangeEvent;
import org.apache.kafka.clients.consumer.internals.events.AsyncCommitEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableEventReaper;
import org.apache.kafka.clients.consumer.internals.events.ListOffsetsEvent;
import org.apache.kafka.clients.consumer.internals.events.NewTopicsMetadataUpdateRequestEvent;
import org.apache.kafka.clients.consumer.internals.events.PollEvent;
import org.apache.kafka.clients.consumer.internals.events.ResetPositionsEvent;
import org.apache.kafka.clients.consumer.internals.events.SyncCommitEvent;
import org.apache.kafka.clients.consumer.internals.events.TopicMetadataEvent;
import org.apache.kafka.clients.consumer.internals.events.ValidatePositionsEvent;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConsumerNetworkThreadTest {
    private ConsumerTestBuilder testBuilder;
    private Time time;
    private ConsumerMetadata metadata;
    private NetworkClientDelegate networkClient;
    private BlockingQueue<ApplicationEvent> applicationEventsQueue;
    private ApplicationEventProcessor applicationEventProcessor;
    private OffsetsRequestManager offsetsRequestManager;
    private CommitRequestManager commitRequestManager;
    private CoordinatorRequestManager coordinatorRequestManager;
    private ConsumerNetworkThread consumerNetworkThread;
    private final CompletableEventReaper applicationEventReaper = (CompletableEventReaper)Mockito.mock(CompletableEventReaper.class);
    private MockClient client;

    @BeforeEach
    public void setup() {
        this.testBuilder = new ConsumerTestBuilder(ConsumerTestBuilder.createDefaultGroupInformation());
        this.time = this.testBuilder.time;
        this.metadata = this.testBuilder.metadata;
        this.networkClient = this.testBuilder.networkClientDelegate;
        this.client = this.testBuilder.client;
        this.applicationEventsQueue = this.testBuilder.applicationEventQueue;
        this.applicationEventProcessor = this.testBuilder.applicationEventProcessor;
        this.commitRequestManager = this.testBuilder.commitRequestManager.orElseThrow(IllegalStateException::new);
        this.offsetsRequestManager = this.testBuilder.offsetsRequestManager;
        this.coordinatorRequestManager = this.testBuilder.coordinatorRequestManager.orElseThrow(IllegalStateException::new);
        this.consumerNetworkThread = new ConsumerNetworkThread(this.testBuilder.logContext, this.time, this.testBuilder.applicationEventQueue, this.applicationEventReaper, () -> this.applicationEventProcessor, () -> this.testBuilder.networkClientDelegate, () -> this.testBuilder.requestManagers);
        this.consumerNetworkThread.initializeResources();
    }

    @AfterEach
    public void tearDown() {
        if (this.testBuilder != null) {
            this.testBuilder.close();
            this.consumerNetworkThread.close(Duration.ZERO);
        }
    }

    @Test
    public void testStartupAndTearDown() throws InterruptedException {
        this.consumerNetworkThread.start();
        TestCondition isStarted = () -> this.consumerNetworkThread.isRunning();
        TestCondition isClosed = () -> !this.consumerNetworkThread.isRunning() && !this.consumerNetworkThread.isAlive();
        TestUtils.waitForCondition(isStarted, "The consumer network thread did not start within 15000 ms");
        this.consumerNetworkThread.close(Duration.ofMillis(15000L));
        TestUtils.waitForCondition(isClosed, "The consumer network thread did not stop within 15000 ms");
    }

    @Test
    public void testApplicationEvent() {
        PollEvent e = new PollEvent(100L);
        this.applicationEventsQueue.add((ApplicationEvent)e);
        this.consumerNetworkThread.runOnce();
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor, (VerificationMode)Mockito.times((int)1))).process((ApplicationEvent)e);
    }

    @Test
    public void testMetadataUpdateEvent() {
        NewTopicsMetadataUpdateRequestEvent e = new NewTopicsMetadataUpdateRequestEvent();
        this.applicationEventsQueue.add((ApplicationEvent)e);
        this.consumerNetworkThread.runOnce();
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdateForNewTopics();
    }

    @Test
    public void testAsyncCommitEvent() {
        AsyncCommitEvent e = new AsyncCommitEvent(new HashMap());
        this.applicationEventsQueue.add((ApplicationEvent)e);
        this.consumerNetworkThread.runOnce();
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor)).process((ApplicationEvent)ArgumentMatchers.any(AsyncCommitEvent.class));
    }

    @Test
    public void testSyncCommitEvent() {
        SyncCommitEvent e = new SyncCommitEvent(new HashMap(), CompletableEvent.calculateDeadlineMs((Time)this.time, (long)100L));
        this.applicationEventsQueue.add((ApplicationEvent)e);
        this.consumerNetworkThread.runOnce();
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor)).process((ApplicationEvent)ArgumentMatchers.any(SyncCommitEvent.class));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testListOffsetsEventIsProcessed(boolean requireTimestamp) {
        Map<TopicPartition, Long> timestamps = Collections.singletonMap(new TopicPartition("topic1", 1), 5L);
        ListOffsetsEvent e = new ListOffsetsEvent(timestamps, CompletableEvent.calculateDeadlineMs((Time)this.time, (long)100L), requireTimestamp);
        this.applicationEventsQueue.add((ApplicationEvent)e);
        this.consumerNetworkThread.runOnce();
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor)).process((ApplicationEvent)ArgumentMatchers.any(ListOffsetsEvent.class));
        Assertions.assertTrue((boolean)this.applicationEventsQueue.isEmpty());
    }

    @Test
    public void testResetPositionsEventIsProcessed() {
        ResetPositionsEvent e = new ResetPositionsEvent(CompletableEvent.calculateDeadlineMs((Time)this.time, (long)100L));
        this.applicationEventsQueue.add((ApplicationEvent)e);
        this.consumerNetworkThread.runOnce();
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor)).process((ApplicationEvent)ArgumentMatchers.any(ResetPositionsEvent.class));
        Assertions.assertTrue((boolean)this.applicationEventsQueue.isEmpty());
    }

    @Test
    public void testResetPositionsProcessFailureIsIgnored() {
        ((OffsetsRequestManager)Mockito.doThrow((Throwable[])new Throwable[]{new NullPointerException()}).when((Object)this.offsetsRequestManager)).resetPositionsIfNeeded();
        ResetPositionsEvent event = new ResetPositionsEvent(CompletableEvent.calculateDeadlineMs((Time)this.time, (long)100L));
        this.applicationEventsQueue.add((ApplicationEvent)event);
        Assertions.assertDoesNotThrow(() -> this.consumerNetworkThread.runOnce());
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor)).process((ApplicationEvent)ArgumentMatchers.any(ResetPositionsEvent.class));
    }

    @Test
    public void testValidatePositionsEventIsProcessed() {
        ValidatePositionsEvent e = new ValidatePositionsEvent(CompletableEvent.calculateDeadlineMs((Time)this.time, (long)100L));
        this.applicationEventsQueue.add((ApplicationEvent)e);
        this.consumerNetworkThread.runOnce();
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor)).process((ApplicationEvent)ArgumentMatchers.any(ValidatePositionsEvent.class));
        Assertions.assertTrue((boolean)this.applicationEventsQueue.isEmpty());
    }

    @Test
    public void testAssignmentChangeEvent() {
        HashMap<TopicPartition, OffsetAndMetadata> offset = this.mockTopicPartitionOffset();
        long currentTimeMs = this.time.milliseconds();
        AssignmentChangeEvent e = new AssignmentChangeEvent(offset, currentTimeMs);
        this.applicationEventsQueue.add((ApplicationEvent)e);
        this.consumerNetworkThread.runOnce();
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor)).process((ApplicationEvent)ArgumentMatchers.any(AssignmentChangeEvent.class));
        ((NetworkClientDelegate)Mockito.verify((Object)this.networkClient, (VerificationMode)Mockito.times((int)1))).poll(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((CommitRequestManager)Mockito.verify((Object)this.commitRequestManager, (VerificationMode)Mockito.times((int)1))).updateAutoCommitTimer(currentTimeMs);
        ((CommitRequestManager)Mockito.verify((Object)this.commitRequestManager, (VerificationMode)Mockito.times((int)1))).maybeAutoCommitAsync();
    }

    @Test
    void testFetchTopicMetadata() {
        this.applicationEventsQueue.add((ApplicationEvent)new TopicMetadataEvent("topic", Long.MAX_VALUE));
        this.consumerNetworkThread.runOnce();
        ((ApplicationEventProcessor)Mockito.verify((Object)this.applicationEventProcessor)).process((ApplicationEvent)ArgumentMatchers.any(TopicMetadataEvent.class));
    }

    @Test
    void testPollResultTimer() {
        NetworkClientDelegate.UnsentRequest req = new NetworkClientDelegate.UnsentRequest((AbstractRequest.Builder)new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.TRANSACTION.id()).setKey("foobar")), Optional.empty());
        req.setTimer(this.time, 500L);
        NetworkClientDelegate.PollResult success = new NetworkClientDelegate.PollResult(10L, Collections.singletonList(req));
        Assertions.assertEquals((long)10L, (long)this.networkClient.addAll(success));
        NetworkClientDelegate.PollResult failure = new NetworkClientDelegate.PollResult(10L, new ArrayList());
        Assertions.assertEquals((long)10L, (long)this.networkClient.addAll(failure));
    }

    @Test
    void testMaximumTimeToWait() {
        Assertions.assertEquals((long)5000L, (long)this.consumerNetworkThread.maximumTimeToWait());
        this.consumerNetworkThread.runOnce();
        Assertions.assertEquals((long)1000L, (long)this.consumerNetworkThread.maximumTimeToWait());
    }

    @Test
    void testRequestManagersArePolledOnce() {
        this.consumerNetworkThread.runOnce();
        this.testBuilder.requestManagers.entries().forEach(rmo -> rmo.ifPresent(rm -> ((RequestManager)Mockito.verify((Object)rm, (VerificationMode)Mockito.times((int)1))).poll(ArgumentMatchers.anyLong())));
        this.testBuilder.requestManagers.entries().forEach(rmo -> rmo.ifPresent(rm -> ((RequestManager)Mockito.verify((Object)rm, (VerificationMode)Mockito.times((int)1))).maximumTimeToWait(ArgumentMatchers.anyLong())));
        ((NetworkClientDelegate)Mockito.verify((Object)this.networkClient, (VerificationMode)Mockito.times((int)1))).poll(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
    }

    @Test
    void testEnsureMetadataUpdateOnPoll() {
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWith(2, Collections.emptyMap());
        this.client.prepareMetadataUpdate(metadataResponse);
        this.metadata.requestUpdate(false);
        this.consumerNetworkThread.runOnce();
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.times((int)1))).updateWithCurrentRequestVersion((MetadataResponse)ArgumentMatchers.eq((Object)metadataResponse), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.anyLong());
    }

    @Test
    void testEnsureEventsAreCompleted() {
        ((CompletableEventReaper)Mockito.doAnswer(__ -> {
            Iterator i = this.applicationEventsQueue.iterator();
            while (i.hasNext()) {
                ApplicationEvent event = (ApplicationEvent)i.next();
                if (event instanceof CompletableEvent) {
                    ((CompletableEvent)event).future().completeExceptionally((Throwable)new TimeoutException());
                }
                i.remove();
            }
            return null;
        }).when((Object)this.applicationEventReaper)).reap((Collection)ArgumentMatchers.any(Collection.class));
        Node node = (Node)this.metadata.fetch().nodes().get(0);
        this.coordinatorRequestManager.markCoordinatorUnknown("test", this.time.milliseconds());
        this.client.prepareResponse((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"group-id", (Node)node));
        this.prepareOffsetCommitRequest(new HashMap<TopicPartition, Long>(), Errors.NONE, false);
        CompletableApplicationEvent event1 = (CompletableApplicationEvent)Mockito.spy((Object)new AsyncCommitEvent(Collections.emptyMap()));
        AsyncCommitEvent event2 = new AsyncCommitEvent(Collections.emptyMap());
        CompletableFuture future = new CompletableFuture();
        Mockito.when((Object)event1.future()).thenReturn(future);
        this.applicationEventsQueue.add((ApplicationEvent)event1);
        this.applicationEventsQueue.add((ApplicationEvent)event2);
        Assertions.assertFalse((boolean)future.isDone());
        Assertions.assertFalse((boolean)this.applicationEventsQueue.isEmpty());
        this.consumerNetworkThread.cleanup();
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        Assertions.assertTrue((boolean)this.applicationEventsQueue.isEmpty());
    }

    @Test
    void testCleanupInvokesReaper() {
        this.consumerNetworkThread.cleanup();
        ((CompletableEventReaper)Mockito.verify((Object)this.applicationEventReaper)).reap(this.applicationEventsQueue);
    }

    @Test
    void testRunOnceInvokesReaper() {
        this.consumerNetworkThread.runOnce();
        ((CompletableEventReaper)Mockito.verify((Object)this.applicationEventReaper)).reap(((Long)ArgumentMatchers.any(Long.class)).longValue());
    }

    @Test
    void testSendUnsentRequest() {
        String groupId = "group-id";
        NetworkClientDelegate.UnsentRequest request = new NetworkClientDelegate.UnsentRequest((AbstractRequest.Builder)new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.TRANSACTION.id()).setKey(groupId)), Optional.empty());
        this.networkClient.add(request);
        Assertions.assertTrue((boolean)this.networkClient.hasAnyPendingRequests());
        Assertions.assertFalse((boolean)this.networkClient.unsentRequests().isEmpty());
        Assertions.assertFalse((boolean)this.client.hasInFlightRequests());
        this.consumerNetworkThread.cleanup();
        Assertions.assertTrue((boolean)this.networkClient.unsentRequests().isEmpty());
        Assertions.assertFalse((boolean)this.client.hasInFlightRequests());
        Assertions.assertFalse((boolean)this.networkClient.hasAnyPendingRequests());
    }

    private void prepareOffsetCommitRequest(Map<TopicPartition, Long> expectedOffsets, Errors error, boolean disconnected) {
        Map<TopicPartition, Errors> errors = this.partitionErrors(expectedOffsets.keySet(), error);
        this.client.prepareResponse(this.offsetCommitRequestMatcher(expectedOffsets), (AbstractResponse)this.offsetCommitResponse(errors), disconnected);
    }

    private Map<TopicPartition, Errors> partitionErrors(Collection<TopicPartition> partitions, Errors error) {
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>();
        for (TopicPartition partition : partitions) {
            errors.put(partition, error);
        }
        return errors;
    }

    private OffsetCommitResponse offsetCommitResponse(Map<TopicPartition, Errors> responseData) {
        return new OffsetCommitResponse(responseData);
    }

    private MockClient.RequestMatcher offsetCommitRequestMatcher(Map<TopicPartition, Long> expectedOffsets) {
        return body -> {
            OffsetCommitRequest req = (OffsetCommitRequest)body;
            Map offsets = req.offsets();
            if (offsets.size() != expectedOffsets.size()) {
                return false;
            }
            for (Map.Entry expectedOffset : expectedOffsets.entrySet()) {
                if (!offsets.containsKey(expectedOffset.getKey())) {
                    return false;
                }
                Long actualOffset = (Long)offsets.get(expectedOffset.getKey());
                if (actualOffset.equals(expectedOffset.getValue())) continue;
                return false;
            }
            return true;
        };
    }

    private HashMap<TopicPartition, OffsetAndMetadata> mockTopicPartitionOffset() {
        TopicPartition t0 = new TopicPartition("t0", 2);
        TopicPartition t1 = new TopicPartition("t0", 3);
        HashMap<TopicPartition, OffsetAndMetadata> topicPartitionOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        topicPartitionOffsets.put(t0, new OffsetAndMetadata(10L));
        topicPartitionOffsets.put(t1, new OffsetAndMetadata(20L));
        return topicPartitionOffsets;
    }
}

