/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.expression;

import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.spring5.util.SpringVersionUtils;
import org.thymeleaf.util.ClassLoaderUtils;

public class Mvc {
    private static final MvcUriComponentsBuilderDelegate mvcUriComponentsBuilderDelegate;
    private static final String SPRING41_MVC_URI_COMPONENTS_BUILDER_DELEGATE_CLASS_NAME;
    private static final String NON_SPRING41_MVC_URI_COMPONENTS_BUILDER_DELEGATE_CLASS_NAME;

    public MethodArgumentBuilderWrapper url(String mappingName) {
        return mvcUriComponentsBuilderDelegate.fromMappingName(mappingName);
    }

    static {
        SPRING41_MVC_URI_COMPONENTS_BUILDER_DELEGATE_CLASS_NAME = Mvc.class.getName() + "$Spring41MvcUriComponentsBuilderDelegate";
        NON_SPRING41_MVC_URI_COMPONENTS_BUILDER_DELEGATE_CLASS_NAME = Mvc.class.getName() + "$NonSpring41MvcUriComponentsBuilderDelegate";
        String delegateClassName = SpringVersionUtils.isSpring41AtLeast() ? SPRING41_MVC_URI_COMPONENTS_BUILDER_DELEGATE_CLASS_NAME : NON_SPRING41_MVC_URI_COMPONENTS_BUILDER_DELEGATE_CLASS_NAME;
        try {
            Class implClass = ClassLoaderUtils.loadClass((String)delegateClassName);
            mvcUriComponentsBuilderDelegate = (MvcUriComponentsBuilderDelegate)implClass.newInstance();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError((Throwable)new ConfigurationException("Thymeleaf could not initialize a delegate of class \"" + delegateClassName + "\" for taking care of the " + "mvc" + " expression utility object", (Throwable)e));
        }
    }

    static class Spring41MethodArgumentBuilderWrapper
    implements MethodArgumentBuilderWrapper {
        private final MvcUriComponentsBuilder.MethodArgumentBuilder builder;

        private Spring41MethodArgumentBuilderWrapper(MvcUriComponentsBuilder.MethodArgumentBuilder builder) {
            this.builder = builder;
        }

        @Override
        public MethodArgumentBuilderWrapper arg(int index, Object value) {
            return new Spring41MethodArgumentBuilderWrapper(this.builder.arg(index, value));
        }

        @Override
        public MethodArgumentBuilderWrapper encode() {
            if (!SpringVersionUtils.isSpringAtLeast(5, 0, 8)) {
                throw new IllegalStateException(String.format("At least Spring version 5.0.8.RELEASE is needed for executing MvcUriComponentsBuilder#encode() but detected Spring version is %s.", SpringVersionUtils.getSpringVersion()));
            }
            return new Spring41MethodArgumentBuilderWrapper(this.builder.encode());
        }

        @Override
        public String build() {
            return this.builder.build();
        }

        @Override
        public String buildAndExpand(Object ... uriVariables) {
            return this.builder.buildAndExpand(uriVariables);
        }
    }

    public static interface MethodArgumentBuilderWrapper {
        public MethodArgumentBuilderWrapper arg(int var1, Object var2);

        public MethodArgumentBuilderWrapper encode();

        public String build();

        public String buildAndExpand(Object ... var1);
    }

    static class NonSpring41MvcUriComponentsBuilderDelegate
    implements MvcUriComponentsBuilderDelegate {
        NonSpring41MvcUriComponentsBuilderDelegate() {
        }

        @Override
        public MethodArgumentBuilderWrapper fromMappingName(String mappingName) {
            throw new UnsupportedOperationException("MVC URI component building is only supported in Spring versions 4.1 or newer");
        }
    }

    static class Spring41MvcUriComponentsBuilderDelegate
    implements MvcUriComponentsBuilderDelegate {
        Spring41MvcUriComponentsBuilderDelegate() {
        }

        @Override
        public MethodArgumentBuilderWrapper fromMappingName(String mappingName) {
            return new Spring41MethodArgumentBuilderWrapper(MvcUriComponentsBuilder.fromMappingName((String)mappingName));
        }
    }

    static interface MvcUriComponentsBuilderDelegate {
        public MethodArgumentBuilderWrapper fromMappingName(String var1);
    }
}

