/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.tripwire;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import jdk.jfr.Configuration;
import jdk.jfr.Recording;

public class TripwireRecording {
    private final Recording flightRecording;

    TripwireRecording(String configuration, Path sendTo, int maxAge, long maxSize) {
        try {
            Configuration c = Configuration.create(new InputStreamReader(this.getClass().getResourceAsStream("/" + configuration + ".jfc")));
            this.flightRecording = new Recording(c);
            if (maxAge > 0) {
                this.flightRecording.setMaxAge(Duration.ofMinutes(maxAge));
            }
            if (maxSize > 0L) {
                this.flightRecording.setMaxSize(maxSize);
            }
            this.flightRecording.setToDisk(true);
            if (sendTo != null) {
                this.flightRecording.setDestination(sendTo);
                this.flightRecording.setDumpOnExit(true);
            }
            this.flightRecording.start();
        }
        catch (IOException | ParseException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public String dump(Path save) {
        try {
            this.flightRecording.dump(save);
        }
        catch (IOException ioe) {
            return ioe.toString();
        }
        return save.toAbsolutePath().toString();
    }

    public String dumpSegment(Path destination, Duration segment) {
        Instant now = Instant.now();
        if (segment == null) {
            segment = this.flightRecording.getMaxAge();
        }
        Instant i = now.minus(segment);
        try (Recording r = this.flightRecording.copy(true);
             InputStream is = r.getStream(i, now);){
            this.writeToPath(is, destination);
        }
        catch (IOException ioe) {
            return ioe.toString();
        }
        return destination.toAbsolutePath().toString();
    }

    private void writeToPath(InputStream is, Path dest) throws IOException {
        byte[] buffer = new byte[1024];
        try (OutputStream fos = Files.newOutputStream(dest, new OpenOption[0]);){
            int amt = is.read(buffer);
            while (amt >= 0) {
                fos.write(buffer, 0, amt);
                amt = is.read(buffer);
            }
        }
    }
}

