/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.to.RoleTO;
import org.apache.syncope.common.rest.api.service.RoleService;

public class RoleRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -3161863874876938094L;

    public void delete(String key) {
        this.getService(RoleService.class).delete(key);
    }

    public RoleTO read(String key) {
        return this.getService(RoleService.class).read(key);
    }

    public void update(RoleTO roleTO) {
        this.getService(RoleService.class).update(roleTO);
    }

    public void create(RoleTO roleTO) {
        this.getService(RoleService.class).create(roleTO);
    }

    public List<RoleTO> list() {
        return this.getService(RoleService.class).list();
    }

    public String readAnyLayout(String roleKey) {
        try {
            return IOUtils.toString((InputStream)((InputStream)InputStream.class.cast(this.getService(RoleService.class).getAnyLayout(roleKey).getEntity())), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOG.error("Error retrieving console layout info for role {}", (Object)roleKey, (Object)e);
            return "";
        }
    }

    public void setAnyLayout(String roleKey, String content) {
        this.getService(RoleService.class).setAnyLayout(roleKey, IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8));
    }

    public void removeAnyLayout(String roleKey) {
        this.getService(RoleService.class).removeAnyLayout(roleKey);
    }

    public List<String> getAllAvailableEntitlements() {
        return SyncopeConsoleSession.get().getAnonymousClient().platform().getEntitlements().stream().sorted().collect(Collectors.toList());
    }
}

