/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.MessageFlow;
import org.flowable.bpmn.model.Pool;

public class CollaborationExport
implements BpmnXMLConstants {
    public static void writePools(BpmnModel model, XMLStreamWriter xtw) throws Exception {
        if (!model.getPools().isEmpty()) {
            xtw.writeStartElement("collaboration");
            xtw.writeAttribute("id", "Collaboration");
            for (Pool pool : model.getPools()) {
                xtw.writeStartElement("participant");
                xtw.writeAttribute("id", pool.getId());
                if (StringUtils.isNotEmpty((CharSequence)pool.getName())) {
                    xtw.writeAttribute("name", pool.getName());
                }
                if (StringUtils.isNotEmpty((CharSequence)pool.getProcessRef())) {
                    xtw.writeAttribute("processRef", pool.getProcessRef());
                }
                xtw.writeEndElement();
            }
            for (MessageFlow messageFlow : model.getMessageFlows().values()) {
                xtw.writeStartElement("messageFlow");
                xtw.writeAttribute("id", messageFlow.getId());
                if (StringUtils.isNotEmpty((CharSequence)messageFlow.getName())) {
                    xtw.writeAttribute("name", messageFlow.getName());
                }
                if (StringUtils.isNotEmpty((CharSequence)messageFlow.getSourceRef())) {
                    xtw.writeAttribute("sourceRef", messageFlow.getSourceRef());
                }
                if (StringUtils.isNotEmpty((CharSequence)messageFlow.getTargetRef())) {
                    xtw.writeAttribute("targetRef", messageFlow.getTargetRef());
                }
                if (StringUtils.isNotEmpty((CharSequence)messageFlow.getMessageRef())) {
                    xtw.writeAttribute("messageRef", messageFlow.getMessageRef());
                }
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
    }
}

