/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CoalescingBufferQueue;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.util.ReferenceCountUtil;
import java.net.SocketAddress;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslHandler
extends SimpleChannelInboundHandler<ByteBuf>
implements ChannelOutboundHandler {
    private final Logger logger = LoggerFactory.getLogger(SaslHandler.class);
    private final SaslClient saslClient;
    private CoalescingBufferQueue queue;

    public SaslHandler(SaslClient sc) {
        this.saslClient = sc;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.queue = new CoalescingBufferQueue(ctx.channel());
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.dispose();
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        byte[] bytes = new byte[msg.readableBytes()];
        msg.readBytes(bytes);
        ctx.fireChannelRead((Object)Unpooled.wrappedBuffer((byte[])this.saslClient.unwrap(bytes, 0, bytes.length)));
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.dispose();
        ctx.close(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.dispose();
        ctx.close(promise);
    }

    private void dispose() {
        try {
            this.saslClient.dispose();
        }
        catch (SaslException e) {
            this.logger.warn("Error disposing of SASL client", (Throwable)e);
        }
        if (this.queue != null && !this.queue.isEmpty()) {
            this.queue.releaseAndFailAll((Throwable)new ChannelException("SASL client closed"));
        }
        this.queue = null;
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof ByteBuf)) {
            UnsupportedMessageTypeException exception = new UnsupportedMessageTypeException(msg, new Class[]{ByteBuf.class});
            ReferenceCountUtil.safeRelease((Object)msg);
            promise.setFailure((Throwable)exception);
        }
        this.queue.add((ByteBuf)msg, promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flush(ChannelHandlerContext ctx) throws Exception {
        if (this.queue.isEmpty()) {
            return;
        }
        ByteBuf buf = null;
        try {
            ChannelPromise promise = ctx.newPromise();
            int readableBytes = this.queue.readableBytes();
            buf = this.queue.remove(readableBytes, promise);
            byte[] bytes = new byte[readableBytes];
            buf.readBytes(bytes);
            byte[] wrappedBytes = this.saslClient.wrap(bytes, 0, bytes.length);
            ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])wrappedBytes), promise);
            if (buf == null) return;
        }
        catch (Throwable throwable) {
            if (buf == null) throw throwable;
            ReferenceCountUtil.safeRelease(buf);
            throw throwable;
        }
        ReferenceCountUtil.safeRelease((Object)buf);
    }
}

