/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.context;

import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ContextResourceResolverFactory {
    private static final Logger log = LoggerFactory.getLogger(ContextResourceResolverFactory.class);

    private ContextResourceResolverFactory() {
    }

    @NotNull
    public static ResourceResolverFactory get(@Nullable ResourceResolverType resourceResolverType, @NotNull BundleContext bundleContext) {
        ResourceResolverType type = resourceResolverType;
        if (type == null) {
            type = MockSling.DEFAULT_RESOURCERESOLVER_TYPE;
        }
        try {
            log.debug("Start initialize resource resolver factory, bundleContext={}", (Object)bundleContext);
            ResourceResolverFactory factory = MockSling.newResourceResolverFactory(type, bundleContext);
            log.debug("Finished initializing resource resolver factory, bundleContext={}", (Object)bundleContext);
            return factory;
        }
        catch (Throwable ex) {
            log.error("Failed initializing resource resolver factory, bundleContext={}", (Object)bundleContext, (Object)ex);
            throw new RuntimeException("Unable to initialize " + String.valueOf((Object)type) + " resource resolver factory: " + ex.getMessage(), ex);
        }
    }
}

