/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.sis.metadata.internal.Dependencies;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.metadata.iso.content.AbstractContentInformation;
import org.apache.sis.metadata.iso.content.DefaultAttributeGroup;
import org.apache.sis.metadata.iso.content.DefaultImageDescription;
import org.apache.sis.metadata.iso.legacy.LegacyPropertyAdapter;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.gmi.MI_CoverageDescription;
import org.apache.sis.xml.bind.metadata.MD_Identifier;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.content.CoverageDescription;
import org.opengis.metadata.content.ImageDescription;
import org.opengis.metadata.content.RangeDimension;
import org.opengis.metadata.content.RangeElementDescription;
import org.opengis.util.RecordType;

@XmlType(name="MD_CoverageDescription_Type", propOrder={"attributeDescription", "processingLevelCode", "attributeGroup", "contentType", "dimensions", "rangeElementDescriptions"})
@XmlRootElement(name="MD_CoverageDescription")
@XmlSeeAlso(value={DefaultImageDescription.class, MI_CoverageDescription.class})
public class DefaultCoverageDescription
extends AbstractContentInformation
implements CoverageDescription {
    private static final long serialVersionUID = 2161065580202989466L;
    private RecordType attributeDescription;
    private Identifier processingLevelCode;
    private Collection<DefaultAttributeGroup> attributeGroups;
    private Collection<RangeElementDescription> rangeElementDescriptions;

    public DefaultCoverageDescription() {
    }

    public DefaultCoverageDescription(CoverageDescription object) {
        super((ContentInformation)object);
        if (object != null) {
            this.attributeDescription = object.getAttributeDescription();
            this.rangeElementDescriptions = DefaultCoverageDescription.copyCollection(object.getRangeElementDescriptions(), RangeElementDescription.class);
            if (object instanceof DefaultCoverageDescription) {
                this.processingLevelCode = ((DefaultCoverageDescription)object).getProcessingLevelCode();
                this.attributeGroups = DefaultCoverageDescription.copyCollection(((DefaultCoverageDescription)object).getAttributeGroups(), DefaultAttributeGroup.class);
            }
        }
    }

    public static DefaultCoverageDescription castOrCopy(CoverageDescription object) {
        if (object instanceof ImageDescription) {
            return DefaultImageDescription.castOrCopy((ImageDescription)object);
        }
        if (object == null || object instanceof DefaultCoverageDescription) {
            return (DefaultCoverageDescription)object;
        }
        return new DefaultCoverageDescription(object);
    }

    @XmlElement(name="attributeDescription", required=true)
    public RecordType getAttributeDescription() {
        return this.attributeDescription;
    }

    public void setAttributeDescription(RecordType newValue) {
        this.checkWritePermission(this.attributeDescription);
        this.attributeDescription = newValue;
    }

    @XmlElement(name="processingLevelCode")
    @XmlJavaTypeAdapter(value=MD_Identifier.Since2014.class)
    @UML(identifier="processingLevelCode", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Identifier getProcessingLevelCode() {
        return this.processingLevelCode;
    }

    public void setProcessingLevelCode(Identifier newValue) {
        this.checkWritePermission(this.processingLevelCode);
        this.processingLevelCode = newValue;
    }

    @UML(identifier="attributeGroup", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultAttributeGroup> getAttributeGroups() {
        this.attributeGroups = this.nonNullCollection(this.attributeGroups, DefaultAttributeGroup.class);
        return this.attributeGroups;
    }

    public void setAttributeGroups(Collection<? extends DefaultAttributeGroup> newValues) {
        this.attributeGroups = this.writeCollection(newValues, this.attributeGroups, DefaultAttributeGroup.class);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getAttributeGroups"})
    @XmlElement(name="contentType", namespace="http://www.isotc211.org/2005/gmd")
    public CoverageContentType getContentType() {
        Collection<DefaultAttributeGroup> groups;
        CoverageContentType type = null;
        if (FilterByVersion.LEGACY_METADATA.accept() && (groups = this.getAttributeGroups()) != null) {
            block0: for (DefaultAttributeGroup g : groups) {
                Collection<CoverageContentType> contentTypes = g.getContentTypes();
                if (contentTypes == null) continue;
                for (CoverageContentType t : contentTypes) {
                    if (type == null) {
                        type = t;
                        continue;
                    }
                    LegacyPropertyAdapter.warnIgnoredExtraneous(CoverageContentType.class, DefaultCoverageDescription.class, "getContentType");
                    continue block0;
                }
            }
        }
        return type;
    }

    @Deprecated(since="1.0")
    public void setContentType(CoverageContentType newValue) {
        Iterator<DefaultAttributeGroup> iterator;
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.attributeGroups));
        Set newValues = Containers.singletonOrEmpty((Object)newValue);
        Collection<DefaultAttributeGroup> groups = this.attributeGroups;
        if (groups != null && (iterator = groups.iterator()).hasNext()) {
            DefaultAttributeGroup group = iterator.next();
            group.setContentTypes(newValues);
            return;
        }
        DefaultAttributeGroup group = new DefaultAttributeGroup();
        group.setContentTypes(newValues);
        if (groups != null) {
            groups.add(group);
        } else {
            groups = Collections.singleton(group);
        }
        this.setAttributeGroups(groups);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getAttributeGroups"})
    @XmlElement(name="dimension", namespace="http://www.isotc211.org/2005/gmd")
    public final Collection<RangeDimension> getDimensions() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        return new LegacyPropertyAdapter<RangeDimension, DefaultAttributeGroup>(this.getAttributeGroups()){

            @Override
            protected DefaultAttributeGroup wrap(RangeDimension value) {
                DefaultAttributeGroup container = new DefaultAttributeGroup();
                container.setAttributes(Containers.singletonOrEmpty((Object)value));
                return container;
            }

            @Override
            protected RangeDimension unwrap(DefaultAttributeGroup container) {
                return 1.getSingleton(container.getAttributes(), RangeDimension.class, this, DefaultCoverageDescription.class, "getDimensions");
            }

            @Override
            protected boolean update(DefaultAttributeGroup container, RangeDimension value) {
                if (container instanceof DefaultAttributeGroup) {
                    container.setAttributes(Containers.singletonOrEmpty((Object)value));
                    return true;
                }
                return false;
            }
        }.validOrNull();
    }

    @Deprecated(since="1.0")
    public void setDimensions(Collection<? extends RangeDimension> newValues) {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.attributeGroups));
        ((LegacyPropertyAdapter)this.getDimensions()).setValues(newValues);
    }

    @XmlElement(name="rangeElementDescription")
    public Collection<RangeElementDescription> getRangeElementDescriptions() {
        this.rangeElementDescriptions = this.nonNullCollection(this.rangeElementDescriptions, RangeElementDescription.class);
        return this.rangeElementDescriptions;
    }

    public void setRangeElementDescriptions(Collection<? extends RangeElementDescription> newValues) {
        this.rangeElementDescriptions = this.writeCollection(newValues, this.rangeElementDescriptions, RangeElementDescription.class);
    }

    @XmlElement(name="attributeGroup")
    private Collection<DefaultAttributeGroup> getAttributeGroup() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getAttributeGroups() : null;
    }
}

