/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.AbstractDerivedCRS;
import org.apache.sis.referencing.crs.DefaultEngineeringCRS;
import org.apache.sis.referencing.crs.DefaultGeodeticCRS;
import org.apache.sis.referencing.crs.DefaultParametricCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;

@XmlType(name="AbstractSingleCRSType")
@XmlRootElement(name="AbstractSingleCRS")
@XmlSeeAlso(value={AbstractDerivedCRS.class, DefaultGeodeticCRS.class, DefaultVerticalCRS.class, DefaultTemporalCRS.class, DefaultParametricCRS.class, DefaultEngineeringCRS.class})
class AbstractSingleCRS<D extends Datum>
extends AbstractCRS
implements SingleCRS {
    private static final long serialVersionUID = 2876221982955686798L;
    private D datum;
    private final DefaultDatumEnsemble<D> ensemble;

    AbstractSingleCRS(Map<String, ?> properties, Class<D> datumType, D datum, DefaultDatumEnsemble<D> ensemble, CoordinateSystem cs) {
        super(properties, cs);
        if (datum instanceof DefaultDatumEnsemble) {
            throw new IllegalArgumentException(Errors.forProperties(properties).getString((short)57, (Object)"datum", (Object)DefaultDatumEnsemble.class.getSimpleName()));
        }
        this.datum = datum;
        this.ensemble = ensemble;
        this.checkDatum(properties);
    }

    private void checkDatum(Map<String, ?> properties) {
        if (this.ensemble == null) {
            ArgumentChecks.ensureNonNull((String)"datum", this.datum);
        } else {
            if (this.datum != null) {
                for (Datum member : this.ensemble.getMembers()) {
                    if (!Utilities.equalsIgnoreMetadata(this.datum, (Object)member)) continue;
                    return;
                }
                throw new IllegalArgumentException(Resources.forProperties(properties).getString((short)104, IdentifiedObjects.getDisplayName(this.ensemble), IdentifiedObjects.getDisplayName(this.datum)));
            }
            ArgumentChecks.ensureNonEmpty((String)"ensemble", this.ensemble.getMembers());
        }
    }

    AbstractSingleCRS(AbstractSingleCRS<D> original, ReferenceIdentifier id, AbstractCS cs) {
        super(original, id, cs);
        this.datum = original.datum;
        this.ensemble = original.ensemble;
    }

    AbstractSingleCRS(SingleCRS crs) {
        super((CoordinateReferenceSystem)crs);
        this.datum = crs.getDatum();
        if (this.datum instanceof DefaultDatumEnsemble) {
            throw new IllegalArgumentException(Errors.format((short)73, (Object)"datum", DefaultDatumEnsemble.class));
        }
        this.ensemble = AbstractSingleCRS.getDatumEnsemble((CoordinateReferenceSystem)crs);
        this.checkDatum(null);
    }

    public Class<? extends SingleCRS> getInterface() {
        return SingleCRS.class;
    }

    public D getDatum() {
        return this.datum;
    }

    public DefaultDatumEnsemble<D> getDatumEnsemble() {
        return this.ensemble;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode)) {
            if (mode == ComparisonMode.STRICT) {
                AbstractSingleCRS that = (AbstractSingleCRS)object;
                return Objects.equals(this.datum, that.datum) && Objects.equals(this.ensemble, that.ensemble);
            }
            SingleCRS that = (SingleCRS)object;
            D d1 = this.getDatum();
            Datum d2 = that.getDatum();
            if (mode == ComparisonMode.DEBUG) {
                mode = ComparisonMode.ALLOW_VARIANT;
            }
            if (Utilities.deepEquals(d1, (Object)d2, (ComparisonMode)mode)) {
                if (d1 != null && d2 != null && mode.isCompatibility()) {
                    return true;
                }
                return Utilities.deepEquals(this.getDatumEnsemble(), AbstractSingleCRS.getDatumEnsemble((CoordinateReferenceSystem)that), (ComparisonMode)mode);
            }
            if (mode.isCompatibility()) {
                return DatumOrEnsemble.isLegacyDatum(this.getDatumEnsemble(), d2, mode) || DatumOrEnsemble.isLegacyDatum(AbstractSingleCRS.getDatumEnsemble((CoordinateReferenceSystem)that), d1, mode);
            }
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.datum, this.ensemble);
    }

    AbstractSingleCRS() {
        this.ensemble = null;
    }

    final void setDatum(String name, D value) {
        if (this.datum == null) {
            this.datum = value;
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractSingleCRS.class, (String)"setDatum", (String)name);
        }
    }
}

