/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.apache.nifi.nar.InstanceClassLoader;

public class SharedInstanceClassLoader
extends InstanceClassLoader {
    private long referenceCount = 0L;
    private boolean closed = false;

    public SharedInstanceClassLoader(String identifier, String type, Set<URL> instanceUrls, Set<URL> additionalResourceUrls, Set<File> narNativeLibDirs, ClassLoader parent) {
        super(identifier, type, instanceUrls, additionalResourceUrls, narNativeLibDirs, parent);
    }

    @Override
    public synchronized void close() throws IOException {
        --this.referenceCount;
        if (this.referenceCount <= 0L) {
            this.closed = true;
            super.close();
        }
    }

    public synchronized boolean incrementReferenceCount() {
        if (this.closed) {
            return false;
        }
        ++this.referenceCount;
        return true;
    }
}

