/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

abstract class PaddingEvaluator
extends StringEvaluator {
    public static final String DEFAULT_PADDING_STRING = "_";
    private final Evaluator<String> subject;
    private final Evaluator<Long> desiredLength;
    private final Evaluator<String> pad;

    PaddingEvaluator(Evaluator<String> subject, Evaluator<Long> desiredLength, Evaluator<String> pad) {
        this.subject = subject;
        this.desiredLength = desiredLength;
        this.pad = pad;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        String s;
        String subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new StringQueryResult(null);
        }
        Long desiredLengthValue = this.desiredLength.evaluate(evaluationContext).getValue();
        if (desiredLengthValue == null || desiredLengthValue > Integer.MAX_VALUE || desiredLengthValue <= 0L) {
            return new StringQueryResult(subjectValue);
        }
        String padValue = DEFAULT_PADDING_STRING;
        if (this.pad != null && (s = this.pad.evaluate(evaluationContext).getValue()) != null && !s.isEmpty()) {
            padValue = s;
        }
        return new StringQueryResult(this.doPad(subjectValue, desiredLengthValue.intValue(), padValue));
    }

    protected abstract String doPad(String var1, int var2, String var3);

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

