/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.list.MutableListFactory;

public final class ChunkIterator<T>
implements Iterator<RichIterable<T>> {
    private final Iterator<T> iterator;
    private final int size;
    private final Function0<MutableCollection<T>> speciesNewStrategy;

    public ChunkIterator(Iterable<T> iterable, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        this.size = size;
        this.iterator = iterable.iterator();
        this.speciesNewStrategy = iterable instanceof MutableCollection ? () -> ((MutableCollection)((MutableCollection)iterable)).newEmpty() : () -> ((MutableListFactory)Lists.mutable).empty();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public RichIterable<T> next() {
        if (!this.iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        MutableCollection result = (MutableCollection)this.speciesNewStrategy.value();
        for (int i = this.size; i > 0 && this.iterator.hasNext(); --i) {
            result.add(this.iterator.next());
        }
        return result;
    }
}

