/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.rowgenerator;

import org.apache.hop.core.Const;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.rowgenerator.GeneratorField;
import org.apache.hop.pipeline.transforms.rowgenerator.RowGeneratorMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RowGeneratorDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = RowGeneratorMeta.class;
    public static final String CONST_SYSTEM_COMBO_YES = "System.Combo.Yes";
    private Label wlLimit;
    private TextVar wLimit;
    private Button wNeverEnding;
    private Label wlInterval;
    private TextVar wInterval;
    private Label wlRowTimeField;
    private TextVar wRowTimeField;
    private Label wlLastTimeField;
    private TextVar wLastTimeField;
    private TableView wFields;
    private final RowGeneratorMeta input;

    public RowGeneratorDialog(Shell parent, IVariables variables, RowGeneratorMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"RowGeneratorDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        this.wlLimit = new Label((Composite)this.shell, 131072);
        this.wlLimit.setText(BaseMessages.getString(PKG, (String)"RowGeneratorDialog.Limit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.right = new FormAttachment(middle, -margin);
        fdlLimit.top = new FormAttachment((Control)lastControl, margin);
        this.wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wLimit);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(middle, 0);
        fdLimit.top = new FormAttachment((Control)lastControl, margin);
        fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)fdLimit);
        lastControl = this.wLimit;
        Label wlNeverEnding = new Label((Composite)this.shell, 131072);
        wlNeverEnding.setText(BaseMessages.getString(PKG, (String)"RowGeneratorDialog.NeverEnding.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlNeverEnding);
        FormData fdlNeverEnding = new FormData();
        fdlNeverEnding.left = new FormAttachment(0, 0);
        fdlNeverEnding.right = new FormAttachment(middle, -margin);
        fdlNeverEnding.top = new FormAttachment((Control)lastControl, margin);
        wlNeverEnding.setLayoutData((Object)fdlNeverEnding);
        this.wNeverEnding = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wNeverEnding);
        this.wNeverEnding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RowGeneratorDialog.this.updateWidgets();
            }
        });
        FormData fdNeverEnding = new FormData();
        fdNeverEnding.left = new FormAttachment(middle, 0);
        fdNeverEnding.top = new FormAttachment((Control)wlNeverEnding, 0, 0x1000000);
        fdNeverEnding.right = new FormAttachment(100, 0);
        this.wNeverEnding.setLayoutData((Object)fdNeverEnding);
        lastControl = wlNeverEnding;
        this.wlInterval = new Label((Composite)this.shell, 131072);
        this.wlInterval.setText(BaseMessages.getString(PKG, (String)"RowGeneratorDialog.Interval.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlInterval);
        FormData fdlInterval = new FormData();
        fdlInterval.left = new FormAttachment(0, 0);
        fdlInterval.right = new FormAttachment(middle, -margin);
        fdlInterval.top = new FormAttachment((Control)lastControl, margin);
        this.wlInterval.setLayoutData((Object)fdlInterval);
        this.wInterval = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wInterval);
        FormData fdInterval = new FormData();
        fdInterval.left = new FormAttachment(middle, 0);
        fdInterval.top = new FormAttachment((Control)lastControl, margin);
        fdInterval.right = new FormAttachment(100, 0);
        this.wInterval.setLayoutData((Object)fdInterval);
        lastControl = this.wInterval;
        this.wlRowTimeField = new Label((Composite)this.shell, 131072);
        this.wlRowTimeField.setText(BaseMessages.getString(PKG, (String)"RowGeneratorDialog.RowTimeField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlRowTimeField);
        FormData fdlRowTimeField = new FormData();
        fdlRowTimeField.left = new FormAttachment(0, 0);
        fdlRowTimeField.right = new FormAttachment(middle, -margin);
        fdlRowTimeField.top = new FormAttachment((Control)lastControl, margin);
        this.wlRowTimeField.setLayoutData((Object)fdlRowTimeField);
        this.wRowTimeField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wRowTimeField);
        FormData fdRowTimeField = new FormData();
        fdRowTimeField.left = new FormAttachment(middle, 0);
        fdRowTimeField.top = new FormAttachment((Control)lastControl, margin);
        fdRowTimeField.right = new FormAttachment(100, 0);
        this.wRowTimeField.setLayoutData((Object)fdRowTimeField);
        lastControl = this.wRowTimeField;
        this.wlLastTimeField = new Label((Composite)this.shell, 131072);
        this.wlLastTimeField.setText(BaseMessages.getString(PKG, (String)"RowGeneratorDialog.LastTimeField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLastTimeField);
        FormData fdlLastTimeField = new FormData();
        fdlLastTimeField.left = new FormAttachment(0, 0);
        fdlLastTimeField.right = new FormAttachment(middle, -margin);
        fdlLastTimeField.top = new FormAttachment((Control)lastControl, margin);
        this.wlLastTimeField.setLayoutData((Object)fdlLastTimeField);
        this.wLastTimeField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wLastTimeField);
        FormData fdLastTimeField = new FormData();
        fdLastTimeField.left = new FormAttachment(middle, 0);
        fdLastTimeField.top = new FormAttachment((Control)lastControl, margin);
        fdLastTimeField.right = new FormAttachment(100, 0);
        this.wLastTimeField.setLayoutData((Object)fdLastTimeField);
        lastControl = this.wLastTimeField;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"RowGeneratorDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)lastControl, margin);
        wlFields.setLayoutData((Object)fdlFields);
        lastControl = wlFields;
        int nrFields = this.input.getFields().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Name", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Format", (String[])new String[0]), 5, 2), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Precision", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Currency", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Decimal", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Group", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Value", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.SetEmptyString", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)CONST_SYSTEM_COMBO_YES, (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])})};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, nrFields, null, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)lastControl, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.lsResize = event -> {
            Point size = this.shell.getSize();
            this.wFields.setSize(size.x - 10, size.y - 50);
            this.wFields.table.setSize(size.x - 10, size.y - 50);
            this.wFields.redraw();
        };
        this.shell.addListener(11, this.lsResize);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void updateWidgets() {
        boolean neverEnding = this.wNeverEnding.getSelection();
        this.wlLimit.setEnabled(!neverEnding);
        this.wLimit.setEnabled(!neverEnding);
        this.wlInterval.setEnabled(neverEnding);
        this.wInterval.setEnabled(neverEnding);
        this.wlRowTimeField.setEnabled(neverEnding);
        this.wRowTimeField.setEnabled(neverEnding);
        this.wlLastTimeField.setEnabled(neverEnding);
        this.wLastTimeField.setEnabled(neverEnding);
    }

    public void getData() {
        if (this.isDebug()) {
            this.logDebug("getting fields info...");
        }
        this.wLimit.setText(Const.NVL((String)this.input.getRowLimit(), (String)""));
        this.wNeverEnding.setSelection(this.input.isNeverEnding());
        this.wInterval.setText(Const.NVL((String)this.input.getIntervalInMs(), (String)""));
        this.wRowTimeField.setText(Const.NVL((String)this.input.getRowTimeField(), (String)""));
        this.wLastTimeField.setText(Const.NVL((String)this.input.getLastTimeField(), (String)""));
        for (int i = 0; i < this.input.getFields().size(); ++i) {
            GeneratorField field = this.input.getFields().get(i);
            TableItem item = this.wFields.table.getItem(i);
            int col = 1;
            item.setText(col++, Const.NVL((String)field.getName(), (String)""));
            String type = field.getType();
            String format = field.getFormat();
            String length = field.getLength() < 0 ? "" : "" + field.getLength();
            String prec = field.getPrecision() < 0 ? "" : "" + field.getPrecision();
            String curr = field.getCurrency();
            String group = field.getGroup();
            String decim = field.getDecimal();
            String def = field.getValue();
            item.setText(col++, Const.NVL((String)type, (String)""));
            item.setText(col++, Const.NVL((String)format, (String)""));
            item.setText(col++, Const.NVL((String)length, (String)""));
            item.setText(col++, Const.NVL((String)prec, (String)""));
            item.setText(col++, Const.NVL((String)curr, (String)""));
            item.setText(col++, Const.NVL((String)decim, (String)""));
            item.setText(col++, Const.NVL((String)group, (String)""));
            item.setText(col++, Const.NVL((String)def, (String)""));
            item.setText(col++, field.isSetEmptyString() ? BaseMessages.getString(PKG, (String)CONST_SYSTEM_COMBO_YES, (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.updateWidgets();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        try {
            this.getInfo(this.input);
            this.input.setChanged();
            this.dispose();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RowGeneratorDialog.Illegal.Dialog.Settings.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RowGeneratorDialog.Illegal.Dialog.Settings.Message", (String[])new String[0]), e);
        }
    }

    private void getInfo(RowGeneratorMeta meta) {
        meta.setRowLimit(this.wLimit.getText());
        meta.setNeverEnding(this.wNeverEnding.getSelection());
        meta.setIntervalInMs(this.wInterval.getText());
        meta.setRowTimeField(this.wRowTimeField.getText());
        meta.setLastTimeField(this.wLastTimeField.getText());
        meta.getFields().clear();
        for (TableItem item : this.wFields.getNonEmptyItems()) {
            GeneratorField field = new GeneratorField();
            field.setName(item.getText(1));
            field.setFormat(item.getText(3));
            field.setLength(Const.toInt((String)item.getText(4), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(5), (int)-1));
            field.setCurrency(item.getText(6));
            field.setDecimal(item.getText(7));
            field.setGroup(item.getText(8));
            field.setValue(field.isSetEmptyString() ? "" : item.getText(9));
            field.setSetEmptyString(BaseMessages.getString(PKG, (String)CONST_SYSTEM_COMBO_YES, (String[])new String[0]).equalsIgnoreCase(item.getText(10)));
            field.setType(field.isSetEmptyString() ? "String" : item.getText(2));
            meta.getFields().add(field);
        }
    }

    private void preview() {
        RowGeneratorMeta oneMeta = new RowGeneratorMeta();
        try {
            this.getInfo(oneMeta);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RowGeneratorDialog.Illegal.Dialog.Settings.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RowGeneratorDialog.Illegal.Dialog.Settings.Message", (String[])new String[0]), e);
            return;
        }
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"System.Dialog.EnterPreviewSize.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.EnterPreviewSize.Message", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            oneMeta.setRowLimit(Integer.toString(previewSize));
            PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            Pipeline pipeline = progressDialog.getPipeline();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
            prd.open();
        }
    }
}

